"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_ai-chat-ui_lib_browser_chat-response-renderer_index_js"],{

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/ai-selection-resolver.js":
/*!********************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/ai-selection-resolver.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TextFragmentSelectionResolver = exports.TypeDocSymbolSelectionResolver = exports.GitHubSelectionResolver = exports.LOCATION_REGEX = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const languageFeatures_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/common/services/languageFeatures */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/common/services/languageFeatures.js");
const standaloneServices_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/standalone/browser/standaloneServices */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/standalone/browser/standaloneServices.js");
const monaco_editor_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-editor */ "../../node_modules/@theia/monaco/lib/browser/monaco-editor.js");
const monaco_to_protocol_converter_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-to-protocol-converter */ "../../node_modules/@theia/monaco/lib/browser/monaco-to-protocol-converter.js");
/** Regex to match GitHub-style position and range declaration with line (L) and column (C) */
exports.LOCATION_REGEX = /#L(\d+)?(?:C(\d+))?(?:-L(\d+)?(?:C(\d+))?)?$/;
let GitHubSelectionResolver = class GitHubSelectionResolver {
    constructor() {
        this.priority = 100;
    }
    async resolveSelection(widget, options, uri) {
        if (!uri) {
            return;
        }
        // We allow the GitHub syntax of selecting a range in markdown 'L1', 'L1-L2' 'L1-C1_L2-C2' (starting at line 1 and column 1)
        const match = uri === null || uri === void 0 ? void 0 : uri.toString().match(exports.LOCATION_REGEX);
        if (!match) {
            return;
        }
        // we need to adapt the position information from one-based (in GitHub) to zero-based (in Theia)
        const startLine = match[1] ? parseInt(match[1], 10) - 1 : undefined;
        // if no start column is given, we assume the start of the line
        const startColumn = match[2] ? parseInt(match[2], 10) - 1 : 0;
        const endLine = match[3] ? parseInt(match[3], 10) - 1 : undefined;
        // if no end column is given, we assume the end of the line
        const endColumn = match[4] ? parseInt(match[4], 10) - 1 : endLine ? widget.editor.document.getLineMaxColumn(endLine) : undefined;
        return {
            start: { line: startLine, character: startColumn },
            end: { line: endLine, character: endColumn }
        };
    }
};
exports.GitHubSelectionResolver = GitHubSelectionResolver;
exports.GitHubSelectionResolver = GitHubSelectionResolver = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], GitHubSelectionResolver);
let TypeDocSymbolSelectionResolver = class TypeDocSymbolSelectionResolver {
    constructor() {
        this.priority = 50;
    }
    async resolveSelection(widget, options, uri) {
        if (!uri) {
            return;
        }
        const editor = monaco_editor_1.MonacoEditor.get(widget);
        const monacoEditor = editor === null || editor === void 0 ? void 0 : editor.getControl();
        if (!monacoEditor) {
            return;
        }
        const symbolPath = this.findSymbolPath(uri);
        if (!symbolPath) {
            return;
        }
        const textModel = monacoEditor.getModel();
        if (!textModel) {
            return;
        }
        // try to find the symbol through the document symbol provider
        // support referencing nested symbols by separating a dot path similar to TypeDoc
        for (const provider of standaloneServices_1.StandaloneServices.get(languageFeatures_1.ILanguageFeaturesService).documentSymbolProvider.ordered(textModel)) {
            const symbols = await provider.provideDocumentSymbols(textModel, core_1.CancellationToken.None);
            const match = this.findSymbolByPath(symbols !== null && symbols !== void 0 ? symbols : [], symbolPath);
            if (match) {
                return this.m2p.asRange(match.selectionRange);
            }
        }
    }
    findSymbolPath(uri) {
        return uri.fragment.split('.');
    }
    findSymbolByPath(symbols, symbolPath) {
        if (!symbols || symbolPath.length === 0) {
            return undefined;
        }
        let matchedSymbol = undefined;
        let currentSymbols = symbols;
        for (const part of symbolPath) {
            matchedSymbol = currentSymbols.find(symbol => symbol.name === part);
            if (!matchedSymbol) {
                return undefined;
            }
            currentSymbols = matchedSymbol.children || [];
        }
        return matchedSymbol;
    }
};
exports.TypeDocSymbolSelectionResolver = TypeDocSymbolSelectionResolver;
tslib_1.__decorate([
    (0, inversify_1.inject)(monaco_to_protocol_converter_1.MonacoToProtocolConverter),
    tslib_1.__metadata("design:type", monaco_to_protocol_converter_1.MonacoToProtocolConverter)
], TypeDocSymbolSelectionResolver.prototype, "m2p", void 0);
exports.TypeDocSymbolSelectionResolver = TypeDocSymbolSelectionResolver = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TypeDocSymbolSelectionResolver);
let TextFragmentSelectionResolver = class TextFragmentSelectionResolver {
    async resolveSelection(widget, options, uri) {
        var _a, _b, _c;
        if (!uri) {
            return;
        }
        const fragment = this.findFragment(uri);
        if (!fragment) {
            return;
        }
        const matches = (_c = (_b = (_a = widget.editor.document).findMatches) === null || _b === void 0 ? void 0 : _b.call(_a, { isRegex: false, matchCase: false, matchWholeWord: false, searchString: fragment })) !== null && _c !== void 0 ? _c : [];
        if (matches.length > 0) {
            return {
                start: {
                    line: matches[0].range.start.line - 1,
                    character: matches[0].range.start.character - 1
                },
                end: {
                    line: matches[0].range.end.line - 1,
                    character: matches[0].range.end.character - 1
                }
            };
        }
    }
    findFragment(uri) {
        return uri.fragment;
    }
};
exports.TextFragmentSelectionResolver = TextFragmentSelectionResolver;
exports.TextFragmentSelectionResolver = TextFragmentSelectionResolver = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TextFragmentSelectionResolver);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/code-part-renderer.js":
/*!*****************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/code-part-renderer.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CodeWrapper = exports.InsertCodeAtCursorButtonAction = exports.CopyToClipboardButtonAction = exports.CodePartRenderer = exports.CodePartRendererAction = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const common_1 = __webpack_require__(/*! @theia/ai-chat/lib/common */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const clipboard_service_1 = __webpack_require__(/*! @theia/core/lib/browser/clipboard-service */ "../../node_modules/@theia/core/lib/browser/clipboard-service.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const browser_2 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
const monaco_editor_provider_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-editor-provider */ "../../node_modules/@theia/monaco/lib/browser/monaco-editor-provider.js");
const monaco_languages_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-languages */ "../../node_modules/@theia/monaco/lib/browser/monaco-languages.js");
const chat_view_tree_widget_1 = __webpack_require__(/*! ../chat-tree-view/chat-view-tree-widget */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-tree-view/chat-view-tree-widget.js");
exports.CodePartRendererAction = Symbol('CodePartRendererAction');
let CodePartRenderer = class CodePartRenderer {
    canHandle(response) {
        if (common_1.CodeChatResponseContent.is(response)) {
            return 10;
        }
        return -1;
    }
    render(response, parentNode) {
        const language = response.language ? this.languageService.getExtension(response.language) : undefined;
        return (React.createElement("div", { className: "theia-CodePartRenderer-root" },
            React.createElement("div", { className: "theia-CodePartRenderer-top" },
                React.createElement("div", { className: "theia-CodePartRenderer-left" }, this.renderTitle(response)),
                React.createElement("div", { className: "theia-CodePartRenderer-right theia-CodePartRenderer-actions" }, this.codePartRendererActions.getContributions()
                    .filter(action => action.canRender ? action.canRender(response, parentNode) : true)
                    .sort((a, b) => a.priority - b.priority)
                    .map(action => action.render(response, parentNode)))),
            React.createElement("div", { className: "theia-CodePartRenderer-separator" }),
            React.createElement("div", { className: "theia-CodePartRenderer-bottom" },
                React.createElement(exports.CodeWrapper, { content: response.code, language: language, editorProvider: this.editorProvider, untitledResourceResolver: this.untitledResourceResolver, contextMenuCallback: e => this.handleContextMenuEvent(parentNode, e, response.code) }))));
    }
    renderTitle(response) {
        var _a, _b, _c, _d;
        const uri = (_a = response.location) === null || _a === void 0 ? void 0 : _a.uri;
        const position = (_b = response.location) === null || _b === void 0 ? void 0 : _b.position;
        if (uri && position) {
            return React.createElement("a", { onClick: this.openFileAtPosition.bind(this, uri, position) }, this.getTitle((_c = response.location) === null || _c === void 0 ? void 0 : _c.uri, response.language));
        }
        return this.getTitle((_d = response.location) === null || _d === void 0 ? void 0 : _d.uri, response.language);
    }
    getTitle(uri, language) {
        var _a, _b, _c;
        // If there is a URI, use the file name as the title. Otherwise, use the language as the title.
        // If there is no language, use a generic fallback title.
        return (_c = (_b = (_a = uri === null || uri === void 0 ? void 0 : uri.path) === null || _a === void 0 ? void 0 : _a.toString().split('/').pop()) !== null && _b !== void 0 ? _b : language) !== null && _c !== void 0 ? _c : nls_1.nls.localize('theia/ai/chat-ui/code-part-renderer/generatedCode', 'Generated Code');
    }
    /**
     * Opens a file and moves the cursor to the specified position.
     *
     * @param uri - The URI of the file to open.
     * @param position - The position to move the cursor to, specified as {line, character}.
     */
    async openFileAtPosition(uri, position) {
        const editorWidget = await this.editorManager.open(uri);
        if (editorWidget) {
            const editor = editorWidget.editor;
            editor.revealPosition(position);
            editor.focus();
            editor.cursor = position;
        }
    }
    handleContextMenuEvent(node, event, code) {
        this.contextMenuRenderer.render({
            menuPath: chat_view_tree_widget_1.ChatViewTreeWidget.CONTEXT_MENU,
            anchor: { x: event.posx, y: event.posy },
            args: [node, { code }],
            context: event.target
        });
        event.preventDefault();
    }
};
exports.CodePartRenderer = CodePartRenderer;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.EditorManager),
    tslib_1.__metadata("design:type", browser_2.EditorManager)
], CodePartRenderer.prototype, "editorManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.UntitledResourceResolver),
    tslib_1.__metadata("design:type", core_1.UntitledResourceResolver)
], CodePartRenderer.prototype, "untitledResourceResolver", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(monaco_editor_provider_1.MonacoEditorProvider),
    tslib_1.__metadata("design:type", monaco_editor_provider_1.MonacoEditorProvider)
], CodePartRenderer.prototype, "editorProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(monaco_languages_1.MonacoLanguages),
    tslib_1.__metadata("design:type", monaco_languages_1.MonacoLanguages)
], CodePartRenderer.prototype, "languageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ContextMenuRenderer),
    tslib_1.__metadata("design:type", browser_1.ContextMenuRenderer)
], CodePartRenderer.prototype, "contextMenuRenderer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ContributionProvider),
    (0, inversify_1.named)(exports.CodePartRendererAction),
    tslib_1.__metadata("design:type", Object)
], CodePartRenderer.prototype, "codePartRendererActions", void 0);
exports.CodePartRenderer = CodePartRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], CodePartRenderer);
let CopyToClipboardButtonAction = class CopyToClipboardButtonAction {
    constructor() {
        this.priority = 10;
    }
    render(response) {
        return React.createElement(CopyToClipboardButton, { key: 'copyToClipBoard', code: response.code, clipboardService: this.clipboardService });
    }
};
exports.CopyToClipboardButtonAction = CopyToClipboardButtonAction;
tslib_1.__decorate([
    (0, inversify_1.inject)(clipboard_service_1.ClipboardService),
    tslib_1.__metadata("design:type", Object)
], CopyToClipboardButtonAction.prototype, "clipboardService", void 0);
exports.CopyToClipboardButtonAction = CopyToClipboardButtonAction = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], CopyToClipboardButtonAction);
const CopyToClipboardButton = (props) => {
    const { code, clipboardService } = props;
    const copyCodeToClipboard = React.useCallback(() => {
        clipboardService.writeText(code);
    }, [code, clipboardService]);
    return React.createElement("div", { className: 'button codicon codicon-copy', title: nls_1.nls.localizeByDefault('Copy'), role: 'button', onClick: copyCodeToClipboard });
};
let InsertCodeAtCursorButtonAction = class InsertCodeAtCursorButtonAction {
    constructor() {
        this.priority = 20;
    }
    render(response) {
        return React.createElement(InsertCodeAtCursorButton, { key: 'insertCodeAtCursor', code: response.code, editorManager: this.editorManager });
    }
};
exports.InsertCodeAtCursorButtonAction = InsertCodeAtCursorButtonAction;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.EditorManager),
    tslib_1.__metadata("design:type", browser_2.EditorManager)
], InsertCodeAtCursorButtonAction.prototype, "editorManager", void 0);
exports.InsertCodeAtCursorButtonAction = InsertCodeAtCursorButtonAction = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], InsertCodeAtCursorButtonAction);
const InsertCodeAtCursorButton = (props) => {
    const { code, editorManager } = props;
    const insertCode = React.useCallback(() => {
        const editor = editorManager.currentEditor;
        if (editor) {
            const currentEditor = editor.editor;
            const selection = currentEditor.selection;
            // Insert the text at the current cursor position
            // If there is a selection, replace the selection with the text
            currentEditor.executeEdits([{
                    range: {
                        start: selection.start,
                        end: selection.end
                    },
                    newText: code
                }]);
        }
    }, [code, editorManager]);
    return React.createElement("div", { className: 'button codicon codicon-insert', title: nls_1.nls.localizeByDefault('Insert At Cursor'), role: 'button', onClick: insertCode });
};
/**
 * Renders the given code within a Monaco Editor
 */
const CodeWrapper = (props) => {
    var _a;
    // eslint-disable-next-line no-null/no-null
    const ref = React.useRef(null);
    const editorRef = React.useRef(undefined);
    const createInputElement = async () => {
        const resource = await props.untitledResourceResolver.createUntitledResource(undefined, props.language);
        const editor = await props.editorProvider.createSimpleInline(resource.uri, ref.current, {
            readOnly: true,
            autoSizing: true,
            scrollBeyondLastLine: false,
            scrollBeyondLastColumn: 0,
            renderFinalNewline: 'off',
            maxHeight: -1,
            scrollbar: {
                vertical: 'hidden',
                alwaysConsumeMouseWheel: false
            },
            wordWrap: 'off',
            codeLens: false,
            inlayHints: { enabled: 'off' },
            hover: { enabled: false }
        });
        editor.document.textEditorModel.setValue(props.content);
        editor.getControl().onContextMenu(e => props.contextMenuCallback(e.event));
        editorRef.current = editor;
    };
    React.useEffect(() => {
        createInputElement();
        return () => {
            if (editorRef.current) {
                editorRef.current.dispose();
            }
        };
    }, []);
    React.useEffect(() => {
        if (editorRef.current) {
            editorRef.current.document.textEditorModel.setValue(props.content);
        }
    }, [props.content]);
    (_a = editorRef.current) === null || _a === void 0 ? void 0 : _a.resizeToFit();
    return React.createElement("div", { className: 'theia-CodeWrapper', ref: ref });
};
exports.CodeWrapper = CodeWrapper;


/***/ }),

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/command-part-renderer.js":
/*!********************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/command-part-renderer.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CommandPartRenderer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/ai-chat/lib/common */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
let CommandPartRenderer = class CommandPartRenderer {
    canHandle(response) {
        if (common_1.CommandChatResponseContent.is(response)) {
            return 10;
        }
        return -1;
    }
    render(response) {
        var _a, _b, _c, _d, _e, _f;
        const label = (_f = (_d = (_b = (_a = response.customCallback) === null || _a === void 0 ? void 0 : _a.label) !== null && _b !== void 0 ? _b : (_c = response.command) === null || _c === void 0 ? void 0 : _c.label) !== null && _d !== void 0 ? _d : (_e = response.command) === null || _e === void 0 ? void 0 : _e.id.split('-').map(s => s[0].toUpperCase() + s.substring(1)).join(' ')) !== null && _f !== void 0 ? _f : 'Execute';
        if (!response.customCallback && response.command) {
            const isCommandEnabled = this.commandRegistry.isEnabled(response.command.id);
            if (!isCommandEnabled) {
                return React.createElement("div", null,
                    "The command has the id \"",
                    response.command.id,
                    "\" but it is not executable from the Chat window.");
            }
        }
        return React.createElement("button", { className: 'theia-button main', onClick: this.onCommand.bind(this, response) }, label);
    }
    onCommand(arg) {
        var _a;
        if (arg.customCallback) {
            arg.customCallback.callback().catch(e => { console.error(e); });
        }
        else if (arg.command) {
            this.commandService.executeCommand(arg.command.id, ...((_a = arg.arguments) !== null && _a !== void 0 ? _a : [])).catch(e => { console.error(e); });
        }
        else {
            console.warn('No command or custom callback provided in command chat response content');
        }
    }
};
exports.CommandPartRenderer = CommandPartRenderer;
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.CommandService),
    tslib_1.__metadata("design:type", Object)
], CommandPartRenderer.prototype, "commandService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.CommandRegistry),
    tslib_1.__metadata("design:type", core_1.CommandRegistry)
], CommandPartRenderer.prototype, "commandRegistry", void 0);
exports.CommandPartRenderer = CommandPartRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], CommandPartRenderer);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/error-part-renderer.js":
/*!******************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/error-part-renderer.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ErrorPartRenderer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/ai-chat/lib/common */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
let ErrorPartRenderer = class ErrorPartRenderer {
    canHandle(response) {
        if (common_1.ErrorChatResponseContent.is(response)) {
            return 10;
        }
        return -1;
    }
    render(response) {
        return React.createElement("div", { className: 'theia-ChatPart-Error' },
            React.createElement("span", { className: 'codicon codicon-error' }),
            React.createElement("span", null, response.error.message));
    }
};
exports.ErrorPartRenderer = ErrorPartRenderer;
exports.ErrorPartRenderer = ErrorPartRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ErrorPartRenderer);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/horizontal-layout-part-renderer.js":
/*!******************************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/horizontal-layout-part-renderer.js ***!
  \******************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.HorizontalLayoutPartRenderer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const chat_response_part_renderer_1 = __webpack_require__(/*! ../chat-response-part-renderer */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-part-renderer.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/ai-chat/lib/common */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
let HorizontalLayoutPartRenderer = class HorizontalLayoutPartRenderer {
    canHandle(response) {
        if (common_1.HorizontalLayoutChatResponseContent.is(response)) {
            return 10;
        }
        return -1;
    }
    render(response, parentNode) {
        const contributions = this.chatResponsePartRenderers.getContributions();
        return (React.createElement("div", { className: "ai-chat-horizontal-layout", style: { display: 'flex', flexDirection: 'row', flexWrap: 'wrap' } }, response.content.map(content => {
            const renderer = contributions
                .map(c => ({
                prio: c.canHandle(content),
                renderer: c,
            }))
                .sort((a, b) => b.prio - a.prio)[0].renderer;
            return renderer.render(content, parentNode);
        })));
    }
};
exports.HorizontalLayoutPartRenderer = HorizontalLayoutPartRenderer;
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ContributionProvider),
    (0, inversify_1.named)(chat_response_part_renderer_1.ChatResponsePartRenderer),
    tslib_1.__metadata("design:type", Object)
], HorizontalLayoutPartRenderer.prototype, "chatResponsePartRenderers", void 0);
exports.HorizontalLayoutPartRenderer = HorizontalLayoutPartRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], HorizontalLayoutPartRenderer);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/index.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/index.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
tslib_1.__exportStar(__webpack_require__(/*! ./ai-selection-resolver */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/ai-selection-resolver.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./code-part-renderer */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/code-part-renderer.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./command-part-renderer */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/command-part-renderer.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./error-part-renderer */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/error-part-renderer.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./horizontal-layout-part-renderer */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/horizontal-layout-part-renderer.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./markdown-part-renderer */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/markdown-part-renderer.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./text-part-renderer */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/text-part-renderer.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./toolcall-part-renderer */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/toolcall-part-renderer.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./thinking-part-renderer */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/thinking-part-renderer.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./progress-part-renderer */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/progress-part-renderer.js"), exports);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/progress-part-renderer.js":
/*!*********************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/progress-part-renderer.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProgressPartRenderer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/ai-chat/lib/common */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const chat_progress_message_1 = __webpack_require__(/*! ../chat-progress-message */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-progress-message.js");
let ProgressPartRenderer = class ProgressPartRenderer {
    canHandle(response) {
        if (common_1.ProgressChatResponseContent.is(response)) {
            return 10;
        }
        return -1;
    }
    render(response) {
        return (React.createElement(chat_progress_message_1.ProgressMessage, { content: response.message, status: 'inProgress' }));
    }
};
exports.ProgressPartRenderer = ProgressPartRenderer;
exports.ProgressPartRenderer = ProgressPartRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ProgressPartRenderer);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/text-part-renderer.js":
/*!*****************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/text-part-renderer.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TextPartRenderer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/ai-chat/lib/common */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
let TextPartRenderer = class TextPartRenderer {
    canHandle(_reponse) {
        // this is the fallback renderer
        return 1;
    }
    render(response) {
        if (response && common_1.ChatResponseContent.hasAsString(response)) {
            return React.createElement("span", null, response.asString());
        }
        return React.createElement("span", null,
            nls_1.nls.localize('theia/ai/chat-ui/text-part-renderer/cantDisplay', "Can't display response, please check your ChatResponsePartRenderers!"),
            " ",
            JSON.stringify(response));
    }
};
exports.TextPartRenderer = TextPartRenderer;
exports.TextPartRenderer = TextPartRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TextPartRenderer);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/thinking-part-renderer.js":
/*!*********************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/thinking-part-renderer.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ThinkingPartRenderer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/ai-chat/lib/common */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
let ThinkingPartRenderer = class ThinkingPartRenderer {
    canHandle(response) {
        if (common_1.ThinkingChatResponseContent.is(response)) {
            return 10;
        }
        return -1;
    }
    render(response) {
        return (React.createElement("div", { className: 'theia-thinking' },
            React.createElement("details", null,
                React.createElement("summary", null, nls_1.nls.localize('theia/ai/chat-ui/thinking-part-renderer/thinking', 'Thinking')),
                React.createElement("pre", null, response.content))));
    }
};
exports.ThinkingPartRenderer = ThinkingPartRenderer;
exports.ThinkingPartRenderer = ThinkingPartRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ThinkingPartRenderer);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/toolcall-part-renderer.js":
/*!*********************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/toolcall-part-renderer.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToolCallPartRenderer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/ai-chat/lib/common */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
let ToolCallPartRenderer = class ToolCallPartRenderer {
    canHandle(response) {
        if (common_1.ToolCallChatResponseContent.is(response)) {
            return 10;
        }
        return -1;
    }
    render(response) {
        return (React.createElement("h4", { className: 'theia-toolCall' }, response.finished ? (React.createElement("details", null,
            React.createElement("summary", null,
                nls_1.nls.localize('theia/ai/chat-ui/toolcall-part-renderer/finished', 'Ran'),
                " ",
                response.name,
                "(",
                this.renderCollapsibleArguments(response.arguments),
                ")"),
            React.createElement("pre", null, this.tryPrettyPrintJson(response)))) : (React.createElement("span", null,
            React.createElement(Spinner, null),
            " ",
            nls_1.nls.localizeByDefault('Running'),
            " ",
            response.name,
            "(",
            this.renderCollapsibleArguments(response.arguments),
            ")"))));
    }
    renderCollapsibleArguments(args) {
        if (!args || !args.trim() || args.trim() === '{}') {
            return undefined;
        }
        return (React.createElement("details", { className: "collapsible-arguments" },
            React.createElement("summary", { className: "collapsible-arguments-summary" }, "..."),
            React.createElement("span", null, this.prettyPrintArgs(args))));
    }
    prettyPrintArgs(args) {
        try {
            return JSON.stringify(JSON.parse(args), undefined, 2);
        }
        catch (e) {
            // fall through
            return args;
        }
    }
    tryPrettyPrintJson(response) {
        let responseContent = response.result;
        try {
            if (responseContent) {
                if (typeof responseContent === 'string') {
                    responseContent = JSON.parse(responseContent);
                }
                responseContent = JSON.stringify(responseContent, undefined, 2);
            }
        }
        catch (e) {
            if (typeof responseContent !== 'string') {
                responseContent = nls_1.nls.localize('theia/ai/chat-ui/toolcall-part-renderer/prettyPrintError', "The content could not be converted to string: '{0}'. This is the original content: '{1}'.", e.message, responseContent);
            }
            // fall through
        }
        return responseContent;
    }
};
exports.ToolCallPartRenderer = ToolCallPartRenderer;
exports.ToolCallPartRenderer = ToolCallPartRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ToolCallPartRenderer);
const Spinner = () => (React.createElement("i", { className: "fa fa-spinner fa-spin" }));


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_ai-chat-ui_lib_browser_chat-response-renderer_index_js.js.map