"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReactAvailableViewsWidget = void 0;
const React = __importStar(require("react"));
const output_added_signal_payload_1 = require("traceviewer-base/lib/signals/output-added-signal-payload");
const signal_manager_1 = require("traceviewer-base/lib/signals/signal-manager");
const available_views_component_1 = require("../components/utils/available-views-component");
class ReactAvailableViewsWidget extends React.Component {
    constructor(props) {
        super(props);
        this._onExperimentSelected = (experiment) => this.doHandleExperimentSelectedSignal(experiment);
        this._onExperimentClosed = (experiment) => this.doHandleExperimentClosedSignal(experiment);
        this.handleOutputClicked = (outputDescriptor) => this.doHandleOutputClicked(outputDescriptor);
        this.handleContextMenuEvent = (e, output) => this.doHandleContextMenuEvent(e, output);
        this.updateAvailableViews = async () => this.doUpdateAvailableViews();
        this._experimentManager = this.props.tspClientProvider.getExperimentManager();
        this.props.tspClientProvider.addTspClientChangeListener(() => {
            this._experimentManager = this.props.tspClientProvider.getExperimentManager();
        });
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.EXPERIMENT_SELECTED, this._onExperimentSelected);
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.EXPERIMENT_CLOSED, this._onExperimentClosed);
        this.state = { availableOutputDescriptors: [] };
    }
    componentWillUnmount() {
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.EXPERIMENT_SELECTED, this._onExperimentSelected);
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.EXPERIMENT_CLOSED, this._onExperimentClosed);
    }
    render() {
        var _a;
        return (React.createElement("div", { className: 'trace-explorer-views' },
            React.createElement(available_views_component_1.AvailableViewsComponent, { traceID: (_a = this._selectedExperiment) === null || _a === void 0 ? void 0 : _a.UUID, outputDescriptors: this.state.availableOutputDescriptors, onContextMenuEvent: this.handleContextMenuEvent, onOutputClicked: this.handleOutputClicked, highlightAfterSelection: true })));
    }
    doHandleOutputClicked(selectedOutput) {
        if (selectedOutput && this._selectedExperiment) {
            (0, signal_manager_1.signalManager)().fireOutputAddedSignal(new output_added_signal_payload_1.OutputAddedSignalPayload(selectedOutput, this._selectedExperiment));
        }
    }
    doHandleContextMenuEvent(event, output) {
        if (this.props.contextMenuRenderer && output) {
            this.props.contextMenuRenderer(event, output);
        }
        event.preventDefault();
        event.stopPropagation();
    }
    doHandleExperimentSelectedSignal(experiment) {
        var _a;
        if ((((_a = this._selectedExperiment) === null || _a === void 0 ? void 0 : _a.UUID) !== (experiment === null || experiment === void 0 ? void 0 : experiment.UUID)) || this.state.availableOutputDescriptors.length === 0) {
            this._selectedExperiment = experiment;
            this.setState({ availableOutputDescriptors: [] });
            this.updateAvailableViews();
        }
    }
    doHandleExperimentClosedSignal(experiment) {
        var _a;
        if (((_a = this._selectedExperiment) === null || _a === void 0 ? void 0 : _a.UUID) === (experiment === null || experiment === void 0 ? void 0 : experiment.UUID)) {
            this.setState({ availableOutputDescriptors: [] });
        }
    }
    async doUpdateAvailableViews() {
        let outputs;
        const signalExperiment = this._selectedExperiment;
        if (signalExperiment) {
            outputs = await this.getOutputDescriptors(signalExperiment);
            this.setState({ availableOutputDescriptors: outputs });
        }
        else {
            this.setState({ availableOutputDescriptors: [] });
        }
    }
    async getOutputDescriptors(experiment) {
        const outputDescriptors = [];
        const descriptors = await this._experimentManager.getAvailableOutputs(experiment.UUID);
        if (descriptors && descriptors.length) {
            outputDescriptors.push(...descriptors);
        }
        return outputDescriptors;
    }
}
exports.ReactAvailableViewsWidget = ReactAvailableViewsWidget;
//# sourceMappingURL=trace-explorer-views-widget.js.map