/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.lock;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.ui.AbstractSVNView;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.lock.LocksComposite;
import org.eclipse.team.svn.ui.operation.ScanLocksOperation;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class LocksView
extends AbstractSVNView {
    public static final String VIEW_ID = LocksView.class.getName();
    protected LocksComposite locksComposite;
    protected Action linkWithEditorAction;
    protected Action linkWithEditorDropDownAction;

    public LocksView() {
        super(SVNUIMessages.LocksView_SVNLocks);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.isLinkWithEditorEnabled = SVNTeamPreferences.getPropertiesBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "locksLinkWithEditor");
        this.locksComposite = new LocksComposite(parent);
        this.locksComposite.setLayoutData(new GridData(1808));
        this.refresh();
        this.createActionBars();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.team.svn.help.locksViewContext");
    }

    protected void createActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager actionBarsMenu = actionBars.getMenuManager();
        this.linkWithEditorDropDownAction = new Action(SVNUIMessages.SVNView_LinkWith_Label, 2){

            public void run() {
                LocksView.this.linkWithEditor();
                LocksView.this.linkWithEditorAction.setChecked(LocksView.this.isLinkWithEditorEnabled);
            }
        };
        this.linkWithEditorDropDownAction.setChecked(this.isLinkWithEditorEnabled);
        actionBarsMenu.add((IAction)this.linkWithEditorDropDownAction);
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.removeAll();
        Action action = new Action(SVNUIMessages.SVNView_Refresh_Label){

            public void run() {
                LocksView.this.refresh();
            }
        };
        action.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/refresh.gif"));
        tbm.add((IAction)action);
        tbm.add((IAction)this.getLinkWithEditorAction());
        tbm.update(true);
        this.getSite().getPage().addSelectionListener(this.selectionListener);
    }

    protected Action getLinkWithEditorAction() {
        this.linkWithEditorAction = new Action(SVNUIMessages.SVNView_LinkWith_Label, 2){

            public void run() {
                LocksView.this.linkWithEditor();
                LocksView.this.linkWithEditorDropDownAction.setChecked(LocksView.this.isLinkWithEditorEnabled);
            }
        };
        this.linkWithEditorAction.setToolTipText(SVNUIMessages.SVNView_LinkWith_ToolTip);
        this.linkWithEditorAction.setDisabledImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/link_with_disabled.gif"));
        this.linkWithEditorAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/link_with.gif"));
        this.linkWithEditorAction.setChecked(this.isLinkWithEditorEnabled);
        return this.linkWithEditorAction;
    }

    protected void linkWithEditor() {
        this.isLinkWithEditorEnabled = !this.isLinkWithEditorEnabled;
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        SVNTeamPreferences.setPropertiesBoolean(store, "locksLinkWithEditor", this.isLinkWithEditorEnabled);
        if (this.isLinkWithEditorEnabled) {
            this.editorActivated(this.getSite().getPage().getActiveEditor());
        }
    }

    protected void updateViewInput(IResource resource) {
        ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
        if (IStateFilter.SF_VERSIONED.accept(local)) {
            if (resource.equals((Object)this.wcResource)) {
                return;
            }
            this.setResource(resource);
        }
    }

    public void setResourceWithoutActionExecution(IResource resource) {
        this.wcResource = resource;
        this.locksComposite.setResource(resource);
    }

    public void setResource(IResource resource) {
        this.setResourceWithoutActionExecution(resource);
        this.refresh();
    }

    public IActionOperation getUpdateViewOperation() {
        CompositeOperation op = null;
        if (this.wcResource != null) {
            ScanLocksOperation mainOp = new ScanLocksOperation(new IResource[]{this.wcResource});
            op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
            op.add((IActionOperation)new AbstractActionOperation("", SVNUIMessages.class){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    LocksView.this.locksComposite.setPending(true);
                    LocksView.this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            LocksView.this.showResourceLabel();
                            (this).LocksView.this.locksComposite.initializeComposite();
                        }
                    });
                }
            });
            op.add((IActionOperation)mainOp);
            mainOp.setConsoleStream(null);
            final ScanLocksOperation.CreateLockResourcesHierarchyOperation createHierarchyOp = new ScanLocksOperation.CreateLockResourcesHierarchyOperation(mainOp);
            op.add((IActionOperation)createHierarchyOp, new IActionOperation[]{mainOp});
            op.add((IActionOperation)new AbstractActionOperation("", SVNUIMessages.class){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    LocksView.this.locksComposite.setRootLockResource(createHierarchyOp.getLockResourceRoot());
                    UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            (this).LocksView.this.locksComposite.setPending(false);
                            (this).LocksView.this.locksComposite.initializeComposite();
                        }
                    });
                }
            }, new IActionOperation[]{createHierarchyOp});
        }
        return op;
    }

    public void refresh() {
        IActionOperation op = this.getUpdateViewOperation();
        if (op != null) {
            ProgressMonitorUtility.doTaskScheduled((IActionOperation)op, (boolean)false);
        }
    }

    protected void disconnectView() {
        this.locksComposite.disconnectComposite();
        this.wcResource = null;
    }

    protected boolean needsLinkWithEditorAndSelection() {
        return true;
    }

    public void setFocus() {
    }

    public static LocksView instance() {
        final LocksView[] view = new LocksView[1];
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = SVNTeamUIPlugin.instance().getWorkbench().getActiveWorkbenchWindow();
                if (window != null && window.getActivePage() != null) {
                    view[0] = (LocksView)window.getActivePage().findView(VIEW_ID);
                }
            }
        });
        return view[0];
    }
}

