/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.properties.RevPropertiesEditPanel;
import org.eclipse.team.svn.ui.utility.ColumnedViewerComparator;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class RevisionPropertiesComposite
extends Composite {
    protected static final int COLUMN_NAME = 0;
    protected static final int COLUMN_VALUE = 1;
    protected SVNProperty[] properties = new SVNProperty[0];
    protected IRepositoryLocation location;
    protected SVNRevision revision;
    protected TableViewer propertyViewer;
    protected Text propertyText;
    protected boolean isPending;

    public RevisionPropertiesComposite(Composite parent) {
        super(parent, 0);
        this.createControls(parent);
    }

    public void setPending(final boolean isPending) {
        this.isPending = isPending;
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            public void run() {
                if (isPending) {
                    RevisionPropertiesComposite.this.propertyViewer.getTable().setLinesVisible(false);
                } else {
                    RevisionPropertiesComposite.this.propertyViewer.getTable().setLinesVisible(true);
                }
                RevisionPropertiesComposite.this.rereshTableData();
            }
        });
    }

    public synchronized void disconnectComposite() {
        this.properties = new SVNProperty[0];
    }

    public void setInput(SVNProperty[] revProperties) {
        this.properties = revProperties;
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            public void run() {
                RevisionPropertiesComposite.this.rereshTableData();
            }
        });
    }

    public SVNProperty[] getSetProps() {
        return this.properties;
    }

    public void setLocationAndRevision(IRepositoryLocation location, SVNRevision revision) {
        this.location = location;
        this.revision = revision;
    }

    protected void rereshTableData() {
        if (this.isPending) {
            this.propertyViewer.setInput((Object)new String[]{""});
            return;
        }
        this.propertyViewer.setInput((Object)this.properties);
        this.propertyText.setText("");
    }

    protected void createControls(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        SashForm innerSashForm = new SashForm((Composite)this, 512);
        data = new GridData(1808);
        innerSashForm.setLayoutData((Object)data);
        Table table = new Table((Composite)innerSashForm, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        table.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        this.propertyText = new Text((Composite)innerSashForm, 770);
        this.propertyText.setBackground(this.propertyText.getBackground());
        this.propertyText.setEditable(false);
        data = new GridData(1808);
        this.propertyText.setLayoutData((Object)data);
        innerSashForm.setWeights(new int[]{70, 30});
        this.propertyViewer = new TableViewer(table);
        this.propertyViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection;
                if (event.getSelection() instanceof IStructuredSelection && (selection = ((IStructuredSelection)event.getSelection()).getFirstElement()) != null && selection instanceof SVNProperty) {
                    RevisionPropertiesComposite.this.propertyText.setText(((SVNProperty)selection).value);
                }
            }
        });
        ColumnedViewerComparator comparator = new ColumnedViewerComparator((Viewer)this.propertyViewer){

            public int compareImpl(Viewer viewer, Object row1, Object row2) {
                if (row1 instanceof SVNProperty) {
                    SVNProperty data1 = (SVNProperty)row1;
                    SVNProperty data2 = (SVNProperty)row2;
                    return this.column == 0 ? ColumnedViewerComparator.compare(data1.name, data2.name) : ColumnedViewerComparator.compare(data1.value, data2.value);
                }
                return 0;
            }
        };
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(SVNUIMessages.PropertiesComposite_Name);
        col.addSelectionListener((SelectionListener)comparator);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(SVNUIMessages.PropertiesComposite_Value);
        col.addSelectionListener((SelectionListener)comparator);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, true));
        this.propertyViewer.setComparator((ViewerComparator)comparator);
        comparator.setColumnNumber(0);
        this.propertyViewer.getTable().setSortColumn(this.propertyViewer.getTable().getColumn(0));
        this.propertyViewer.getTable().setSortDirection(128);
        this.propertyViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (RevisionPropertiesComposite.this.isPending) {
                    return (Object[])inputElement;
                }
                return RevisionPropertiesComposite.this.properties;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.propertyViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (RevisionPropertiesComposite.this.isPending) {
                    if (columnIndex == 0) {
                        return SVNUIMessages.getString("RepositoriesView_Model_Pending");
                    }
                    return "";
                }
                SVNProperty data = (SVNProperty)element;
                if (columnIndex == 0) {
                    return data.name;
                }
                return FileUtility.formatMultilineText((String)data.value);
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)table);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                boolean isItitialized;
                manager.add((IContributionItem)new Separator("additions"));
                final IStructuredSelection tSelection = (IStructuredSelection)RevisionPropertiesComposite.this.propertyViewer.getSelection();
                if (tSelection.size() == 1 && tSelection.getFirstElement() instanceof String) {
                    return;
                }
                Action tAction = null;
                boolean bl = isItitialized = RevisionPropertiesComposite.this.properties != null;
                if (isItitialized) {
                    tAction = new Action(SVNUIMessages.PropertiesComposite_Add){

                        public void run() {
                            RevisionPropertiesComposite.this.editProperty(null);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(RevisionPropertiesComposite.this.location != null);
                    tAction = new Action(SVNUIMessages.PropertiesComposite_Edit){

                        public void run() {
                            SVNProperty data = (SVNProperty)tSelection.getFirstElement();
                            RevisionPropertiesComposite.this.editProperty(data);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(tSelection.size() == 1);
                }
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        table.setMenu(menu);
        this.propertyViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                IStructuredSelection selection = (IStructuredSelection)e.getSelection();
                if (selection.size() == 1) {
                    SVNProperty data = (SVNProperty)selection.getFirstElement();
                    RevisionPropertiesComposite.this.editProperty(data);
                }
            }
        });
    }

    protected void editProperty(SVNProperty data) {
        RevPropertiesEditPanel panel = new RevPropertiesEditPanel(this.properties, this.revision);
        panel.setPropertyToEdit(data);
        if (new DefaultDialog(UIMonitorUtility.getShell(), panel).open() == 0) {
            RevPropertiesEditPanel.doSetRevisionProperty(panel, this.location, this.revision);
        }
    }
}

