/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.operation.local.DiffViewerSettings;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.common.DiffViewerVariablesPanel;
import org.eclipse.team.svn.ui.panel.common.EditFileAssociationsPanel;
import org.eclipse.team.svn.ui.utility.ColumnedViewerComparator;
import org.eclipse.team.svn.ui.verifier.IValidationManager;

public class DiffViewerFileAssociationsComposite
extends Composite {
    protected static final int COLUMN_CHECKBOX = 0;
    protected static final int COLUMN_EXTENSION = 1;
    protected static final int COLUMN_DIFF_PATH = 2;
    protected static final int COLUMN_MERGE_PATH = 3;
    protected IValidationManager validationManager;
    protected DiffViewerSettings diffSettings;
    protected CheckboxTableViewer tableViewer;
    protected Text diffParametersText;
    protected Text mergeParametersText;
    protected Button addButton;
    protected Button editButton;
    protected Button removeButton;

    public DiffViewerFileAssociationsComposite(Composite parent, IValidationManager validationManager) {
        super(parent, 0);
        this.validationManager = validationManager;
        this.createControls();
    }

    public void initializeControls(DiffViewerSettings diffSettings) {
        DiffViewerSettings.ResourceSpecificParameters[] params;
        this.diffSettings = diffSettings;
        this.diffParametersText.setText("");
        this.mergeParametersText.setText("");
        this.tableViewer.setInput((Object)diffSettings);
        DiffViewerSettings.ResourceSpecificParameters[] resourceSpecificParametersArray = params = diffSettings.getResourceSpecificParameters();
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            DiffViewerSettings.ResourceSpecificParameters param = resourceSpecificParametersArray[n2];
            this.tableViewer.setChecked((Object)param, param.isEnabled);
            ++n2;
        }
    }

    protected void createControls() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        GridData data = new GridData(1808);
        this.setLayout((Layout)layout);
        this.setLayoutData(data);
        Composite tableComposite = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        data = new GridData(1808);
        tableComposite.setLayout((Layout)layout);
        tableComposite.setLayoutData((Object)data);
        this.createFileAssociationsTable(tableComposite);
        this.createParametersPreview(tableComposite);
        this.createButtonsControls(this);
        this.enableButtons();
    }

    protected void createParametersPreview(Composite parent) {
        Group diffGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        GridData data = new GridData(768);
        diffGroup.setLayout((Layout)layout);
        diffGroup.setLayoutData((Object)data);
        diffGroup.setText(SVNUIMessages.DiffViewerExternalProgramComposite_DiffProgramArguments_Label);
        this.diffParametersText = new Text((Composite)diffGroup, 2882);
        data = new GridData(768);
        data.heightHint = DefaultDialog.convertHeightInCharsToPixels((Control)this.diffParametersText, 5);
        this.diffParametersText.setLayoutData((Object)data);
        this.diffParametersText.setBackground(this.diffParametersText.getBackground());
        this.diffParametersText.setEditable(false);
        Group mergeGroup = new Group(parent, 0);
        layout = new GridLayout();
        data = new GridData(768);
        mergeGroup.setLayout((Layout)layout);
        mergeGroup.setLayoutData((Object)data);
        mergeGroup.setText(SVNUIMessages.DiffViewerExternalProgramComposite_MergeProgramArguments_Label);
        this.mergeParametersText = new Text((Composite)mergeGroup, 2882);
        data = new GridData(768);
        data.heightHint = DefaultDialog.convertHeightInCharsToPixels((Control)this.mergeParametersText, 5);
        this.mergeParametersText.setLayoutData((Object)data);
        this.mergeParametersText.setBackground(this.mergeParametersText.getBackground());
        this.mergeParametersText.setEditable(false);
    }

    protected void createFileAssociationsTable(Composite parent) {
        Table table = new Table(parent, 68384);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(20, false));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setLayout((Layout)layout);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.tableViewer = new CheckboxTableViewer(table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setContentProvider((IContentProvider)new FileAssociationsContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new FileAssociationsLabelProvider());
        FileAssociationsComparator comparator = new FileAssociationsComparator((Viewer)this.tableViewer);
        TableColumn column = new TableColumn(table, 0);
        column.setResizable(false);
        column = new TableColumn(table, 0);
        column.setText(SVNUIMessages.DiffViewerFileAssociationsComposite_ExtensionMimeType_Column);
        column.addSelectionListener((SelectionListener)comparator);
        column = new TableColumn(table, 0);
        column.setText(SVNUIMessages.DiffViewerFileAssociationsComposite_DiffProgramPath_Column);
        column.addSelectionListener((SelectionListener)comparator);
        column = new TableColumn(table, 0);
        column.setText(SVNUIMessages.DiffViewerFileAssociationsComposite_MergeProgramPath_Column);
        column.addSelectionListener((SelectionListener)comparator);
        this.tableViewer.setComparator((ViewerComparator)comparator);
        comparator.setColumnNumber(1);
        this.tableViewer.getTable().setSortColumn(this.tableViewer.getTable().getColumn(1));
        this.tableViewer.getTable().setSortDirection(128);
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                DiffViewerSettings.ResourceSpecificParameters param = (DiffViewerSettings.ResourceSpecificParameters)event.getElement();
                param.isEnabled = event.getChecked();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DiffViewerSettings.ResourceSpecificParameters param = DiffViewerFileAssociationsComposite.this.getSelectedResourceSpecificParameter();
                DiffViewerFileAssociationsComposite.this.editFileAssociations(param);
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DiffViewerSettings.ResourceSpecificParameters param = DiffViewerFileAssociationsComposite.this.getSelectedResourceSpecificParameter();
                if (param != null) {
                    String diffParamsStr = param.params.diffParamatersString;
                    diffParamsStr = diffParamsStr != null ? diffParamsStr : "";
                    DiffViewerFileAssociationsComposite.this.diffParametersText.setText(diffParamsStr);
                    String mergeParamsStr = param.params.mergeParamatersString;
                    mergeParamsStr = mergeParamsStr != null ? mergeParamsStr : "";
                    DiffViewerFileAssociationsComposite.this.mergeParametersText.setText(mergeParamsStr);
                }
                DiffViewerFileAssociationsComposite.this.enableButtons();
            }
        });
    }

    protected void enableButtons() {
        boolean hasSelection = this.getSelectedResourceSpecificParameter() != null;
        this.editButton.setEnabled(hasSelection);
        this.removeButton.setEnabled(hasSelection);
    }

    protected void createButtonsControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        GridData data = new GridData();
        data.verticalAlignment = 128;
        data.widthHint = 100;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        this.addButton = new Button(composite, 8);
        data = new GridData(768);
        data.widthHint = DefaultDialog.computeButtonWidth(this.addButton);
        this.addButton.setLayoutData((Object)data);
        this.addButton.setText(SVNUIMessages.DiffViewerFileAssociationsComposite_Add_Button);
        this.editButton = new Button(composite, 8);
        data = new GridData(768);
        data.widthHint = DefaultDialog.computeButtonWidth(this.editButton);
        this.editButton.setLayoutData((Object)data);
        this.editButton.setText(SVNUIMessages.DiffViewerFileAssociationsComposite_Edit_Button);
        this.removeButton = new Button(composite, 8);
        data = new GridData(768);
        data.widthHint = DefaultDialog.computeButtonWidth(this.removeButton);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.setText(SVNUIMessages.DiffViewerFileAssociationsComposite_Remove_Button);
        Button variablesButton = new Button(composite, 8);
        data = new GridData(768);
        data.widthHint = DefaultDialog.computeButtonWidth(variablesButton);
        variablesButton.setLayoutData((Object)data);
        variablesButton.setText(SVNUIMessages.DiffViewerExternalProgramComposite_Variables_Button);
        this.addButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EditFileAssociationsPanel editPanel = new EditFileAssociationsPanel(null, DiffViewerFileAssociationsComposite.this.diffSettings);
                DefaultDialog dialog = new DefaultDialog(DiffViewerFileAssociationsComposite.this.getShell(), editPanel);
                if (dialog.open() == 0) {
                    DiffViewerSettings.ResourceSpecificParameters resourceParams = editPanel.getResourceSpecificParameters();
                    DiffViewerFileAssociationsComposite.this.diffSettings.addResourceSpecificParameters(resourceParams);
                }
            }
        });
        this.editButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DiffViewerSettings.ResourceSpecificParameters resourceParams = DiffViewerFileAssociationsComposite.this.getSelectedResourceSpecificParameter();
                DiffViewerFileAssociationsComposite.this.editFileAssociations(resourceParams);
            }
        });
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DiffViewerSettings.ResourceSpecificParameters resourceParams = DiffViewerFileAssociationsComposite.this.getSelectedResourceSpecificParameter();
                if (resourceParams != null) {
                    DiffViewerFileAssociationsComposite.this.diffSettings.removeResourceSpecificParameters(resourceParams);
                }
            }
        });
        variablesButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DiffViewerVariablesPanel panel = new DiffViewerVariablesPanel();
                DefaultDialog dlg = new DefaultDialog(DiffViewerFileAssociationsComposite.this.getShell(), panel);
                dlg.open();
            }
        });
    }

    protected void editFileAssociations(DiffViewerSettings.ResourceSpecificParameters resourceParams) {
        if (resourceParams != null) {
            EditFileAssociationsPanel editPanel = new EditFileAssociationsPanel(resourceParams, this.diffSettings);
            DefaultDialog dialog = new DefaultDialog(this.getShell(), editPanel);
            if (dialog.open() == 0) {
                resourceParams = editPanel.getResourceSpecificParameters();
                this.diffSettings.updateResourceSpecificParameters(resourceParams);
            }
        }
    }

    protected DiffViewerSettings.ResourceSpecificParameters getSelectedResourceSpecificParameter() {
        DiffViewerSettings.ResourceSpecificParameters resourceParams = null;
        ISelection sel = this.tableViewer.getSelection();
        if (!sel.isEmpty() && sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            resourceParams = (DiffViewerSettings.ResourceSpecificParameters)selection.getFirstElement();
        }
        return resourceParams;
    }

    protected class FileAssociationsComparator
    extends ColumnedViewerComparator {
        public FileAssociationsComparator(Viewer basedOn) {
            super(basedOn);
        }

        public int compareImpl(Viewer viewer, Object row1, Object row2) {
            DiffViewerSettings.ResourceSpecificParameters r1 = (DiffViewerSettings.ResourceSpecificParameters)row1;
            DiffViewerSettings.ResourceSpecificParameters r2 = (DiffViewerSettings.ResourceSpecificParameters)row2;
            if (this.column == 1) {
                DiffViewerSettings.ResourceSpecificParameterKindEnum kindEnum1 = r1.kind.kindEnum;
                DiffViewerSettings.ResourceSpecificParameterKindEnum kindEnum2 = r2.kind.kindEnum;
                if (kindEnum1.equals((Object)kindEnum2)) {
                    return ColumnedViewerComparator.compare(r1.kind.kindValue, r2.kind.kindValue);
                }
                return kindEnum2.compareTo((Enum)kindEnum1);
            }
            if (this.column == 2) {
                String path1 = r1.params.diffProgramPath;
                String path2 = r2.params.diffProgramPath;
                return ColumnedViewerComparator.compare(path1, path2);
            }
            if (this.column == 3) {
                String path1 = r1.params.mergeProgramPath;
                String path2 = r2.params.mergeProgramPath;
                return ColumnedViewerComparator.compare(path1, path2);
            }
            return 0;
        }
    }

    protected class FileAssociationsContentProvider
    implements IStructuredContentProvider,
    DiffViewerSettings.IDiffViewerChangeListener {
        protected FileAssociationsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            DiffViewerSettings diffSettings = (DiffViewerSettings)inputElement;
            return diffSettings.getResourceSpecificParameters();
        }

        public void addResourceSpecificParameters(DiffViewerSettings.ResourceSpecificParameters params) {
            DiffViewerFileAssociationsComposite.this.tableViewer.add((Object)params);
            DiffViewerFileAssociationsComposite.this.tableViewer.setChecked((Object)params, params.isEnabled);
        }

        public void changeResourceSpecificParameters(DiffViewerSettings.ResourceSpecificParameters params) {
            DiffViewerFileAssociationsComposite.this.tableViewer.update((Object)params, null);
            DiffViewerFileAssociationsComposite.this.diffParametersText.setText(params.params.diffParamatersString);
            DiffViewerFileAssociationsComposite.this.mergeParametersText.setText(params.params.mergeParamatersString);
        }

        public void removeResourceSpecificParameters(DiffViewerSettings.ResourceSpecificParameters params) {
            DiffViewerFileAssociationsComposite.this.tableViewer.remove((Object)params);
            DiffViewerFileAssociationsComposite.this.diffParametersText.setText("");
            DiffViewerFileAssociationsComposite.this.mergeParametersText.setText("");
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null) {
                ((DiffViewerSettings)newInput).addChangeListener((DiffViewerSettings.IDiffViewerChangeListener)this);
            }
            if (oldInput != null) {
                ((DiffViewerSettings)oldInput).removeChangeListener((DiffViewerSettings.IDiffViewerChangeListener)this);
            }
        }

        public void dispose() {
            DiffViewerFileAssociationsComposite.this.diffSettings.removeChangeListener((DiffViewerSettings.IDiffViewerChangeListener)this);
        }
    }

    protected class FileAssociationsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected FileAssociationsLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String res = "";
            DiffViewerSettings.ResourceSpecificParameters param = (DiffViewerSettings.ResourceSpecificParameters)element;
            switch (columnIndex) {
                case 0: {
                    res = "";
                    break;
                }
                case 1: {
                    res = param.kind.formatKindValue();
                    break;
                }
                case 2: {
                    res = param.params.diffProgramPath;
                    break;
                }
                case 3: {
                    res = param.params.mergeProgramPath;
                }
            }
            return res;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

