/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.properties.bugtraq;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkList {
    protected ArrayList<LinkPlacement> links = new ArrayList();

    public List<LinkPlacement> getLinks() {
        return this.links;
    }

    public boolean hasLinkAt(int offset) {
        for (LinkPlacement link : this.links) {
            if (!link.existAtOffset(offset)) continue;
            return true;
        }
        return false;
    }

    public LinkPlacement getLinkAt(int offset) {
        for (LinkPlacement link : this.links) {
            if (!link.existAtOffset(offset)) continue;
            return link;
        }
        return null;
    }

    public static class LinkPlacement {
        protected int start;
        protected int end;
        protected String linkText;

        public LinkPlacement(int start, int end, String message) {
            this.linkText = message.substring(start, end);
            this.start = start;
            this.end = end;
        }

        protected boolean existAtOffset(int offset) {
            return this.start <= offset && offset < this.end;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public String getURL() {
            return this.linkText;
        }
    }
}

