/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.properties;

import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.extension.properties.PredefinedProperty;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.property.IRevisionPropertiesProvider;
import org.eclipse.team.svn.core.operation.remote.SetRevisionPropertyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.svnstorage.events.RevisonPropertyChangeEvent;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.properties.AbstractPropertyEditPanel;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevPropertiesEditPanel
extends AbstractPropertyEditPanel {
    protected SVNRevision revision;

    public RevPropertiesEditPanel(SVNProperty[] revProperties, SVNRevision revision) {
        super(revProperties, SVNUIMessages.RevisionPropertyEditPanel_Title, SVNUIMessages.format((String)SVNUIMessages.RevisionPropertyEditPanel_Description, (Object[])new String[]{String.valueOf(revision)}));
        this.revision = revision;
        this.fillVerifiersMap();
    }

    @Override
    protected void saveChangesImpl() {
        super.saveChangesImpl();
    }

    @Override
    protected void cancelChangesImpl() {
    }

    @Override
    protected List<PredefinedProperty> getPredefinedProperties() {
        List<PredefinedProperty> properties = super.getPredefinedProperties();
        SVNProperty[] sVNPropertyArray = this.source;
        int n = this.source.length;
        int n2 = 0;
        while (n2 < n) {
            SVNProperty current = sVNPropertyArray[n2];
            if (!properties.contains(new PredefinedProperty(current.name))) {
                properties.add(new PredefinedProperty(current.name, "", "", null, 1));
            }
            ++n2;
        }
        return properties;
    }

    @Override
    protected boolean isPropertyAccepted(PredefinedProperty property) {
        return (property.type & 1) != 0;
    }

    @Override
    protected IRepositoryResource getRepostioryResource() {
        return null;
    }

    public static void doSetRevisionProperty(RevPropertiesEditPanel panel, final IRepositoryLocation location, final SVNRevision revision) {
        final SVNProperty[] data = new SVNProperty[]{new SVNProperty(panel.getPropertyName(), panel.getPropertyValue())};
        SetRevisionPropertyOperation setPropOp = null;
        CompositeOperation op = new CompositeOperation("", SVNUIMessages.class);
        if (panel.isFileSelected()) {
            final File f = new File(panel.getPropertyFile());
            AbstractActionOperation loadOp = new AbstractActionOperation("Operation_SLoadFileContent", SVNUIMessages.class){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    FileInputStream input = null;
                    try {
                        input = new FileInputStream(f);
                        byte[] binary = new byte[(int)f.length()];
                        input.read(binary);
                        data[0] = new SVNProperty(data[0].name, new String(binary));
                    }
                    finally {
                        if (input != null) {
                            input.close();
                        }
                    }
                }
            };
            op.add((IActionOperation)loadOp);
            IRevisionPropertiesProvider provider = new IRevisionPropertiesProvider(){

                public SVNProperty[] getRevisionProperties() {
                    return data;
                }
            };
            setPropOp = new SetRevisionPropertyOperation(location, revision, provider);
        } else {
            setPropOp = new SetRevisionPropertyOperation(location, revision, data[0]);
        }
        op.setOperationName(setPropOp.getOperationName());
        op.add((IActionOperation)setPropOp);
        op.add((IActionOperation)new AbstractActionOperation(setPropOp.getOperationName(), SVNMessages.class){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                SVNRemoteStorage.instance().fireRevisionPropertyChangeEvent(new RevisonPropertyChangeEvent(0, revision, location, data[0]));
            }
        }, new IActionOperation[]{setPropOp});
        UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
    }
}

