/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.view.property;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.resource.IRepositoryFolder;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.RevisionComposite;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.utility.UserInputHistory;
import org.eclipse.team.svn.ui.verifier.AbstractFormattedVerifier;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.team.svn.ui.verifier.URLVerifier;
import org.eclipse.team.svn.ui.wizard.SelectRepositoryResourceWizard;

public class ExternalsEditPanel
extends AbstractDialogPanel {
    protected IResource resource;
    protected IRepositoryResource repositoryResource;
    protected Combo urlText;
    protected Button browse;
    protected UserInputHistory urlHistory;
    protected String comboId;
    protected Button folderButton;
    protected Text localPathText;
    protected RevisionComposite revisionComposite;
    protected Button priorToSVN15FormatButton;
    protected Combo relativeText;
    protected Button formatButton;
    protected String localPath;
    protected boolean priorToSVN15Format;
    protected String url;
    protected SVNRevision revision;
    protected boolean isFolder;
    protected String processedUrl;
    protected IRepositoryResource repositoryResourceForUrl;
    protected static final int REPOSITORY_ROOT_INDEX = 0;
    protected static final int URL_SCHEME_INDEX = 1;
    protected static final int HOST_NAME_INDEX = 2;
    protected static final int EXTERNAL_DIRECTORY_INDEX = 3;

    public ExternalsEditPanel(String historyKey, String comboId, IResource resource, IRepositoryResource repositoryResource) {
        this.resource = resource;
        this.repositoryResource = repositoryResource;
        this.dialogTitle = SVNUIMessages.ExternalsEditPanel_DialogTitle;
        this.dialogDescription = SVNUIMessages.ExternalsEditPanel_DialogDescription;
        this.defaultMessage = SVNUIMessages.ExternalsEditPanel_DialogDefaultMessage;
        this.urlHistory = new UserInputHistory(historyKey);
        this.comboId = comboId;
    }

    protected void createControlsImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        this.createLocalPathSelectionControls(composite);
        this.createRepositoryResourceSelectionControls(composite);
        this.revisionComposite = new RevisionComposite(composite, this, true, new String[]{SVNUIMessages.RevisionComposite_Revision, SVNUIMessages.RepositoryResourceSelectionComposite_HeadRevision}, (SVNRevision)SVNRevision.INVALID_REVISION, false, false);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.revisionComposite.setLayoutData(data);
        this.priorToSVN15FormatButton = new Button(composite, 32);
        data = new GridData();
        data.horizontalSpan = 3;
        this.priorToSVN15FormatButton.setLayoutData((Object)data);
        this.priorToSVN15FormatButton.setText(SVNUIMessages.ExternalsEditPanel_PriortoSVN15);
        this.priorToSVN15FormatButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalsEditPanel.this.priorToSVN15Format = ExternalsEditPanel.this.priorToSVN15FormatButton.getSelection();
                ExternalsEditPanel.this.enableFormatUrl();
                ExternalsEditPanel.this.enableIsFolder();
                ExternalsEditPanel.this.onChangeUrlText();
                ExternalsEditPanel.this.validateContent();
            }
        });
        this.initValues();
    }

    protected void initValues() {
        if (CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() < 5) {
            this.priorToSVN15Format = false;
            this.priorToSVN15FormatButton.setEnabled(this.priorToSVN15Format);
        }
        this.isFolder = true;
        this.folderButton.setSelection(true);
        this.enableIsFolder();
        this.enableFormatUrl();
    }

    protected void enableIsFolder() {
        if (this.isLessSVN16() || this.isPriorToSVN15Format()) {
            this.isFolder = true;
            this.folderButton.setSelection(true);
            this.folderButton.setEnabled(false);
        } else {
            this.folderButton.setEnabled(true);
        }
    }

    protected void enableFormatUrl() {
        boolean isEnable = false;
        if (!this.isPriorToSVN15Format() && CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() > 4) {
            isEnable = this.url != null && this.repositoryResourceForUrl != null && SVNUtility.isValidSVNURL((String)this.url) && this.repositoryResourceForUrl.getRepositoryLocation().getRepositoryRoot().equals(this.repositoryResource.getRepositoryLocation().getRepositoryRoot());
        }
        this.relativeText.setEnabled(isEnable);
        this.formatButton.setEnabled(isEnable);
    }

    protected void createLocalPathSelectionControls(Composite parent) {
        Label localPathLabel = new Label(parent, 0);
        GridData data = new GridData();
        localPathLabel.setLayoutData((Object)data);
        localPathLabel.setText(SVNUIMessages.ExternalsEditPanel_LocalPathLabel);
        this.localPathText = new Text(parent, 2048);
        data = new GridData(768);
        this.localPathText.setLayoutData((Object)data);
        this.localPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExternalsEditPanel.this.localPath = ExternalsEditPanel.this.localPathText.getText();
            }
        });
        this.folderButton = new Button(parent, 32);
        this.folderButton.setLayoutData((Object)new GridData());
        this.folderButton.setText(SVNUIMessages.ExternalsEditPanel_IsFolder);
        this.folderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalsEditPanel.this.isFolder = ExternalsEditPanel.this.folderButton.getSelection();
            }
        });
    }

    protected void createRepositoryResourceSelectionControls(Composite parent) {
        Label urlLabel = new Label(parent, 0);
        urlLabel.setLayoutData((Object)new GridData());
        urlLabel.setText(SVNUIMessages.getString(this.comboId));
        this.urlText = new Combo(parent, 0);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.urlText.setLayoutData((Object)data);
        this.urlText.setVisibleItemCount(this.urlHistory.getDepth());
        this.urlText.setItems(this.urlHistory.getHistory());
        Listener urlTextListener = new Listener(){

            public void handleEvent(Event event) {
                ExternalsEditPanel.this.onChangeUrlText();
            }
        };
        this.urlText.addListener(13, urlTextListener);
        this.urlText.addListener(24, urlTextListener);
        this.browse = new Button(parent, 8);
        this.browse.setText(SVNUIMessages.Button_Browse);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(this.browse);
        this.browse.setLayoutData((Object)data);
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalsEditPanel.this.onRepositoryResourceSelection();
            }
        });
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(SVNUIMessages.ExternalsEditPanel_FormatUrl);
        this.relativeText = new Combo(parent, 8);
        data = new GridData(768);
        data.widthHint = 200;
        this.relativeText.setLayoutData((Object)data);
        this.relativeText.add(SVNUIMessages.ExternalsEditPanel_RelativeToRepositoryRoot, 0);
        this.relativeText.add(SVNUIMessages.ExternalsEditPanel_RelativeToUrlScheme, 1);
        this.relativeText.add(SVNUIMessages.ExternalsEditPanel_RelativeToHostName, 2);
        this.relativeText.add(SVNUIMessages.ExternalsEditPanel_RelativeToDirectory, 3);
        this.relativeText.setVisibleItemCount(4);
        this.relativeText.select(0);
        this.formatButton = new Button(parent, 8);
        this.formatButton.setText(SVNUIMessages.ExternalsEditPanel_FormatButton);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(this.formatButton);
        this.formatButton.setLayoutData((Object)data);
        this.formatButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalsEditPanel.this.formatUrl();
            }
        });
        CompositeVerifier urlVerifier = new CompositeVerifier(){

            protected void fireError(String errorReason) {
                super.fireError(errorReason);
                ExternalsEditPanel.this.onUrlValidity(false);
            }

            protected void fireOk() {
                super.fireOk();
                ExternalsEditPanel.this.onUrlValidity(true);
            }
        };
        urlVerifier.add(new NonEmptyFieldVerifier(SVNUIMessages.getString(String.valueOf(this.comboId) + "_Verifier")));
        urlVerifier.add(new URLVerifier(SVNUIMessages.getString(String.valueOf(this.comboId) + "_Verifier")){

            protected String getText(Control input) {
                return ExternalsEditPanel.this.processedUrl != null ? ExternalsEditPanel.this.processedUrl : ExternalsEditPanel.this.url;
            }
        });
        this.attachTo((Control)this.urlText, urlVerifier);
        CompositeVerifier localPathVerifier = new CompositeVerifier();
        localPathVerifier.add(new NonEmptyFieldVerifier(SVNUIMessages.ExternalsEditPanel_LocalPathLabel_Verifier));
        localPathVerifier.add(new AbstractFormattedVerifier(SVNUIMessages.ExternalsEditPanel_LocalPathLabel_Verifier){

            protected String getErrorMessageImpl(Control input) {
                String text = this.getText(input);
                if ((text = text.trim()).contains(" ") && ExternalsEditPanel.this.isLessSVN16()) {
                    return SVNUIMessages.format((String)SVNUIMessages.Verifier_NoSpaces, (Object[])new String[]{"$FIELD_NAME$"});
                }
                return null;
            }

            protected String getWarningMessageImpl(Control input) {
                return null;
            }
        });
        this.attachTo((Control)this.localPathText, localPathVerifier);
    }

    protected void onUrlValidity(boolean isValidUrl) {
        this.revisionComposite.setEnabled(isValidUrl);
        this.enableFormatUrl();
    }

    protected void formatUrl() {
        String fullUrl = this.url.trim();
        IPath fullUrlPath = SVNUtility.createPathForSVNUrl((String)fullUrl);
        int relativeIndex = this.relativeText.getSelectionIndex();
        if (relativeIndex == 0) {
            IPath repositoryRoot = SVNUtility.createPathForSVNUrl((String)this.repositoryResource.getRepositoryLocation().getRepositoryRootUrl());
            if (repositoryRoot.isPrefixOf(fullUrlPath)) {
                String relative = fullUrlPath.makeRelativeTo(repositoryRoot).toString();
                this.urlText.setText("^/" + relative);
            }
        } else if (relativeIndex == 1) {
            int index = 0;
            if (fullUrl.startsWith("file:///")) {
                index = "file:///".length();
            } else if (fullUrl.startsWith("file://")) {
                index = "file://".length();
            } else if (fullUrl.startsWith("http://")) {
                index = "http://".length();
            } else if (fullUrl.startsWith("https://")) {
                index = "https://".length();
            } else if (fullUrl.startsWith("svn://")) {
                index = "svn://".length();
            } else if (fullUrl.startsWith("svn+ssh://")) {
                index = "svn+ssh://".length();
            }
            if (index != 0) {
                String relativaPath = "//" + fullUrl.substring(index);
                this.urlText.setText(relativaPath);
            }
        } else if (relativeIndex == 2) {
            try {
                URL url = SVNUtility.getSVNUrl((String)fullUrl);
                String relativePath = url.getFile();
                this.urlText.setText(relativePath);
            }
            catch (MalformedURLException url) {}
        } else if (relativeIndex == 3) {
            IPath resourcePath;
            IPath commonPath = resourcePath = SVNUtility.createPathForSVNUrl((String)this.repositoryResource.getUrl());
            int relativeSegmentsCount = 0;
            do {
                commonPath = commonPath.removeLastSegments(1);
                ++relativeSegmentsCount;
            } while (!commonPath.isPrefixOf(fullUrlPath) && !commonPath.isEmpty());
            if (!commonPath.isEmpty()) {
                StringBuffer relativePath = new StringBuffer();
                int i = 0;
                while (i < relativeSegmentsCount) {
                    relativePath.append("../");
                    ++i;
                }
                relativePath.append(fullUrlPath.makeRelativeTo(commonPath).toString());
                this.urlText.setText(relativePath.toString());
            }
        }
    }

    protected void onChangeUrlText() {
        this.url = this.urlText.getText();
        if (!this.isPriorToSVN15Format() && CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() > 4) {
            try {
                this.processedUrl = SVNUtility.replaceRelativeExternalParts((String)this.url, (IRepositoryResource)this.repositoryResource);
            }
            catch (Exception e) {
                this.processedUrl = null;
            }
        } else {
            this.processedUrl = this.url;
        }
        this.repositoryResourceForUrl = this.processedUrl != null ? SVNUtility.asRepositoryResource((String)this.processedUrl, (boolean)this.isFolder) : null;
        this.revisionComposite.setSelectedResource(this.repositoryResourceForUrl);
    }

    protected void onRepositoryResourceSelection() {
        SelectRepositoryResourceWizard wizard = this.isFolder ? new SelectRepositoryResourceWizard(this.isFolder) : new SelectRepositoryResourceWizard(this.isFolder, this.repositoryResource.getRepositoryLocation());
        WizardDialog dialog = new WizardDialog(this.manager.getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            IRepositoryResource resource = wizard.getSelectedResource();
            this.folderButton.setSelection(resource instanceof IRepositoryFolder);
            this.urlText.setText(resource.getUrl());
        }
    }

    public String getHelpId() {
        return "org.eclipse.team.svn.help.setExternalsDialogContext";
    }

    protected void saveChangesImpl() {
        this.revision = this.revisionComposite.getSelectedRevision();
        this.urlHistory.addLine(this.urlText.getText());
    }

    protected void cancelChangesImpl() {
    }

    protected boolean isLessSVN16() {
        return CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() < 6;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public boolean isPriorToSVN15Format() {
        return this.priorToSVN15Format;
    }

    public String getUrl() {
        return this.url;
    }

    public SVNRevision getRevision() {
        return this.revision;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    protected Point getPrefferedSizeImpl() {
        return new Point(520, -1);
    }
}

