/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.operation.remote.GetLogMessagesOperation;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.panel.common.SVNHistoryPanel;

public class SelectRevisionPanel
extends SVNHistoryPanel {
    protected SVNLogEntry[] selectedLogMessages;

    public SelectRevisionPanel(GetLogMessagesOperation msgOp, boolean multiSelect, boolean useCheckboxes, long currentRevision) {
        super(SVNUIMessages.SelectRevisionPanel_Title, SVNUIMessages.SelectRevisionPanel_Description, SVNUIMessages.SelectRevisionPanel_Message, msgOp, multiSelect, useCheckboxes, currentRevision);
    }

    public long getSelectedRevision() {
        return this.selectedLogMessages[0].revision;
    }

    public SVNLogEntry[] getSelectedLogMessages() {
        return this.selectedLogMessages;
    }

    public SVNRevisionRange[] getSelectedRevisions() {
        ArrayList<SVNRevisionRange> revisions = new ArrayList<SVNRevisionRange>();
        List<SVNLogEntry> selected = Arrays.asList(this.selectedLogMessages);
        long startRev = -1L;
        long lastRev = -1L;
        int i = 0;
        while (i < this.logMessages.length) {
            SVNLogEntry entry = this.logMessages[i];
            if (selected.indexOf(entry) != -1) {
                startRev = entry.revision;
                if (lastRev == -1L) {
                    lastRev = entry.revision;
                }
                if (i == this.logMessages.length - 1) {
                    revisions.add(new SVNRevisionRange(startRev == lastRev || startRev == 0L ? startRev : startRev - 1L, lastRev));
                }
            } else if (lastRev != -1L) {
                revisions.add(new SVNRevisionRange(startRev == lastRev || startRev == 0L ? startRev : startRev - 1L, lastRev));
                lastRev = -1L;
            }
            ++i;
        }
        return revisions.toArray(new SVNRevisionRange[revisions.size()]);
    }

    public void postInit() {
        this.manager.setButtonEnabled(0, false);
    }

    protected void initTableViewerListener() {
        this.tableViewerListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SelectRevisionPanel.this.manager != null) {
                    SVNLogEntry[] messages = SelectRevisionPanel.this.history.getSelectedLogMessages();
                    SelectRevisionPanel.this.manager.setButtonEnabled(0, messages != null && messages.length > 0);
                }
            }
        };
        this.history.getTreeViewer().addSelectionChangedListener(this.tableViewerListener);
    }

    protected void saveChangesImpl() {
        this.selectedLogMessages = this.history.getSelectedLogMessages();
    }

    public String getHelpId() {
        return "org.eclipse.team.svn.help.revisionLinkDialogContext";
    }
}

