/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.lock;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.lock.LockResource;
import org.eclipse.team.svn.ui.utility.DateFormatter;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class LockResourcesTableLabelProvider
implements ITableLabelProvider,
IFontProvider {
    protected Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();
    protected boolean hasCheckBoxes;
    protected static final ImageDescriptor PENDING_IMAGE_DESCRIPTOR = SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/repositories/browser_pending.gif");
    protected Font boldFont;
    static final String NO_LOCKS_NAME = "nolocks";
    static final String PENDING_NAME = "pending";
    public static LockResource FAKE_NO_LOCKS = LockResource.createDirectory("nolocks");
    public static LockResource FAKE_PENDING = LockResource.createDirectory("pending");

    public LockResourcesTableLabelProvider(boolean hasCheckBoxes) {
        this.hasCheckBoxes = hasCheckBoxes;
        Font defaultFont = JFaceResources.getDefaultFont();
        FontData[] data = defaultFont.getFontData();
        int i = 0;
        while (i < data.length) {
            data[i].setStyle(1);
            ++i;
        }
        this.boldFont = new Font((Device)UIMonitorUtility.getDisplay(), data);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        LockResource node = (LockResource)element;
        if (LockResourcesTableLabelProvider.isFakePending(node)) {
            if (columnIndex == 1) {
                Image img = this.images.get(PENDING_IMAGE_DESCRIPTOR);
                if (img == null) {
                    img = PENDING_IMAGE_DESCRIPTOR.createImage();
                    this.images.put(PENDING_IMAGE_DESCRIPTOR, img);
                }
                return img;
            }
            return null;
        }
        if (LockResourcesTableLabelProvider.isFakeNoLocks(node)) {
            return null;
        }
        if (this.hasCheckBoxes && columnIndex == 1 || !this.hasCheckBoxes && columnIndex == 0) {
            String fileName = node.getName();
            ImageDescriptor descr = SVNTeamUIPlugin.instance().getWorkbench().getEditorRegistry().getImageDescriptor(fileName);
            Image img = this.images.get(descr);
            if (img == null) {
                img = descr.createImage();
                this.images.put(descr, img);
            }
            return img;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        LockResource node = (LockResource)element;
        if (LockResourcesTableLabelProvider.isFakePending(node)) {
            if (columnIndex == 1) {
                return SVNUIMessages.RepositoriesView_Model_Pending;
            }
            return null;
        }
        if (LockResourcesTableLabelProvider.isFakeNoLocks(node)) {
            if (columnIndex == 1) {
                return SVNUIMessages.LockResourcesTableLabelProvider_NoLocks;
            }
            return null;
        }
        LockResource data = (LockResource)element;
        switch (columnIndex) {
            case 1: {
                return data.getName();
            }
            case 2: {
                return data.getPath();
            }
            case 3: {
                if (data.lockStatus == LockResource.LockStatusEnum.LOCALLY_LOCKED) {
                    return SVNUIMessages.LockResourcesTableLabelProvider_LocalLock;
                }
                if (data.lockStatus == LockResource.LockStatusEnum.OTHER_LOCKED) {
                    return SVNUIMessages.LockResourcesTableLabelProvider_OtherLock;
                }
                if (data.lockStatus == LockResource.LockStatusEnum.BROKEN) {
                    return SVNUIMessages.LockResourcesTableLabelProvider_BrokenLock;
                }
                if (data.lockStatus == LockResource.LockStatusEnum.STOLEN) {
                    return SVNUIMessages.LockResourcesTableLabelProvider_StolenLock;
                }
                return SVNUIMessages.LockResourcesTableLabelProvider_NotLocked;
            }
            case 4: {
                return data.getOwner();
            }
            case 5: {
                return data.getCreationDate() != null ? DateFormatter.formatDate(data.getCreationDate()) : "";
            }
        }
        return "";
    }

    public void dispose() {
        for (Image img : this.images.values()) {
            img.dispose();
        }
        this.boldFont.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Font getFont(Object element) {
        return this.isRequireBoldFont(element) ? this.boldFont : null;
    }

    protected boolean isRequireBoldFont(Object element) {
        return LockResourcesTableLabelProvider.isFakeLockResource((LockResource)element);
    }

    public static boolean isFakeLockResource(LockResource lockResource) {
        return LockResourcesTableLabelProvider.isFakePending(lockResource) || LockResourcesTableLabelProvider.isFakeNoLocks(lockResource);
    }

    public static boolean isFakeNoLocks(LockResource lockResource) {
        return lockResource.getName().equals(NO_LOCKS_NAME);
    }

    public static boolean isFakePending(LockResource lockResource) {
        return lockResource.getName().equals(PENDING_NAME);
    }
}

