/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.facet.iterators;

import java.io.IOException;
import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.sandbox.facet.iterators.OrdinalIterator;
import org.apache.lucene.sandbox.facet.labels.LabelToOrd;
import org.apache.lucene.sandbox.facet.recorders.FacetRecorder;

public final class CandidateSetOrdinalIterator
implements OrdinalIterator {
    private final OrdinalIterator candidateOrdinalIterator;
    private final FacetRecorder facetRecorder;

    public CandidateSetOrdinalIterator(FacetRecorder facetRecorder, FacetLabel[] candidateLabels, LabelToOrd labelToOrd) throws IOException {
        this.candidateOrdinalIterator = facetRecorder.isEmpty() ? OrdinalIterator.EMPTY : OrdinalIterator.fromArray(labelToOrd.getOrds(candidateLabels));
        this.facetRecorder = facetRecorder;
    }

    @Override
    public int nextOrd() throws IOException {
        int ord = this.candidateOrdinalIterator.nextOrd();
        while (ord != -1) {
            if (this.facetRecorder.contains(ord)) {
                return ord;
            }
            ord = this.candidateOrdinalIterator.nextOrd();
        }
        return -1;
    }
}

