/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.draw2d.Animation;
import org.eclipse.zest.core.widgets.DefaultSubgraph;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphContainer;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.IContainer2;
import org.eclipse.zest.core.widgets.InternalNodeLayout;
import org.eclipse.zest.core.widgets.LayoutFilter;
import org.eclipse.zest.core.widgets.SubgraphFactory;
import org.eclipse.zest.core.widgets.ZestStyles;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.zest.layouts.interfaces.ConnectionLayout;
import org.eclipse.zest.layouts.interfaces.ContextListener;
import org.eclipse.zest.layouts.interfaces.EntityLayout;
import org.eclipse.zest.layouts.interfaces.ExpandCollapseManager;
import org.eclipse.zest.layouts.interfaces.GraphStructureListener;
import org.eclipse.zest.layouts.interfaces.LayoutContext;
import org.eclipse.zest.layouts.interfaces.LayoutListener;
import org.eclipse.zest.layouts.interfaces.NodeLayout;
import org.eclipse.zest.layouts.interfaces.PruningListener;
import org.eclipse.zest.layouts.interfaces.SubgraphLayout;

class InternalLayoutContext
implements LayoutContext {
    final IContainer2 container;
    private final List<LayoutFilter> filters = new ArrayList<LayoutFilter>();
    private final List<ContextListener> contextListeners = new CopyOnWriteArrayList<ContextListener>();
    private final List<GraphStructureListener> graphStructureListeners = new CopyOnWriteArrayList<GraphStructureListener>();
    private final List<LayoutListener> layoutListeners = new CopyOnWriteArrayList<LayoutListener>();
    private final List<PruningListener> pruningListeners = new CopyOnWriteArrayList<PruningListener>();
    private LayoutAlgorithm mainAlgorithm;
    private LayoutAlgorithm layoutAlgorithm;
    private ExpandCollapseManager expandCollapseManager;
    private SubgraphFactory subgraphFactory = new DefaultSubgraph.DefaultSubgraphFactory();
    private final Set<SubgraphLayout> subgraphs = new HashSet<SubgraphLayout>();
    private boolean eventsOn = true;
    private boolean backgorundLayoutEnabled = true;
    private boolean externalLayoutInvocation = false;

    InternalLayoutContext(Graph graph) {
        this.container = graph;
    }

    InternalLayoutContext(GraphContainer container) {
        this.container = container;
    }

    public void addContextListener(ContextListener listener) {
        this.contextListeners.add(listener);
    }

    public void addGraphStructureListener(GraphStructureListener listener) {
        this.graphStructureListeners.add(listener);
    }

    public void addLayoutListener(LayoutListener listener) {
        this.layoutListeners.add(listener);
    }

    public void addPruningListener(PruningListener listener) {
        this.pruningListeners.add(listener);
    }

    public SubgraphLayout createSubgraph(NodeLayout[] nodes) {
        this.checkChangesAllowed();
        NodeLayout[] internalNodes = new InternalNodeLayout[nodes.length];
        int i = 0;
        while (i < nodes.length) {
            internalNodes[i] = (InternalNodeLayout)nodes[i];
            ++i;
        }
        SubgraphLayout subgraph = this.subgraphFactory.createSubgraph(internalNodes, this);
        this.subgraphs.add(subgraph);
        return subgraph;
    }

    void removeSubgrah(DefaultSubgraph subgraph) {
        this.subgraphs.remove(subgraph);
    }

    public void flushChanges(boolean animationHint) {
        if (!this.container.getGraph().isVisible() && animationHint) {
            return;
        }
        this.eventsOn = false;
        if (animationHint) {
            Animation.markBegin();
        }
        for (GraphNode graphNode : this.container.getNodes()) {
            graphNode.applyLayoutChanges();
        }
        for (GraphConnection graphConnection : this.container.getConnections()) {
            graphConnection.applyLayoutChanges();
        }
        for (SubgraphLayout subgraphLayout : this.subgraphs) {
            DefaultSubgraph subgraph = (DefaultSubgraph)subgraphLayout;
            subgraph.applyLayoutChanges();
        }
        if (animationHint) {
            Animation.run((int)500);
        }
        this.eventsOn = true;
    }

    public DisplayIndependentRectangle getBounds() {
        DisplayIndependentRectangle result = new DisplayIndependentRectangle(this.container.getLayoutBounds());
        result.width -= 20.0;
        result.height -= 20.0;
        return result;
    }

    public LayoutAlgorithm getMainLayoutAlgorithm() {
        return this.mainAlgorithm;
    }

    public ExpandCollapseManager getExpandCollapseManager() {
        return this.expandCollapseManager;
    }

    public NodeLayout[] getNodes() {
        ArrayList<InternalNodeLayout> result = new ArrayList<InternalNodeLayout>();
        for (GraphNode graphNode : this.container.getNodes()) {
            if (this.isLayoutItemFiltered(graphNode)) continue;
            result.add(graphNode.getLayout());
        }
        return result.toArray(new NodeLayout[result.size()]);
    }

    public EntityLayout[] getEntities() {
        HashSet<SubgraphLayout> addedSubgraphs = new HashSet<SubgraphLayout>();
        ArrayList<InternalNodeLayout> result = new ArrayList<InternalNodeLayout>();
        for (GraphNode graphNode : this.container.getNodes()) {
            if (this.isLayoutItemFiltered(graphNode)) continue;
            InternalNodeLayout nodeLayout = graphNode.getLayout();
            if (!nodeLayout.isPruned()) {
                result.add(nodeLayout);
                continue;
            }
            SubgraphLayout subgraph = nodeLayout.getSubgraph();
            if (!subgraph.isGraphEntity() || addedSubgraphs.contains(subgraph)) continue;
            result.add((InternalNodeLayout)subgraph);
            addedSubgraphs.add(subgraph);
        }
        return result.toArray(new EntityLayout[result.size()]);
    }

    public SubgraphLayout[] getSubgraphs() {
        SubgraphLayout[] result = new SubgraphLayout[this.subgraphs.size()];
        int subgraphCount = 0;
        block0: for (SubgraphLayout subgraph : this.subgraphs) {
            NodeLayout[] nodes;
            NodeLayout[] nodeLayoutArray = nodes = subgraph.getNodes();
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                NodeLayout node = nodeLayoutArray[n2];
                if (!this.isLayoutItemFiltered(((InternalNodeLayout)node).getNode())) {
                    result[subgraphCount] = subgraph;
                    ++subgraphCount;
                    continue block0;
                }
                ++n2;
            }
        }
        if (subgraphCount == this.subgraphs.size()) {
            return result;
        }
        SubgraphLayout[] result2 = new SubgraphLayout[subgraphCount];
        System.arraycopy(result, 0, result2, 0, subgraphCount);
        return result2;
    }

    public boolean isBoundsExpandable() {
        return false;
    }

    public boolean isBackgroundLayoutEnabled() {
        return this.backgorundLayoutEnabled;
    }

    void setBackgroundLayoutEnabled(boolean enabled) {
        if (this.backgorundLayoutEnabled != enabled) {
            this.backgorundLayoutEnabled = enabled;
            this.fireBackgroundEnableChangedEvent();
        }
    }

    public boolean isPruningEnabled() {
        return this.expandCollapseManager != null;
    }

    public void removeContextListener(ContextListener listener) {
        this.contextListeners.remove(listener);
    }

    public void removeGraphStructureListener(GraphStructureListener listener) {
        this.graphStructureListeners.remove(listener);
    }

    public void removeLayoutListener(LayoutListener listener) {
        this.layoutListeners.remove(listener);
    }

    public void removePruningListener(PruningListener listener) {
        this.pruningListeners.remove(listener);
    }

    public void setMainLayoutAlgorithm(LayoutAlgorithm algorithm) {
        this.mainAlgorithm = algorithm;
    }

    public void setExpandCollapseManager(ExpandCollapseManager expandCollapseManager) {
        this.expandCollapseManager = expandCollapseManager;
        expandCollapseManager.initExpansion((LayoutContext)this);
    }

    public ConnectionLayout[] getConnections() {
        List<? extends GraphConnection> connections = this.container.getConnections();
        ConnectionLayout[] result = new ConnectionLayout[connections.size()];
        int i = 0;
        for (GraphConnection graphConnection : connections) {
            if (this.isLayoutItemFiltered(graphConnection)) continue;
            result[i] = graphConnection.getLayout();
            ++i;
        }
        if (i == result.length) {
            return result;
        }
        ConnectionLayout[] connectionLayoutArray = new ConnectionLayout[i];
        System.arraycopy(result, 0, connectionLayoutArray, 0, i);
        return connectionLayoutArray;
    }

    public ConnectionLayout[] getConnections(EntityLayout source, EntityLayout target) {
        ArrayList<ConnectionLayout> result = new ArrayList<ConnectionLayout>();
        ArrayList<NodeLayout> sourcesList = new ArrayList<NodeLayout>();
        if (source instanceof NodeLayout) {
            NodeLayout layout = (NodeLayout)source;
            sourcesList.add(layout);
        }
        if (source instanceof SubgraphLayout) {
            SubgraphLayout layout = (SubgraphLayout)source;
            sourcesList.addAll(Arrays.asList(layout.getNodes()));
        }
        HashSet<NodeLayout> targets = new HashSet<NodeLayout>();
        if (target instanceof NodeLayout) {
            NodeLayout layout = (NodeLayout)target;
            targets.add(layout);
        }
        if (target instanceof SubgraphLayout) {
            SubgraphLayout layout = (SubgraphLayout)target;
            targets.addAll(Arrays.asList(layout.getNodes()));
        }
        for (NodeLayout source2 : sourcesList) {
            ConnectionLayout[] outgoingConnections;
            ConnectionLayout[] connectionLayoutArray = outgoingConnections = source2.getOutgoingConnections();
            int n = outgoingConnections.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionLayout connection = connectionLayoutArray[n2];
                if (connection.getSource() == source2 && targets.contains(connection.getTarget()) || connection.getTarget() == source2 && targets.contains(connection.getSource())) {
                    result.add(connection);
                }
                ++n2;
            }
        }
        return result.toArray(new ConnectionLayout[result.size()]);
    }

    void addFilter(LayoutFilter filter) {
        this.filters.add(filter);
    }

    void removeFilter(LayoutFilter filter) {
        this.filters.remove(filter);
    }

    boolean isLayoutItemFiltered(GraphItem item) {
        for (LayoutFilter filter : this.filters) {
            if (!filter.isObjectFiltered(item)) continue;
            return true;
        }
        if (!item.isVisible()) {
            return ZestStyles.checkStyle(this.container.getGraph().getGraphStyle(), 2);
        }
        return false;
    }

    void setExpanded(NodeLayout node, boolean expanded) {
        this.externalLayoutInvocation = true;
        if (this.expandCollapseManager != null) {
            this.expandCollapseManager.setExpanded((LayoutContext)this, node, expanded);
        }
        this.externalLayoutInvocation = false;
    }

    boolean canExpand(NodeLayout node) {
        return this.expandCollapseManager != null && this.expandCollapseManager.canExpand((LayoutContext)this, node);
    }

    boolean canCollapse(NodeLayout node) {
        return this.expandCollapseManager != null && this.expandCollapseManager.canCollapse((LayoutContext)this, node);
    }

    void setSubgraphFactory(SubgraphFactory factory) {
        this.subgraphFactory = factory;
    }

    SubgraphFactory getSubgraphFactory() {
        return this.subgraphFactory;
    }

    void applyMainAlgorithm() {
        if (this.backgorundLayoutEnabled && this.mainAlgorithm != null) {
            this.mainAlgorithm.applyLayout(true);
            this.flushChanges(false);
        }
    }

    void setLayoutAlgorithm(LayoutAlgorithm algorithm) {
        this.layoutAlgorithm = algorithm;
        if (!(this.layoutAlgorithm instanceof LayoutAlgorithm.Zest1)) {
            this.layoutAlgorithm.setLayoutContext((LayoutContext)this);
        }
    }

    LayoutAlgorithm getLayoutAlgorithm() {
        return this.layoutAlgorithm;
    }

    void applyLayout(boolean clean) {
        if (this.layoutAlgorithm != null) {
            this.externalLayoutInvocation = true;
            this.layoutAlgorithm.applyLayout(clean);
            this.externalLayoutInvocation = false;
        }
    }

    void checkChangesAllowed() {
        if (!this.backgorundLayoutEnabled && !this.externalLayoutInvocation) {
            throw new RuntimeException("Layout not allowed to perform changes in layout context!");
        }
    }

    void fireNodeAddedEvent(NodeLayout node) {
        boolean intercepted = !this.eventsOn;
        GraphStructureListener[] listeners = this.graphStructureListeners.toArray(new GraphStructureListener[this.graphStructureListeners.size()]);
        int i = 0;
        while (i < listeners.length && !intercepted) {
            intercepted = listeners[i].nodeAdded((LayoutContext)this, node);
            ++i;
        }
        if (!intercepted) {
            this.applyMainAlgorithm();
        }
    }

    void fireNodeRemovedEvent(NodeLayout node) {
        boolean intercepted = !this.eventsOn;
        GraphStructureListener[] listeners = this.graphStructureListeners.toArray(new GraphStructureListener[this.graphStructureListeners.size()]);
        int i = 0;
        while (i < listeners.length && !intercepted) {
            intercepted = listeners[i].nodeRemoved((LayoutContext)this, node);
            ++i;
        }
        if (!intercepted) {
            this.applyMainAlgorithm();
        }
    }

    void fireConnectionAddedEvent(ConnectionLayout connection) {
        InternalLayoutContext targetContext;
        InternalLayoutContext sourceContext = ((InternalNodeLayout)connection.getSource()).getOwnerLayoutContext();
        if (sourceContext != (targetContext = ((InternalNodeLayout)connection.getTarget()).getOwnerLayoutContext())) {
            return;
        }
        if (sourceContext == this) {
            boolean intercepted = !this.eventsOn;
            GraphStructureListener[] listeners = this.graphStructureListeners.toArray(new GraphStructureListener[this.graphStructureListeners.size()]);
            int i = 0;
            while (i < listeners.length && !intercepted) {
                intercepted = listeners[i].connectionAdded((LayoutContext)this, connection);
                ++i;
            }
            if (!intercepted) {
                this.applyMainAlgorithm();
            }
        } else {
            sourceContext.fireConnectionAddedEvent(connection);
        }
    }

    void fireConnectionRemovedEvent(ConnectionLayout connection) {
        InternalLayoutContext targetContext;
        InternalLayoutContext sourceContext = ((InternalNodeLayout)connection.getSource()).getOwnerLayoutContext();
        if (sourceContext != (targetContext = ((InternalNodeLayout)connection.getTarget()).getOwnerLayoutContext())) {
            return;
        }
        if (sourceContext == this) {
            boolean intercepted = !this.eventsOn;
            GraphStructureListener[] listeners = this.graphStructureListeners.toArray(new GraphStructureListener[this.graphStructureListeners.size()]);
            int i = 0;
            while (i < listeners.length && !intercepted) {
                intercepted = listeners[i].connectionRemoved((LayoutContext)this, connection);
                ++i;
            }
            if (!intercepted) {
                this.applyMainAlgorithm();
            }
        } else {
            sourceContext.fireConnectionAddedEvent(connection);
        }
    }

    void fireBoundsChangedEvent() {
        boolean intercepted = !this.eventsOn;
        ContextListener[] listeners = this.contextListeners.toArray(new ContextListener[this.contextListeners.size()]);
        int i = 0;
        while (i < listeners.length && !intercepted) {
            intercepted = listeners[i].boundsChanged((LayoutContext)this);
            ++i;
        }
        if (!intercepted) {
            this.applyMainAlgorithm();
        }
    }

    void fireBackgroundEnableChangedEvent() {
        ContextListener[] listeners;
        ContextListener[] contextListenerArray = listeners = this.contextListeners.toArray(new ContextListener[this.contextListeners.size()]);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ContextListener listener = contextListenerArray[n2];
            listener.backgroundEnableChanged((LayoutContext)this);
            ++n2;
        }
    }

    void fireNodeMovedEvent(InternalNodeLayout node) {
        if (this.eventsOn) {
            node.refreshLocation();
        }
        boolean intercepted = !this.eventsOn;
        LayoutListener[] listeners = this.layoutListeners.toArray(new LayoutListener[this.layoutListeners.size()]);
        node.setLocation(node.getNode().getLocation().x, node.getNode().getLocation().y);
        int i = 0;
        while (i < listeners.length && !intercepted) {
            intercepted = listeners[i].nodeMoved((LayoutContext)this, (NodeLayout)node);
            ++i;
        }
        if (!intercepted) {
            this.applyMainAlgorithm();
        }
    }

    void fireNodeResizedEvent(InternalNodeLayout node) {
        if (this.eventsOn) {
            node.refreshSize();
            node.refreshLocation();
        }
        boolean intercepted = !this.eventsOn;
        LayoutListener[] listeners = this.layoutListeners.toArray(new LayoutListener[this.layoutListeners.size()]);
        int i = 0;
        while (i < listeners.length && !intercepted) {
            intercepted = listeners[i].nodeResized((LayoutContext)this, (NodeLayout)node);
            ++i;
        }
        if (!intercepted) {
            this.applyMainAlgorithm();
        }
    }

    void fireSubgraphMovedEvent(DefaultSubgraph subgraph) {
        if (this.eventsOn) {
            subgraph.refreshLocation();
        }
        boolean intercepted = !this.eventsOn;
        LayoutListener[] listeners = this.layoutListeners.toArray(new LayoutListener[this.layoutListeners.size()]);
        int i = 0;
        while (i < listeners.length && !intercepted) {
            intercepted = listeners[i].subgraphMoved((LayoutContext)this, (SubgraphLayout)subgraph);
            ++i;
        }
        if (!intercepted) {
            this.applyMainAlgorithm();
        }
    }

    void fireSubgraphResizedEvent(DefaultSubgraph subgraph) {
        if (this.eventsOn) {
            subgraph.refreshSize();
            subgraph.refreshLocation();
        }
        boolean intercepted = !this.eventsOn;
        LayoutListener[] listeners = this.layoutListeners.toArray(new LayoutListener[this.layoutListeners.size()]);
        int i = 0;
        while (i < listeners.length && !intercepted) {
            intercepted = listeners[i].subgraphResized((LayoutContext)this, (SubgraphLayout)subgraph);
            ++i;
        }
        if (!intercepted) {
            this.applyMainAlgorithm();
        }
    }
}

