/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.INamespace;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.MemberElementInfo;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceRefElement;
import org.eclipse.dltk.internal.core.SourceType;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;

public abstract class Member
extends SourceRefElement
implements IMember {
    protected Member(ModelElement parent) throws IllegalArgumentException {
        super(parent);
    }

    @Override
    protected void closing(Object info) throws ModelException {
    }

    @Override
    public ISourceRange getNameRange() throws ModelException {
        Object elementInfo = this.getElementInfo();
        if (elementInfo instanceof MemberElementInfo) {
            MemberElementInfo info = (MemberElementInfo)elementInfo;
            return new SourceRange(info.getNameSourceStart(), info.getNameSourceEnd() - info.getNameSourceStart() + 1);
        }
        return null;
    }

    @Override
    public int getFlags() throws ModelException {
        Object o = this.getElementInfo();
        if (o instanceof MemberElementInfo) {
            MemberElementInfo info = (MemberElementInfo)o;
            return info.getModifiers();
        }
        return 0;
    }

    @Override
    public INamespace getNamespace() throws ModelException {
        return ((MemberElementInfo)this.getElementInfo()).getNamespace();
    }

    @Override
    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, workingCopyOwner);
            }
            case '[': {
                String typeName;
                if (memento.hasMoreTokens()) {
                    typeName = memento.nextToken();
                    char firstChar = typeName.charAt(0);
                    if (firstChar == '^' || firstChar == '~' || firstChar == '[' || firstChar == '!') {
                        token = typeName;
                        typeName = "";
                    } else {
                        token = null;
                    }
                } else {
                    typeName = "";
                    token = null;
                }
                ModelElement type = (ModelElement)((Object)this.getType(typeName, 1));
                if (token == null) {
                    return type.getHandleFromMemento(memento, workingCopyOwner);
                }
                return type.getHandleFromMemento(token, memento, workingCopyOwner);
            }
        }
        return null;
    }

    @Override
    public IType getType(String typeName, int count) {
        SourceType type = new SourceType(this, typeName);
        type.occurrenceCount = count;
        return type;
    }

    @Override
    public IType getDeclaringType() {
        ModelElement parentElement = (ModelElement)this.getParent();
        if (parentElement.getElementType() == 7) {
            return (IType)((Object)parentElement);
        }
        return null;
    }

    public static IMethod[] findMethods(IMethod method, IMethod[] methods) {
        String[] parameters;
        String elementName = method.getElementName();
        try {
            parameters = method.getParameterNames();
        }
        catch (ModelException e) {
            parameters = CharOperation.NO_STRINGS;
            e.printStackTrace();
        }
        ArrayList<IMethod> list = new ArrayList<IMethod>();
        int i = 0;
        int length = methods.length;
        while (i < length) {
            IMethod existingMethod = methods[i];
            try {
                if (Member.areSimilarMethods(elementName, parameters, existingMethod.getElementName(), existingMethod.getParameterNames())) {
                    list.add(existingMethod);
                }
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
            ++i;
        }
        int size = list.size();
        if (size == 0) {
            return null;
        }
        return list.toArray(new IMethod[size]);
    }

    protected static boolean areSimilarMethods(String name1, String[] params1, String name2, String[] params2) {
        int params1Length;
        if (name1.equals(name2) && (params1Length = params1.length) == params2.length) {
            int i = 0;
            while (i < params1Length) {
                String simpleName1 = params1[i];
                String simpleName2 = params2[i];
                if (!simpleName1.equals(simpleName2)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Member getOuterMostLocalContext() {
        Member member = this;
        Member lastLocalContext = null;
        while (true) {
            void var1_2;
            switch (var1_2.getElementType()) {
                case 5: {
                    return lastLocalContext;
                }
                case 7: {
                    break;
                }
                case 8: 
                case 9: {
                    lastLocalContext = (Member)var1_2;
                }
            }
            IModelElement iModelElement = var1_2.getParent();
        }
    }
}

