/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.CDOElement;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckoutManager;
import org.eclipse.emf.cdo.explorer.repositories.CDORepositoryManager;
import org.eclipse.emf.cdo.internal.explorer.bundle.OM;
import org.eclipse.emf.cdo.internal.explorer.checkouts.CDOCheckoutImpl;
import org.eclipse.emf.cdo.internal.explorer.checkouts.CDOCheckoutViewProvider;
import org.eclipse.emf.cdo.internal.explorer.resources.CDOCheckoutFileSystem;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.registry.IRegistry;

public final class CDOExplorerUtil {
    public static final String URI_SCHEME = "cdo.checkout";

    public static CDORepositoryManager getRepositoryManager() {
        return OM.getRepositoryManager();
    }

    public static CDOCheckoutManager getCheckoutManager() {
        return OM.getCheckoutManager();
    }

    public static CDOCheckout getCheckout(Object object) {
        Notifier notifier;
        CDOView view;
        CDOView view2;
        CDOCheckoutManager checkoutManager = CDOExplorerUtil.getCheckoutManager();
        if (checkoutManager == null) {
            return null;
        }
        CDOCheckout checkout = CDOCheckoutImpl.VIEW_CHECKOUT.get();
        if (checkout != null) {
            return checkout;
        }
        if (object instanceof CDOView && !(view2 = (CDOView)object).isClosed()) {
            IRegistry properties = view2.properties();
            return (CDOCheckout)properties.get((Object)CDOCheckoutImpl.CHECKOUT_KEY);
        }
        if (object instanceof URI) {
            URI uri = (URI)object;
            return CDOCheckoutViewProvider.getCheckout(uri);
        }
        if (object instanceof String) {
            String id = (String)object;
            return checkoutManager.getCheckout(id);
        }
        checkout = CDOExplorerUtil.walkUp(object, null);
        if (checkout != null) {
            return checkout;
        }
        if (object instanceof Notifier && (view = CDOUtil.getView((Notifier)(notifier = (Notifier)object))) != null) {
            return CDOExplorerUtil.getCheckout(view);
        }
        return null;
    }

    public static Object getParent(Object object) {
        CDOElement cdoElement = (CDOElement)AdapterUtil.adapt((Object)object, CDOElement.class);
        if (cdoElement != null) {
            return cdoElement.getParent();
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            CDOElement element = (CDOElement)EcoreUtil.getExistingAdapter((Notifier)eObject, CDOElement.class);
            if (element != null) {
                return element;
            }
            return CDOElement.getParentOf((EObject)eObject);
        }
        return null;
    }

    public static String getName(Object object) {
        if (object instanceof CDOCheckout) {
            CDOCheckout checkout = (CDOCheckout)object;
            return checkout.getLabel();
        }
        if (object instanceof CDOResourceNode) {
            CDOResourceNode resourceNode = (CDOResourceNode)object;
            return resourceNode.getName();
        }
        return null;
    }

    public static LinkedList<Object> getPath(Object object) {
        LinkedList<Object> path = new LinkedList<Object>();
        if (CDOExplorerUtil.walkUp(object, path) != null) {
            return path;
        }
        return null;
    }

    public static CDOCheckout walkUp(Object object, LinkedList<Object> path) {
        while (object != null) {
            EObject eObject;
            Adapter adapter;
            if (path != null) {
                path.addFirst(object);
            }
            if (object instanceof CDOCheckout) {
                return (CDOCheckout)object;
            }
            if (object instanceof EObject && (adapter = EcoreUtil.getAdapter((List)(eObject = (EObject)object).eAdapters(), CDOCheckout.class)) != null) {
                return (CDOCheckout)adapter;
            }
            object = CDOExplorerUtil.getParent(object);
        }
        return null;
    }

    public static String getCDOIDString(CDOID id) {
        StringBuilder builder = new StringBuilder();
        CDOIDUtil.write((StringBuilder)builder, (CDOID)id);
        return builder.toString();
    }

    public static IResource createWorkspaceLink(CDOCheckout checkout, String sourcePath, IContainer targetContainer, String targetName, boolean shallowTimeStamp, IProgressMonitor monitor) throws CoreException {
        CDOView view = checkout.getView();
        if (view == null) {
            throw new CDOException("Checkout not open: " + checkout);
        }
        CDOResourceNode node = view.getResourceNode(sourcePath);
        boolean isFolder = CDOExplorerUtil.isFolder(node);
        java.net.URI uri = CDOCheckoutFileSystem.createURI(checkout, sourcePath, shallowTimeStamp);
        if (targetContainer instanceof IWorkspaceRoot) {
            throw new CDOException("File resource can not be linked as project: " + sourcePath);
        }
        Path targetPath = new Path(targetName);
        if (isFolder) {
            IFolder folder = targetContainer.getFolder((IPath)targetPath);
            folder.createLink(uri, 16, monitor);
            return folder;
        }
        IFile file = targetContainer.getFile((IPath)targetPath);
        file.createLink(uri, 16, monitor);
        return file;
    }

    public static IResource createWorkspaceLink(CDOCheckout checkout, String sourcePath, IContainer targetContainer, String targetName, IProgressMonitor monitor) throws CoreException {
        return CDOExplorerUtil.createWorkspaceLink(checkout, sourcePath, targetContainer, targetName, false, monitor);
    }

    private static boolean isFolder(CDOResourceNode node) {
        return node instanceof CDOResourceFolder || node.isRoot();
    }
}

