/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.folding;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.ui.editor.folding.DefaultFoldedPosition;
import org.eclipse.xtext.ui.editor.folding.FoldedPosition;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionAcceptorExtension;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public class DefaultFoldingRegionAcceptor
implements IFoldingRegionAcceptorExtension<ITextRegion> {
    private static final Logger log = Logger.getLogger(DefaultFoldingRegionAcceptor.class);
    private Collection<FoldedPosition> result;
    private IXtextDocument xtextDocument;

    public DefaultFoldingRegionAcceptor(IXtextDocument document, Collection<FoldedPosition> result) {
        this.result = result;
        this.xtextDocument = document;
    }

    @Override
    public void accept(int offset, int length, boolean initiallyFolded, ITextRegion significantRegion) {
        FoldedPosition foldingRegion;
        IRegion position = this.getLineRegion(offset, length);
        try {
            int lastLine;
            int firstLine;
            if (this.xtextDocument != null && significantRegion != null && (firstLine = this.xtextDocument.getLineOfOffset(significantRegion.getOffset())) != (lastLine = this.xtextDocument.getLineOfOffset(significantRegion.getEndOffset()))) {
                int endOffset = this.xtextDocument.getLineOffset(firstLine) + this.xtextDocument.getLineLength(firstLine);
                significantRegion = new TextRegion(significantRegion.getOffset(), endOffset - significantRegion.getOffset());
            }
        }
        catch (BadLocationException firstLine) {
            // empty catch block
        }
        if ((foldingRegion = this.newFoldedPosition(position, significantRegion)) != null) {
            if (foldingRegion instanceof DefaultFoldedPosition) {
                ((DefaultFoldedPosition)foldingRegion).setInitiallyFolded(initiallyFolded);
            }
            this.result.add(foldingRegion);
        }
    }

    @Override
    public void accept(int offset, int length, ITextRegion significantRegion) {
        this.accept(offset, length, false, significantRegion);
    }

    @Override
    public void accept(int offset, int length, boolean initiallyFolded) {
        this.accept(offset, length, initiallyFolded, null);
    }

    @Override
    public void accept(int offset, int length) {
        this.accept(offset, length, false, null);
    }

    protected IRegion getLineRegion(int offset, int length) {
        Region position;
        block3: {
            position = null;
            try {
                int startLine = this.xtextDocument.getLineOfOffset(offset);
                int endLine = this.xtextDocument.getLineOfOffset(offset + length);
                if (startLine < endLine) {
                    int start = this.xtextDocument.getLineOffset(startLine);
                    int end = this.xtextDocument.getLineOffset(endLine) + this.xtextDocument.getLineLength(endLine);
                    position = new Region(start, end - start);
                }
            }
            catch (BadLocationException e) {
                if (!log.isInfoEnabled()) break block3;
                log.info((Object)e.getMessage(), (Throwable)e);
            }
        }
        return position;
    }

    protected FoldedPosition newFoldedPosition(IRegion region, ITextRegion significantRegion) {
        return this.newFoldedPosition(region, significantRegion, false);
    }

    @Deprecated
    protected FoldedPosition newFoldedPosition(IRegion region, ITextRegion significantRegion, boolean initiallyFolded) {
        if (region == null) {
            return null;
        }
        if (significantRegion != null) {
            return new DefaultFoldedPosition(region.getOffset(), region.getLength(), significantRegion.getOffset() - region.getOffset(), significantRegion.getLength(), initiallyFolded);
        }
        return new DefaultFoldedPosition(region.getOffset(), region.getLength(), -1, -1, initiallyFolded);
    }
}

