/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.query;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.RangeHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.query.RangeComparator;
import org.eclipse.sirius.diagram.sequence.tool.internal.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.ext.base.Option;

public class SequenceDiagramQuery {
    private SequenceDiagram sequenceDiagram;

    public SequenceDiagramQuery(SequenceDiagram sequenceDiagram) {
        this.sequenceDiagram = sequenceDiagram;
    }

    public Set<ISequenceEvent> getAllSequenceEventsLowerThan(int timePoint) {
        Objects.requireNonNull(this.sequenceDiagram, Messages.SequenceDiagramQuery_nullSequenceDiagram);
        Preconditions.checkArgument((timePoint > 0 ? 1 : 0) != 0, (Object)Messages.SequenceDiagramQuery_invalidTimePoint);
        TreeSet<ISequenceElement> sequenceEventLowers = new TreeSet<ISequenceElement>(new RangeComparator());
        for (ISequenceEvent sequenceEvent : this.getAllSequenceEvents()) {
            Range sequenceEventRange = sequenceEvent.getVerticalRange();
            if (sequenceEventRange.getLowerBound() >= timePoint) continue;
            sequenceEventLowers.add(sequenceEvent);
        }
        return sequenceEventLowers;
    }

    public Set<ISequenceEvent> getAllSequenceEventsOn(int timePoint) {
        Objects.requireNonNull(this.sequenceDiagram, Messages.SequenceDiagramQuery_nullSequenceDiagram);
        Preconditions.checkArgument((timePoint > 0 ? 1 : 0) != 0, (Object)Messages.SequenceDiagramQuery_invalidTimePoint);
        TreeSet<ISequenceElement> sequenceEventOns = new TreeSet<ISequenceElement>(new RangeComparator());
        for (ISequenceEvent sequenceEvent : this.getAllSequenceEvents()) {
            Range sequenceEventRange = sequenceEvent.getVerticalRange();
            if (!sequenceEventRange.includes(timePoint)) continue;
            sequenceEventOns.add(sequenceEvent);
        }
        return sequenceEventOns;
    }

    public Set<ISequenceEvent> getAllSequenceEventsUpperThan(int timePoint) {
        Objects.requireNonNull(this.sequenceDiagram, Messages.SequenceDiagramQuery_nullSequenceDiagram);
        Preconditions.checkArgument((timePoint > 0 ? 1 : 0) != 0, (Object)Messages.SequenceDiagramQuery_invalidTimePoint);
        TreeSet<ISequenceElement> sequenceEventUppers = new TreeSet<ISequenceElement>(new RangeComparator());
        for (ISequenceEvent sequenceEvent : this.getAllSequenceEvents()) {
            Range sequenceEventRange = sequenceEvent.getVerticalRange();
            if (sequenceEventRange.getLowerBound() <= timePoint) continue;
            sequenceEventUppers.add(sequenceEvent);
        }
        return sequenceEventUppers;
    }

    public Set<ISequenceEvent> getAllSequenceEvents() {
        Objects.requireNonNull(this.sequenceDiagram, Messages.SequenceDiagramQuery_nullSequenceDiagram);
        TreeSet<ISequenceElement> allSequenceEvents = new TreeSet<ISequenceElement>(new RangeComparator());
        allSequenceEvents.addAll(this.sequenceDiagram.getAllLifelines());
        allSequenceEvents.addAll(this.sequenceDiagram.getAllAbstractNodeEvents());
        allSequenceEvents.addAll(this.sequenceDiagram.getAllMessages());
        allSequenceEvents.addAll(this.sequenceDiagram.getAllInteractionUses());
        allSequenceEvents.addAll(this.sequenceDiagram.getAllCombinedFragments());
        allSequenceEvents.addAll(this.sequenceDiagram.getAllOperands());
        allSequenceEvents.addAll(this.sequenceDiagram.getAllStates());
        return allSequenceEvents;
    }

    public Set<ISequenceEvent> getAllSequenceEventsOnLifeline(Lifeline lifeline) {
        TreeSet<ISequenceElement> allSequenceEventsOnLifeline = new TreeSet<ISequenceElement>(new RangeComparator());
        for (ISequenceEvent sequenceEvent : Iterables.filter(this.getAllSequenceEvents(), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(Lifeline.class)))) {
            AbstractFrame abstractFrame;
            Collection<Lifeline> coveredLifelines;
            Option<Lifeline> lifelineOfSequenceEventOption = sequenceEvent.getLifeline();
            if (lifelineOfSequenceEventOption.some() && ((Lifeline)lifelineOfSequenceEventOption.get()).equals(lifeline)) {
                allSequenceEventsOnLifeline.add(sequenceEvent);
                continue;
            }
            if (lifelineOfSequenceEventOption.some()) continue;
            if (sequenceEvent instanceof Message) {
                Message message = (Message)sequenceEvent;
                Option<Lifeline> sourceLifelineOption = message.getSourceLifeline();
                Option<Lifeline> targetLifelineOption = message.getTargetLifeline();
                if (sourceLifelineOption.some() && ((Lifeline)sourceLifelineOption.get()).equals(lifeline)) {
                    allSequenceEventsOnLifeline.add(message);
                    continue;
                }
                if (!targetLifelineOption.some() || !((Lifeline)targetLifelineOption.get()).equals(lifeline)) continue;
                allSequenceEventsOnLifeline.add(message);
                continue;
            }
            if (!(sequenceEvent instanceof AbstractFrame) || !(coveredLifelines = (abstractFrame = (AbstractFrame)sequenceEvent).computeCoveredLifelines()).contains(lifeline)) continue;
            allSequenceEventsOnLifeline.add(abstractFrame);
        }
        return allSequenceEventsOnLifeline;
    }

    public SortedSet<ISequenceEvent> getAllSequenceEventsOnLifelineOnRange(Lifeline lifeline, Range inclusionRange) {
        TreeSet<ISequenceElement> allSequenceEventsOnLifelineStrictlyIncludedBetween = new TreeSet<ISequenceElement>(new RangeComparator());
        for (ISequenceEvent sequenceEvent : this.getAllSequenceEventsOnLifeline(lifeline)) {
            Range sequenceEventRange = sequenceEvent.getVerticalRange();
            if (!inclusionRange.includesAtLeastOneBound(sequenceEventRange)) continue;
            allSequenceEventsOnLifelineStrictlyIncludedBetween.add(sequenceEvent);
        }
        return allSequenceEventsOnLifelineStrictlyIncludedBetween;
    }

    public Set<ISequenceNode> getAllSequenceNodesLowerThan(int timePoint) {
        Objects.requireNonNull(this.sequenceDiagram, Messages.SequenceDiagramQuery_nullSequenceDiagram);
        Preconditions.checkArgument((timePoint > 0 ? 1 : 0) != 0, (Object)Messages.SequenceDiagramQuery_invalidTimePoint);
        TreeSet<ISequenceElement> sequenceNodeLowers = new TreeSet<ISequenceElement>(new RangeComparator());
        for (ISequenceNode sequenceNode : this.getAllSequenceNodes()) {
            Range sequenceNodeRange = RangeHelper.verticalRange(sequenceNode.getBounds());
            if (sequenceNodeRange.getLowerBound() >= timePoint) continue;
            sequenceNodeLowers.add(sequenceNode);
        }
        return sequenceNodeLowers;
    }

    public Set<ISequenceNode> getAllSequenceNodesOn(int timePoint) {
        Objects.requireNonNull(this.sequenceDiagram, Messages.SequenceDiagramQuery_nullSequenceDiagram);
        Preconditions.checkArgument((timePoint > 0 ? 1 : 0) != 0, (Object)Messages.SequenceDiagramQuery_invalidTimePoint);
        TreeSet<ISequenceElement> sequenceNodeUnders = new TreeSet<ISequenceElement>(new RangeComparator());
        for (ISequenceNode sequenceNode : this.getAllSequenceNodes()) {
            Range sequenceEventRange = RangeHelper.verticalRange(sequenceNode.getBounds());
            if (!sequenceEventRange.includes(timePoint)) continue;
            sequenceNodeUnders.add(sequenceNode);
        }
        return sequenceNodeUnders;
    }

    public Set<ISequenceNode> getAllSequenceNodesUpperThan(int timePoint) {
        Objects.requireNonNull(this.sequenceDiagram, Messages.SequenceDiagramQuery_nullSequenceDiagram);
        Preconditions.checkArgument((timePoint > 0 ? 1 : 0) != 0, (Object)Messages.SequenceDiagramQuery_invalidTimePoint);
        TreeSet<ISequenceElement> sequenceNodeUnders = new TreeSet<ISequenceElement>(new RangeComparator());
        for (ISequenceNode sequenceNode : this.getAllSequenceNodes()) {
            Range sequenceNodeRange = RangeHelper.verticalRange(sequenceNode.getBounds());
            if (sequenceNodeRange.getLowerBound() <= timePoint) continue;
            sequenceNodeUnders.add(sequenceNode);
        }
        return sequenceNodeUnders;
    }

    public Set<ISequenceNode> getAllSequenceNodes() {
        Objects.requireNonNull(this.sequenceDiagram, Messages.SequenceDiagramQuery_nullSequenceDiagram);
        TreeSet<ISequenceElement> allSequenceNodes = new TreeSet<ISequenceElement>(new RangeComparator());
        allSequenceNodes.addAll(this.sequenceDiagram.getAllInstanceRoles());
        allSequenceNodes.addAll(this.sequenceDiagram.getAllLifelines());
        allSequenceNodes.addAll(this.sequenceDiagram.getAllAbstractNodeEvents());
        allSequenceNodes.addAll(this.sequenceDiagram.getAllInteractionUses());
        allSequenceNodes.addAll(this.sequenceDiagram.getAllCombinedFragments());
        allSequenceNodes.addAll(this.sequenceDiagram.getAllOperands());
        allSequenceNodes.addAll(this.sequenceDiagram.getAllEndOfLifes());
        return allSequenceNodes;
    }

    public int getInitialTime() {
        Objects.requireNonNull(this.sequenceDiagram, Messages.SequenceDiagramQuery_nullSequenceDiagram);
        int initialTime = 0;
        for (Lifeline lifeline : this.sequenceDiagram.getAllLifelines()) {
            int initialTimeCandidate = lifeline.getVerticalRange().getLowerBound();
            if (initialTimeCandidate <= initialTime || lifeline.getInstanceRole().isExplicitlyCreated()) continue;
            initialTime = initialTimeCandidate;
        }
        return initialTime + 30 + IBorderItemOffsets.DEFAULT_OFFSET.height;
    }

    public int getFinalTime() {
        Objects.requireNonNull(this.sequenceDiagram, Messages.SequenceDiagramQuery_nullSequenceDiagram);
        int finalTime = 0;
        if (!this.sequenceDiagram.getAllLifelines().isEmpty()) {
            Lifeline lifeline = this.sequenceDiagram.getAllLifelines().iterator().next();
            finalTime = lifeline.getVerticalRange().getUpperBound() - 50;
        }
        return finalTime;
    }
}

