/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.provider;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.ui.ExternalJavaActionProvider;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.api.command.ITreeCommandFactory;
import org.eclipse.sirius.tree.business.api.query.TreePopupMenuQuery;
import org.eclipse.sirius.tree.description.TreePopupMenu;
import org.eclipse.sirius.tree.ui.provider.TreeUIPlugin;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeViewerManager;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.CreateInstance;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaAction;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaActionCall;
import org.eclipse.sirius.viewpoint.description.tool.MenuItemDescription;
import org.eclipse.sirius.viewpoint.description.tool.OperationAction;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public final class TreePopupMenuContributionSupport {
    protected TransactionalEditingDomain domain;
    protected ITreeCommandFactory treeCommandFactory;

    public TreePopupMenuContributionSupport(TransactionalEditingDomain transactionalEditingDomain, ITreeCommandFactory treeCommandFactory) {
        this.domain = transactionalEditingDomain;
        this.treeCommandFactory = treeCommandFactory;
    }

    public void contributeToPopupMenu(IMenuManager menu, DTreeItem selectedItem) {
        EList popupMenus = selectedItem.getActualMapping().getPopupMenus();
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(selectedItem.getTarget());
        boolean haveCreatedAtLeastOnePopupMenu = false;
        if (interpreter == null || popupMenus.isEmpty()) {
            return;
        }
        for (TreePopupMenu popupMenu : popupMenus) {
            Boolean menuPrecondition = StringUtil.isEmpty((String)popupMenu.getPrecondition()) ? Boolean.valueOf(true) : Boolean.valueOf(RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateBoolean(selectedItem.getTarget(), (EObject)popupMenu, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition()));
            if (!menuPrecondition.booleanValue()) continue;
            MenuManager subMenu = new MenuManager(MessageTranslator.INSTANCE.getMessage((EObject)popupMenu, new IdentifiedElementQuery((IdentifiedElement)popupMenu).getLabel()), new IdentifiedElementQuery((IdentifiedElement)popupMenu).getLabel().toLowerCase());
            this.buildActionsFromTreePopupMenu((IMenuManager)subMenu, selectedItem, popupMenu, interpreter);
            if (subMenu.getSize() <= 0) continue;
            haveCreatedAtLeastOnePopupMenu = true;
            subMenu.setParent((IContributionManager)menu);
            menu.add((IContributionItem)subMenu);
            subMenu.setVisible(true);
        }
        if (haveCreatedAtLeastOnePopupMenu) {
            menu.add((IContributionItem)new Separator());
        }
    }

    private void buildActionsFromTreePopupMenu(IMenuManager subMenu, DTreeItem selectedItem, TreePopupMenu popupMenu, IInterpreter interpreter) {
        for (MenuItemDescription candidateMenuItem : new TreePopupMenuQuery(popupMenu).getMenuItems()) {
            IAction action;
            Boolean menuItemPrecondition = StringUtil.isEmpty((String)candidateMenuItem.getPrecondition()) ? Boolean.valueOf(true) : Boolean.valueOf(RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateBoolean(selectedItem.getTarget(), (EObject)candidateMenuItem, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition()));
            if (!menuItemPrecondition.booleanValue() || (action = this.buildActionFromMenuItemDescription(candidateMenuItem, selectedItem)) == null) continue;
            subMenu.add(action);
        }
    }

    private IAction buildActionFromMenuItemDescription(MenuItemDescription candidateMenuItem, DTreeItem selectedItem) {
        OperationAction operation;
        IAction result = null;
        if (candidateMenuItem instanceof ExternalJavaAction) {
            ExternalJavaAction javaAction = (ExternalJavaAction)candidateMenuItem;
            if (!StringUtil.isEmpty((String)javaAction.getId())) {
                result = this.buildJavaAction(javaAction, selectedItem, new IdentifiedElementQuery((IdentifiedElement)javaAction).getLabel(), javaAction.getIcon());
            }
        } else if (candidateMenuItem instanceof ExternalJavaActionCall) {
            ExternalJavaAction javaAction = ((ExternalJavaActionCall)candidateMenuItem).getAction();
            if (javaAction != null && !StringUtil.isEmpty((String)javaAction.getId())) {
                String iconPath = ((ExternalJavaActionCall)candidateMenuItem).getIcon();
                if (StringUtil.isEmpty((String)iconPath)) {
                    iconPath = javaAction.getIcon();
                }
                result = this.buildJavaAction(javaAction, selectedItem, new IdentifiedElementQuery((IdentifiedElement)candidateMenuItem).getLabel(), iconPath);
            }
        } else if (candidateMenuItem instanceof OperationAction && (operation = (OperationAction)candidateMenuItem).getInitialOperation().getFirstModelOperations() != null) {
            result = this.buildOperationAction(operation, selectedItem);
        }
        return result;
    }

    private IAction buildJavaAction(ExternalJavaAction javaActionItem, DTreeItem selectedItem, String nameOfTheAction, String iconPath) {
        Command command;
        IExternalJavaAction javaAction = ExternalJavaActionProvider.INSTANCE.getJavaActionById(javaActionItem.getId());
        if (javaAction != null && (command = this.treeCommandFactory.buildJavaActionFromTool(javaActionItem, selectedItem, javaAction)).canExecute()) {
            ImageDescriptor imageDescriptor = null;
            if (!StringUtil.isEmpty((String)iconPath)) {
                imageDescriptor = TreeUIPlugin.findImageDescriptor(iconPath);
            }
            return new Action(nameOfTheAction, imageDescriptor){

                public void run() {
                    super.run();
                    TreePopupMenuContributionSupport.this.domain.getCommandStack().execute(command);
                }
            };
        }
        return null;
    }

    private IAction buildOperationAction(OperationAction operationAction, DTreeItem selectedItem) {
        ImageDescriptor imageDescriptor = null;
        imageDescriptor = !StringUtil.isEmpty((String)operationAction.getIcon()) ? TreeUIPlugin.findImageDescriptor(operationAction.getIcon()) : TreePopupMenuContributionSupport.findImageDescriptor(operationAction);
        final Command operationActionCommand = this.treeCommandFactory.buildOperationActionFromTool(operationAction, selectedItem);
        if (operationActionCommand.canExecute()) {
            return new Action(MessageTranslator.INSTANCE.getMessage((EObject)operationAction, new IdentifiedElementQuery((IdentifiedElement)operationAction).getLabel()), imageDescriptor){

                public void run() {
                    super.run();
                    TreePopupMenuContributionSupport.this.domain.getCommandStack().execute(operationActionCommand);
                }
            };
        }
        return null;
    }

    private static ImageDescriptor findImageDescriptor(OperationAction createTool) {
        ImageDescriptor semanticDescriptor;
        IItemLabelProvider labelProvider;
        ImageDescriptor descriptor = DTreeViewerManager.getImageRegistry().getDescriptor("tree/newTreeItem");
        EObject created = null;
        TreeIterator iter = createTool.eAllContents();
        while (created == null && iter.hasNext()) {
            EObject current = (EObject)iter.next();
            if (!(current instanceof CreateInstance)) continue;
            created = TreePopupMenuContributionSupport.tryToInstanciateType(createTool, created, ((CreateInstance)current).getTypeName());
        }
        if (created != null && (labelProvider = (IItemLabelProvider)TreeUIPlugin.getPlugin().getItemProvidersAdapterFactory().adapt(created, IItemLabelProvider.class)) != null && (semanticDescriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage(created))) != null) {
            descriptor = semanticDescriptor;
        }
        return descriptor;
    }

    private static EObject tryToInstanciateType(OperationAction createTool, EObject created, String map) {
        EObject result = created;
        if (!StringUtil.isEmpty((String)map)) {
            try {
                EObject anInstance;
                result = anInstance = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)createTool).createInstance(map);
            }
            catch (MetaClassNotFoundException metaClassNotFoundException) {}
        }
        return result;
    }
}

