/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.lifecycle;

import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;

public class LifecycleHook<T extends ILifecycle>
extends Lifecycle {
    private final IListener delegateListener = new LifecycleEventAdapter(){

        @Override
        protected void notifyOtherEvent(IEvent event) {
            LifecycleHook.this.delegateEvent(LifecycleHook.this.delegate, event);
        }

        @Override
        protected void onAboutToActivate(ILifecycle lifecycle) {
            LifecycleHook.this.delegateAboutToActivate(LifecycleHook.this.delegate);
        }

        @Override
        protected void onAboutToDeactivate(ILifecycle lifecycle) {
            LifecycleHook.this.delegateAboutToDeactivate(LifecycleHook.this.delegate);
        }

        @Override
        protected void onActivated(ILifecycle lifecycle) {
            LifecycleHook.this.delegateActivated(LifecycleHook.this.delegate);
            LifecycleHook.this.hookDelegateIfPossible();
        }

        @Override
        protected void onDeactivated(ILifecycle lifecycle) {
            LifecycleHook.this.unhookDelegateIfPossible();
            LifecycleHook.this.delegateDeactivated(LifecycleHook.this.delegate);
        }
    };
    private T delegate;
    private boolean listening;
    private boolean delegateHooked;

    protected final T getDelegate() {
        return this.delegate;
    }

    protected final void setDelegate(T delegate) {
        T oldDelegate = this.delegate;
        if (oldDelegate != delegate) {
            this.unhookDelegateIfPossible();
            this.delegate = delegate;
            this.hookDelegateIfPossible();
            this.delegateChanged(oldDelegate, delegate);
        }
    }

    protected void delegateChanged(T oldDelegate, T newDelegate) {
    }

    protected void delegateEvent(T delegate, IEvent event) {
    }

    protected void delegateAboutToActivate(T delegate) {
    }

    protected void delegateActivated(T delegate) {
    }

    protected void delegateAboutToDeactivate(T delegate) {
    }

    protected void delegateDeactivated(T delegate) {
    }

    @Override
    protected void doActivate() throws Exception {
        this.hookDelegateIfPossible();
    }

    @Override
    protected void doDeactivate() throws Exception {
        this.unhookDelegateIfPossible();
    }

    protected void hookDelegate(T delegate) {
    }

    protected void unhookDelegate(T delegate) {
    }

    protected boolean hookInactiveDelegates() {
        return false;
    }

    private void hookDelegateIfPossible() {
        if (!this.listening && this.delegate != null) {
            this.delegate.addListener(this.delegateListener);
            this.listening = true;
        }
        if (this.listening && !this.delegateHooked && (this.hookInactiveDelegates() || this.delegate.isActive())) {
            this.hookDelegate(this.delegate);
            this.delegateHooked = true;
        }
    }

    private void unhookDelegateIfPossible() {
        if (this.delegate != null) {
            if (this.delegateHooked) {
                this.unhookDelegate(this.delegate);
                this.delegateHooked = false;
            }
            if (this.listening) {
                this.delegate.removeListener(this.delegateListener);
                this.listening = false;
            }
        }
    }
}

