import { FileMap } from '@vue/language-core';
import * as net from 'node:net';
import type * as ts from 'typescript';
import type { NotificationData, ProjectInfo, RequestData } from './server';
export { TypeScriptProjectHost } from '@volar/typescript';
export declare function getServerPath(kind: ts.server.ProjectKind, id: number): string;
declare class NamedPipeServer {
    path: string;
    connecting: boolean;
    projectInfo?: ProjectInfo;
    containsFileCache: Map<string, Promise<boolean | null | undefined>>;
    componentNamesAndProps: FileMap<Record<string, {
        name: string;
        required?: true;
        commentMarkdown?: string;
    }[] | null>>;
    constructor(kind: ts.server.ProjectKind, id: number);
    containsFile(fileName: string): Promise<boolean | null | undefined> | undefined;
    getComponentProps(fileName: string, tag: string): Promise<{
        name: string;
        required?: true;
        commentMarkdown?: string;
    }[] | null | undefined>;
    update(): void;
    connect(): void;
    close(): void;
    socket?: net.Socket;
    seq: number;
    dataChunks: Buffer[];
    requestHandlers: Map<number, (res: any) => void>;
    onData(chunk: Buffer): void;
    onNotification(type: NotificationData[0], fileName: string, data: any): void;
    sendRequest<T>(requestType: RequestData[1], fileName: string, ...args: any[]): Promise<T | null | undefined>;
}
export declare const configuredServers: NamedPipeServer[];
export declare const inferredServers: NamedPipeServer[];
export declare const onServerReady: (() => void)[];
export declare function getBestServer(fileName: string): Promise<NamedPipeServer | undefined>;
