/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.internal.ui.services;

import java.io.File;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.services.ILabelService;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.services.LabelSelector;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.connectivity.sqm.core.ui.services.IDataToolsUIServiceManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.util.ConnectionUtil;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class LabelService
implements ILabelService {
    private static final ResourceLoader resourceLoader = ResourceLoader.getResourceLoader();
    private static final String ELEMENT_SELECTED = resourceLoader.queryString("DATATOOLS.CORE.UI.EXPLORER.MULTI_SELECTION");
    private static final String CONNECTION_NAME = resourceLoader.queryString("DATATOOLS.CORE.UI.STATUS.CONNECTION");
    private static final String PROJECT_NAME = resourceLoader.queryString("DATATOOLS.CORE.UI.STATUS.PROJECT");
    private static final String BLANK = "";
    private Map typeProvider = new HashMap();
    private Object element;
    private LabelInfo labelInfo;

    public LabelService() {
        this.initializeLabelServiceProvider();
    }

    private void initializeLabelServiceProvider() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.connectivity.sqm.core.ui", "labelService");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals("contributor")) {
                    String displayType = configElements[j].getAttribute("displayType");
                    String iconLocation = configElements[j].getAttribute("iconLocation");
                    String type = configElements[j].getAttribute("type");
                    try {
                        LabelSelector selector;
                        Bundle bundle = Platform.getBundle((String)configElements[j].getDeclaringExtension().getNamespace());
                        LabelSelector labelSelector = selector = configElements[j].getAttribute("selector") != null ? (LabelSelector)configElements[j].createExecutableExtension("selector") : null;
                        if (!this.typeProvider.containsKey(type)) {
                            this.typeProvider.put(type, new ArrayList());
                        }
                        ((List)this.typeProvider.get(type)).add(new LabelInfo(bundle, iconLocation, displayType, selector));
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private LabelInfo getLabelInfo(EClass metaclass) {
        Vector sortedClasses = this.computeClassOrder(metaclass);
        LabelInfo provider = this.getProvider(sortedClasses);
        return provider;
    }

    private LabelInfo getLabelInfo(Class metaclass) {
        Vector sortedClasses = this.computeClassOrder(metaclass);
        LabelInfo provider = this.getClassProvider(sortedClasses);
        return provider;
    }

    private Vector computeClassOrder(Class metaclass) {
        Vector result = new Vector(4);
        result.addElement(metaclass);
        int index = 0;
        index = 0;
        while (index < result.size()) {
            Class clazz = (Class)result.elementAt(index);
            Class<?>[] it = clazz.getInterfaces();
            int i = 0;
            int n = it.length;
            while (i < n) {
                result.addElement(it[i]);
                ++i;
            }
            ++index;
        }
        return result;
    }

    private Vector computeClassOrder(EClass metaclass) {
        Vector<Object> result = new Vector<Object>(4);
        result.addElement(metaclass);
        int index = 0;
        index = 0;
        while (index < result.size()) {
            EClass clazz = (EClass)result.elementAt(index);
            Iterator it = clazz.getESuperTypes().iterator();
            while (it.hasNext()) {
                result.addElement(it.next());
            }
            ++index;
        }
        return result;
    }

    private LabelInfo getClassProvider(Vector classes) {
        int count = classes.size();
        int i = 0;
        while (i < count) {
            Class clazz = (Class)classes.elementAt(i);
            String name = clazz.getName();
            if (this.typeProvider.containsKey(name)) {
                for (LabelInfo localLabelInfo : (List)this.typeProvider.get(name)) {
                    if (localLabelInfo.getSelector() == null) {
                        return localLabelInfo;
                    }
                    if (!localLabelInfo.getSelector().select(this.element)) continue;
                    return localLabelInfo;
                }
            }
            ++i;
        }
        return null;
    }

    private LabelInfo getProvider(Vector classes) {
        int count = classes.size();
        int i = 0;
        while (i < count) {
            EClass clazz = (EClass)classes.elementAt(i);
            String name = clazz.getInstanceClassName();
            if (this.typeProvider.containsKey(name)) {
                for (LabelInfo localLabelInfo : (List)this.typeProvider.get(name)) {
                    if (localLabelInfo.getSelector() == null) {
                        return localLabelInfo;
                    }
                    if (!localLabelInfo.getSelector().select(this.element)) continue;
                    return localLabelInfo;
                }
            }
            ++i;
        }
        return null;
    }

    private LabelInfo getLabelInfo() {
        if (this.element instanceof EClass) {
            return this.getLabelInfo((EClass)this.element);
        }
        if (this.element instanceof EObject) {
            return this.getLabelInfo(((EObject)this.element).eClass());
        }
        if (this.element instanceof Class) {
            return this.getLabelInfo((Class)this.element);
        }
        return this.getLabelInfo(this.element.getClass());
    }

    private void findService() {
        this.labelInfo = this.getLabelInfo();
    }

    private boolean matchLabelService() {
        if (this.labelInfo == null) {
            this.findService();
        }
        return this.labelInfo != null;
    }

    public void setElement(Object element) {
        this.labelInfo = null;
        this.element = element;
    }

    @Override
    public Image getIcon() {
        if (this.element instanceof ILabelProvider) {
            return ((ILabelProvider)this.element).getImage(this.element);
        }
        if (this.matchLabelService()) {
            return this.labelInfo.getIcon();
        }
        return null;
    }

    @Override
    public String getDisplayType() {
        if (this.matchLabelService()) {
            String displayType = this.labelInfo.getDisplayType();
            return displayType != null ? displayType : (this.element instanceof EObject ? ((EObject)this.element).eClass().getName() : (this.element instanceof IVirtualNode ? ((IVirtualNode)this.element).getDisplayName() : null));
        }
        return null;
    }

    private String buildConnectionName(Object object, String name) {
        String connectionName = ConnectionUtil.getConnectionForEObject((EObject)((ICatalogObject)object).getCatalogDatabase()).getName();
        return MessageFormat.format(CONNECTION_NAME, name, connectionName);
    }

    private String buildResourceName(String resourcePath, String name) {
        return MessageFormat.format(PROJECT_NAME, name, resourcePath);
    }

    public static String getResourcePath(Resource resource) {
        String fileName = BLANK;
        if (resource == null || resource.getURI() == null) {
            return null;
        }
        String[] segments = resource.getURI().segments();
        int j = 1;
        int n = segments.length;
        while (j < n) {
            fileName = String.valueOf(fileName) + (segments[j].indexOf(File.separator) != -1 ? segments[j] : String.valueOf(File.separator) + segments[j]);
            ++j;
        }
        return fileName;
    }

    private IFile getIFile(Resource resource) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String fileString = LabelService.getResourcePath(resource);
        if (fileString != null && !fileString.equals(BLANK)) {
            return workspaceRoot.getFile((IPath)new Path(fileString));
        }
        return null;
    }

    private String getIResourcePath(Object object) {
        if (object == null || !(object instanceof EObject)) {
            return null;
        }
        return this.getIResourcePath(this.getIFile(((EObject)object).eResource()));
    }

    private String getIResourcePath(IFile file) {
        return file == null ? null : file.getFullPath().toOSString();
    }

    private Object getParent(IVirtualNode object) {
        Object parent = null;
        while (!((parent = object.getParent()) instanceof SQLObject)) {
            if (!(parent instanceof IVirtualNode)) break;
            object = (IVirtualNode)parent;
        }
        return parent;
    }

    private String getFullName(ENamedElement object) {
        return "<" + IDataToolsUIServiceManager.INSTANCE.getLabelService(object).getDisplayType() + "> " + object.getName();
    }

    private String getFullName(IVirtualNode object) {
        return "<" + IDataToolsUIServiceManager.INSTANCE.getLabelService(object).getDisplayType() + "> " + object.getDisplayName();
    }

    private String getFullName(EObject object, String name) {
        return "<" + IDataToolsUIServiceManager.INSTANCE.getLabelService(object).getDisplayType() + "> " + name;
    }

    private String getName(ENamedElement object) {
        if (object instanceof ICatalogObject) {
            return this.buildConnectionName(object, this.getFullName(object));
        }
        String projectPath = this.getIResourcePath(object);
        if (projectPath == null) {
            return this.getFullName(object);
        }
        return this.buildResourceName(projectPath, this.getFullName(object));
    }

    private String getName(EObject object) {
        Method method = object.getClass().getMethod("getName", new Class[0]);
        try {
            String name = (String)method.invoke((Object)object, new Object[0]);
            if (this.getIFile(object.eResource()) != null) {
                return this.buildResourceName(LabelService.getResourcePath(object.eResource()), this.getFullName(object, name));
            }
            if (object.eContainer() != null && object.eContainer() instanceof ICatalogObject) {
                return this.buildConnectionName(object.eContainer(), this.getFullName(object, name));
            }
            return this.getFullName(object, name);
        }
        catch (Exception exception) {
            try {
            }
            catch (Exception exception2) {}
        }
        return BLANK;
    }

    private String getName(IAdaptable object) {
        Object file = object.getAdapter(IFile.class);
        if (file != null) {
            return this.getIResourcePath((IFile)file);
        }
        return BLANK;
    }

    private String getName(IVirtualNode object) {
        Object parent = this.getParent(object);
        if (parent != null && parent instanceof ICatalogObject) {
            return this.buildConnectionName(parent, this.getFullName(object));
        }
        if (object instanceof IAdaptable && ((IAdaptable)object).getAdapter(IFile.class) != null) {
            return this.buildResourceName(this.getIResourcePath((IFile)((IAdaptable)object).getAdapter(IFile.class)), this.getFullName(object));
        }
        String project = this.getIResourcePath(parent);
        if (project == null) {
            return this.getFullName(object);
        }
        return this.buildResourceName(project, this.getFullName(object));
    }

    private String getName(Object object) {
        if (object instanceof ENamedElement) {
            return this.getName((ENamedElement)object);
        }
        if (object instanceof IVirtualNode) {
            return this.getName((IVirtualNode)object);
        }
        if (object instanceof IAdaptable) {
            return this.getName((IAdaptable)object);
        }
        if (object instanceof EObject) {
            return this.getName((EObject)object);
        }
        if (object instanceof ILabelProvider) {
            return ((ILabelProvider)object).getText(object);
        }
        return BLANK;
    }

    @Override
    public String getName() {
        if (this.element instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)this.element;
            if (selection.size() == 1) {
                return this.getName(selection.getFirstElement());
            }
            if (selection.size() > 1) {
                return MessageFormat.format(ELEMENT_SELECTED, BLANK + selection.size());
            }
        }
        return this.getName(this.element);
    }

    private class LabelInfo {
        private Bundle iconBundle;
        private String iconLocation;
        private String displayType;
        private LabelSelector selector;

        public LabelInfo(Bundle iconBundle, String iconLocation, String displayType, LabelSelector selector) {
            this.iconBundle = iconBundle;
            this.iconLocation = iconLocation;
            this.displayType = displayType;
            this.selector = selector;
        }

        public Image getIcon() {
            return resourceLoader.queryAbsolutePathImageFromRegistry(this.iconBundle, this.iconLocation);
        }

        public String getDisplayType() {
            return this.displayType;
        }

        public LabelSelector getSelector() {
            return this.selector;
        }
    }
}

