/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.taglibprocessing.attributevalues;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.impl.StructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.metadataprocessors.AbstractRootTypeDescriptor;
import org.eclipse.jst.jsf.metadataprocessors.IMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.features.IPossibleValue;
import org.eclipse.jst.jsf.metadataprocessors.features.IPossibleValues;
import org.eclipse.jst.jsf.metadataprocessors.features.PossibleValue;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetListAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.util.CSSClassTraverser;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.w3c.dom.Document;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

public class CSSClassType
extends AbstractRootTypeDescriptor
implements IMetaDataEnabledFeature,
IPossibleValues {
    private List<IPossibleValue> _pvs;

    @Override
    public List<IPossibleValue> getPossibleValues() {
        if (this.getStructuredDocumentContext() != null && this._pvs == null) {
            IDOMContextResolver resolver = StructuredDocumentContextResolverFactory.getInstance().getDOMContextResolver(this.getStructuredDocumentContext());
            this._pvs = this.getCSSClasses(resolver.getDOMDocument());
        }
        return this._pvs;
    }

    private List<IPossibleValue> getCSSClasses(Document doc) {
        ArrayList<IPossibleValue> result = new ArrayList<IPossibleValue>();
        String[] names = CSSClassType.internalGetCSSClasses(doc);
        int i = 0;
        while (i < names.length) {
            PossibleValue pv = new PossibleValue(names[i]);
            result.add(pv);
            ++i;
        }
        return result;
    }

    private static String[] internalGetCSSClasses(Document doc) {
        Collection c = Collections.EMPTY_SET;
        if (doc instanceof INodeNotifier) {
            IStyleSheetListAdapter adapter = (IStyleSheetListAdapter)((INodeNotifier)doc).getAdapterFor(IStyleSheetListAdapter.class);
            StyleSheetList ssl = adapter == null ? null : adapter.getStyleSheets();
            CSSClassTraverser traverser = new CSSClassTraverser();
            if (ssl != null) {
                int i = 0;
                int numStyles = ssl.getLength();
                while (i < numStyles) {
                    StyleSheet ss = ssl.item(i);
                    try {
                        traverser.apply((ICSSNode)ss);
                    }
                    catch (ClassCastException ex) {
                        JSFCorePlugin.log(ex, "Unable to cast to CSS style");
                    }
                    ++i;
                }
                c = traverser.getClassNames();
            }
        }
        String[] result = new String[c.size()];
        c.toArray(result);
        return result;
    }
}

