/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal.publishers;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.generic.core.internal.GenericServer;
import org.eclipse.jst.server.generic.core.internal.Trace;
import org.eclipse.jst.server.generic.core.internal.publishers.AbstractModuleAssembler;
import org.eclipse.jst.server.generic.core.internal.publishers.ModulePackager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ProjectModule;

public class EarModuleAssembler
extends AbstractModuleAssembler {
    protected EarModuleAssembler(IModule module, GenericServer server, IPath assembleRoot) {
        super(module, server, assembleRoot);
    }

    @Override
    public IPath assemble(IProgressMonitor monitor) throws CoreException {
        boolean shouldCopy;
        IPath parent = this.fAssembleRoot;
        IModule[] rootMod = new IModule[]{this.fModule};
        boolean bl = shouldCopy = 1 != this.fServer.getServer().getModulePublishState(rootMod);
        if (shouldCopy) {
            this.copyModule(this.fModule, monitor);
        }
        IEnterpriseApplication earModule = (IEnterpriseApplication)this.fModule.loadAdapter(IEnterpriseApplication.class, monitor);
        IModule[] childModules = earModule.getModules();
        int i = 0;
        while (i < childModules.length) {
            IModule module = childModules[i];
            String uri = earModule.getURI(module);
            if (uri == null) {
                Status status = new Status(4, "org.eclipse.jst.server.generic.core", 0, "unable to assemble module null uri", null);
                throw new CoreException((IStatus)status);
            }
            IJ2EEModule jeeModule = (IJ2EEModule)module.loadAdapter(IJ2EEModule.class, monitor);
            if (jeeModule != null && jeeModule.isBinary()) {
                ProjectModule pm = (ProjectModule)module.loadAdapter(ProjectModule.class, null);
                IModuleResource[] resources = pm.members();
                this.publishHelper.publishToPath(resources, parent.append(uri), monitor);
            } else if (this.shouldRepack(module)) {
                this.packModule(module, uri, parent);
            }
            ++i;
        }
        return parent;
    }

    private boolean shouldRepack(IModule module) {
        IModule[] rootMod = new IModule[]{this.fModule};
        IModule[] modules = new IModule[]{this.fModule, module};
        boolean repack = 1 != this.fServer.getServer().getModulePublishState(modules);
        Trace.trace((byte)3, "EarModuleAssembler should repack returns " + Boolean.toString(repack |= 1 != this.fServer.getServer().getModulePublishState(rootMod)) + " for module " + String.valueOf(module));
        return repack;
    }

    @Override
    protected void packModule(IModule module, String deploymentUnitName, IPath destination) throws CoreException {
        if (module.getModuleType().getId().equals("jst.web")) {
            AbstractModuleAssembler assembler = AbstractModuleAssembler.Factory.getModuleAssembler(module, this.fServer);
            IPath webAppPath = assembler.assemble((IProgressMonitor)new NullProgressMonitor());
            String realDestination = destination.append(deploymentUnitName).toString();
            ModulePackager packager = null;
            try {
                try {
                    packager = new ModulePackager(realDestination, false);
                    packager.pack(webAppPath.toFile(), webAppPath.toOSString());
                }
                catch (IOException e) {
                    Status status = new Status(4, "org.eclipse.jst.server.generic.core", 0, "unable to assemble module", (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
            catch (Throwable throwable) {
                if (packager != null) {
                    try {
                        packager.finished();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (packager != null) {
                try {
                    packager.finished();
                }
                catch (IOException iOException) {}
            }
        } else {
            super.packModule(module, deploymentUnitName, destination);
        }
    }
}

