/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j.transport;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.utils.XMLUtils;
import org.uddi4j.transport.TransportBase;
import org.uddi4j.transport.TransportException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ApacheAxisTransport
extends TransportBase {
    @Override
    public Element send(Element el, URL url) throws TransportException {
        Element base = null;
        boolean debug = this.logEnabled();
        Call call = null;
        try {
            Service service = new Service();
            call = (Call)service.createCall();
            Properties config = this.getConfiguration();
            String username = config.getProperty("http.basicAuthUserName");
            String password = config.getProperty("http.basicAuthPassword");
            if (username != null) {
                call.setUsername(username);
            }
            if (password != null) {
                call.setPassword(password);
            }
            call.setTargetEndpointAddress(url);
            Vector result = null;
            String str = null;
            str = XMLUtils.ElementToString((Element)el);
            SOAPBodyElement body = new SOAPBodyElement((InputStream)new ByteArrayInputStream(str.getBytes("UTF8")));
            Object[] params = new Object[]{body};
            if (debug) {
                System.err.println("\nRequest message:\n" + params[0]);
            }
            result = (Vector)call.invoke(params);
            base = this.stringToElement(((SOAPBodyElement)result.elementAt(0)).toString());
        }
        catch (AxisFault fault) {
            try {
                Message m = call.getResponseMessage();
                base = this.stringToElement(m.getSOAPEnvelope().getFirstBody().toString());
            }
            catch (Exception e) {
                throw new TransportException(e);
            }
        }
        catch (Exception e) {
            throw new TransportException(e);
        }
        if (debug && base != null) {
            System.err.println("\nResponse message:\n" + XMLUtils.ElementToString((Element)base));
        }
        return base;
    }

    public Element stringToElement(String s) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(new ByteArrayInputStream(s.getBytes("UTF8")));
        return doc.getDocumentElement();
    }
}

