/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugElement;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;

public class GroupedStackFrame
extends JDIDebugElement {
    private final List<IJavaStackFrame> stackFrames = new ArrayList<IJavaStackFrame>();

    public GroupedStackFrame(JDIDebugTarget target) {
        super(target);
    }

    public void add(IJavaStackFrame frame) {
        this.stackFrames.add(frame);
    }

    public int getFrameCount() {
        return this.stackFrames.size();
    }

    public Object[] getFramesAsArray(int index, int length) {
        List<IJavaStackFrame> subList = this.stackFrames.subList(index, Math.min(index + length, this.stackFrames.size()));
        return subList.isEmpty() ? null : subList.toArray();
    }

    public IJavaStackFrame getTopMostFrame() {
        return !this.stackFrames.isEmpty() ? this.stackFrames.get(0) : null;
    }

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        Object adapter = super.getAdapter(adapterType);
        if (adapter == null && !this.stackFrames.isEmpty()) {
            adapter = this.stackFrames.get(0).getAdapter(adapterType);
        }
        return adapter;
    }
}

