/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring.code.flow;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;

public class LocalVariableIndex {
    private final Map<IVariable, Integer> variableMap = new HashMap<IVariable, Integer>();

    public LocalVariableIndex(IASTFunctionDefinition functionDefinition) {
        functionDefinition.accept(new ASTVisitor(){
            {
                this.shouldVisitNames = true;
            }

            public int visit(IASTName name) {
                IVariable variable;
                if (name instanceof ICPPASTQualifiedName || name.isQualified() || !name.isDeclaration()) {
                    return 3;
                }
                IBinding binding = name.resolveBinding();
                if (binding instanceof IVariable && !(binding instanceof IField) && !LocalVariableIndex.this.variableMap.containsKey(variable = (IVariable)binding)) {
                    LocalVariableIndex.this.variableMap.put(variable, LocalVariableIndex.this.variableMap.size());
                }
                return 3;
            }
        });
    }

    public int getNumLocalVariables() {
        return this.variableMap.size();
    }

    public int getIndexFromLocal(IVariable variable) {
        Integer index = this.variableMap.get(variable);
        return index != null ? index : -1;
    }
}

