/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.jst.jsp.ui.internal.contentassist.JavaTypeNameRequestor;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;

public class JavaTypeFinder {
    public static ICompletionProposal[] getBeanProposals(IResource resource, int replacementStart, int replacementLength) {
        ICompletionProposal[] typeProposals = JavaTypeFinder.getTypeProposals(resource, replacementStart, replacementLength);
        ICompletionProposal[] serialProposals = JavaTypeFinder.getSerializedProposals(resource, replacementStart, replacementLength);
        ICompletionProposal[] beanProposals = new ICompletionProposal[typeProposals.length + serialProposals.length];
        int i = 0;
        while (i < serialProposals.length) {
            beanProposals[i] = serialProposals[i];
            ++i;
        }
        i = serialProposals.length;
        while (i < serialProposals.length + typeProposals.length) {
            beanProposals[i] = typeProposals[i - serialProposals.length];
            ++i;
        }
        return beanProposals;
    }

    private static void getMembers(IContainer container, List membersList) {
        try {
            IResource[] members = container.members(true);
            if (members != null) {
                int i = 0;
                while (i < members.length) {
                    if (members[i].getType() == 1) {
                        membersList.add(members[i]);
                    } else if (members[i].getType() == 2) {
                        JavaTypeFinder.getMembers((IContainer)members[i], membersList);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    private static ICompletionProposal[] getSerializedProposals(IResource resource, int replacementStart, int replacementLength) {
        ArrayList<CustomCompletionProposal> names = new ArrayList<CustomCompletionProposal>();
        ArrayList resources = new ArrayList();
        JavaTypeFinder.getMembers((IContainer)resource.getProject(), resources);
        IResource memberResource = null;
        int i = 0;
        while (i < resources.size()) {
            String path;
            memberResource = (IResource)resources.get(i);
            if (memberResource.getType() == 1 && memberResource.getName().endsWith(".ser") && (path = URIHelper.normalize((String)memberResource.getFullPath().toString(), (String)resource.getFullPath().toString(), (String)resource.getProject().getFullPath().toString())) != null) {
                names.add(new CustomCompletionProposal("\"" + path + "\"", replacementStart, replacementLength, path.length() + 2, null, path, null, null, 0));
            }
            ++i;
        }
        return names.toArray(new ICompletionProposal[names.size()]);
    }

    private static ICompletionProposal[] findProposals(IResource resource, int replacementStart, int replacementLength, int searchFor, boolean ignoreAbstractClasses) {
        JavaTypeNameRequestor requestor = new JavaTypeNameRequestor();
        requestor.setJSPOffset(replacementStart);
        requestor.setReplacementLength(replacementLength);
        requestor.setIgnoreAbstractClasses(ignoreAbstractClasses);
        try {
            IJavaElement[] elements = new IJavaElement[]{JavaTypeFinder.getJavaProject(resource)};
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
            new SearchEngine().searchAllTypeNames(null, null, 3, searchFor, scope, (TypeNameRequestor)requestor, 3, null);
        }
        catch (CoreException exc) {
            Logger.logException(exc);
        }
        catch (Exception exc) {
            Logger.logException(exc);
        }
        return requestor.getProposals();
    }

    public static ICompletionProposal[] getTypeProposals(IResource resource, int replacementStart, int replacementLength) {
        return JavaTypeFinder.findProposals(resource, replacementStart, replacementLength, 0, false);
    }

    public static ICompletionProposal[] getClassProposals(IResource resource, int replacementStart, int replacementLength) {
        return JavaTypeFinder.findProposals(resource, replacementStart, replacementLength, 5, true);
    }

    private static IJavaProject getJavaProject(IResource resource) {
        IProject proj = resource.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)proj);
        return javaProject;
    }
}

