/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.target;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.file.DeletingPathVisitor;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.target.ITargetHandle;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

class CacheManager {
    private static final String LASTACCESS_MARKER = ".lastaccess";
    private static Path baseDir;
    private static final Map<String, CacheManager> MANAGERS;
    private final Path folder;
    private static final Set<OpenOption> LOCK_FILE_OPEN_OPTIONS;

    static {
        MANAGERS = new HashMap<String, CacheManager>();
        LOCK_FILE_OPEN_OPTIONS = Set.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.DELETE_ON_CLOSE);
    }

    private CacheManager(String cacheKey) {
        this.folder = CacheManager.getCacheBaseDir().resolve(cacheKey);
        try {
            Files.writeString(this.folder.resolve(LASTACCESS_MARKER), (CharSequence)"", new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Loose catch block
     */
    public synchronized <R> R accessArtifactFile(Artifact artifact, CacheConsumer<R> consumer) throws Exception {
        Path gav = Path.of(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion());
        Path gavFolder = Files.createDirectories(this.folder.resolve(gav), new FileAttribute[0]);
        Path file = gavFolder.resolve(artifact.getFile().getName());
        Path lockFile = gavFolder.resolve(artifact.getFile().getName() + ".lock");
        Throwable throwable = null;
        Object var8_9 = null;
        try {
            R r;
            FileLock lock;
            FileChannel channel;
            block16: {
                block15: {
                    channel = FileChannel.open(lockFile, LOCK_FILE_OPEN_OPTIONS, new FileAttribute[0]);
                    lock = channel.lock();
                    r = consumer.consume(file.toFile());
                    if (lock == null) break block15;
                    lock.close();
                }
                if (channel == null) break block16;
                channel.close();
            }
            return r;
            {
                catch (Throwable throwable2) {
                    try {
                        if (lock != null) {
                            lock.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (channel != null) {
                            channel.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static synchronized CacheManager forTargetHandle(ITargetHandle handle) throws CoreException {
        String targetId = DigestUtils.sha1Hex((String)handle.getMemento());
        return MANAGERS.computeIfAbsent(targetId, CacheManager::new);
    }

    private static synchronized void clearFilesOlderThan(Path cacheBaseDir, Duration timeout) {
        FileTime deleteBefore = FileTime.from(Instant.now().minus(timeout));
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DirectoryStream<Path> folders = Files.newDirectoryStream(cacheBaseDir);){
                for (Path folder : folders) {
                    Path marker;
                    if (MANAGERS.containsKey(folder.getFileName().toString()) || !Files.isRegularFile(marker = folder.resolve(LASTACCESS_MARKER), new LinkOption[0]) || Files.getLastModifiedTime(marker, new LinkOption[0]).compareTo(deleteBefore) >= 0) continue;
                    Files.walkFileTree(folder, (FileVisitor<? super Path>)DeletingPathVisitor.withLongCounters());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Platform.getLog(CacheManager.class).log(Status.error((String)"Failed to clear Maven bundle cache", (Throwable)e));
        }
    }

    private static synchronized Path getCacheBaseDir() {
        if (baseDir == null) {
            Bundle bundle = FrameworkUtil.getBundle(CacheManager.class);
            if (bundle == null) {
                throw new IllegalStateException(CacheManager.class.getSimpleName() + " not loaded from a bundle");
            }
            baseDir = bundle.getDataFile("").toPath();
            Runnable cleaner = () -> CacheManager.clearFilesOlderThan(baseDir, Duration.ofDays(14L));
            new Thread(cleaner, "Wrapped bundles cache cleaner").start();
        }
        return baseDir;
    }

    public static boolean isOutdated(File cacheFile, File sourceFile) {
        if (cacheFile.exists()) {
            long cacheTimeStamp;
            long sourceTimeStamp = sourceFile.lastModified();
            return sourceTimeStamp > (cacheTimeStamp = cacheFile.lastModified());
        }
        return true;
    }

    static interface CacheConsumer<T> {
        public T consume(File var1) throws Exception;
    }
}

