/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.cdt.ui.contentassist;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.ui.text.contentassist.CompletionProposalCategory;
import org.eclipse.cdt.internal.ui.text.contentassist.CompletionProposalComputerRegistry;
import org.eclipse.jface.preference.IPreferenceStore;

public class CDTContentAssistUtils {
    private static final String SEPARATOR_CODEASSIST = "\u0000";
    public static final String ASSIST_MYLYN_TYPE = "org.eclipse.mylyn.cdt.ui.parserProposalCategory";
    public static final String ASSIST_CDT_TYPE = "org.eclipse.cdt.ui.parserProposalCategory";

    public static void installContentAssist(IPreferenceStore cdtPrefs, boolean mylynContentAssist) {
        Set<String> disabledIds = CDTContentAssistUtils.getDisableContentAssistIds(cdtPrefs);
        if (!mylynContentAssist) {
            disabledIds.remove(ASSIST_CDT_TYPE);
            disabledIds.add(ASSIST_MYLYN_TYPE);
        } else {
            disabledIds.add(ASSIST_CDT_TYPE);
            disabledIds.remove(ASSIST_MYLYN_TYPE);
        }
        Object newValue = "";
        for (String id : disabledIds) {
            newValue = (String)newValue + id + SEPARATOR_CODEASSIST;
        }
        cdtPrefs.setValue("content_assist_disabled_computers", (String)newValue);
        CompletionProposalComputerRegistry registry = CompletionProposalComputerRegistry.getDefault();
        List categories = registry.getProposalCategories();
        for (CompletionProposalCategory cat : categories) {
            if (disabledIds.contains(cat.getId())) {
                cat.setIncluded(false);
                continue;
            }
            cat.setIncluded(true);
        }
    }

    public static Set<String> getDisableContentAssistIds(IPreferenceStore cdtPrefs) {
        String oldValue = cdtPrefs.getString("content_assist_disabled_computers");
        StringTokenizer tokenizer = new StringTokenizer(oldValue, SEPARATOR_CODEASSIST);
        HashSet<String> disabledIds = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            disabledIds.add((String)tokenizer.nextElement());
        }
        return disabledIds;
    }

    public static void updateDefaultPreference(IPreferenceStore cdtPrefs) {
        String defaultValue = cdtPrefs.getDefaultString("content_assist_disabled_computers");
        cdtPrefs.setDefault("content_assist_disabled_computers", defaultValue + "org.eclipse.mylyn.cdt.ui.parserProposalCategory\u0000");
    }
}

