/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.nls;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.nls.AvailableFilter;
import org.eclipse.pde.internal.ui.nls.InternationalizationWizardPage;
import org.eclipse.pde.internal.ui.nls.InternationalizeModelTable;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.WorkbenchJob;

public class InternationalizeWizardPluginPage
extends InternationalizationWizardPage
implements IModelProviderListener {
    private static final String CREATE_INDIVIDUAL_FRAGMENTS = "create individual fragments";
    private static final String TEMPLATE = "name_template";
    private static final String OVERWRITE = "overwrite?";
    public static final String PAGE_NAME = "InternationalizeWizardPluginPage";
    protected IPluginModelBase[] fModels = new IPluginModelBase[0];
    private boolean fRefreshNeeded = true;
    private Label fCountLabel;
    private TableViewer fAvailableViewer;
    protected TableViewer fSelectedViewer;
    private WorkbenchJob fFilterJob;
    private Text fFilterText;
    private Text fTemplateText;
    private AvailableFilter fFilter;
    private final Set<Object> fSelected = new HashSet<Object>();
    private boolean fBlockSelectionListeners;
    private Button fAddButton;
    private Button fAddAllButton;
    private Button fRemoveButton;
    private Button fRemoveAllButton;
    private final InternationalizeModelTable<IPluginModelBase> fInternationalizeModelTable;
    private Button overwriteOption;
    private Button individualFragments;

    public InternationalizeWizardPluginPage(InternationalizeModelTable<IPluginModelBase> modelTable, String pageName) {
        super(pageName);
        this.setTitle(PDEUIMessages.InternationalizeWizard_PluginPage_pageTitle);
        this.setDescription(PDEUIMessages.InternationalizeWizard_PluginPage_pageDescription);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        PDECore.getDefault().getModelManager().getExternalModelManager().addModelProviderListener((IModelProviderListener)this);
        this.fInternationalizeModelTable = modelTable;
        IWizardContainer container = this.getContainer();
        if (container != null) {
            container.updateButtons();
        }
    }

    private void addFilter() {
        this.fFilter = new AvailableFilter(this.fSelected, (ILabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fAvailableViewer.addFilter((ViewerFilter)this.fFilter);
        this.fFilterJob = new WorkbenchJob("FilterJob"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                InternationalizeWizardPluginPage.this.handleFilter();
                return Status.OK_STATUS;
            }
        };
        this.fFilterJob.setSystem(true);
    }

    private void handleFilter() {
        boolean changed;
        String newFilter;
        if (this.fFilterText == null || (newFilter = this.fFilterText.getText().trim()).length() == 0) {
            newFilter = "*";
        }
        if (changed = this.fFilter.setPattern(newFilter)) {
            this.fAvailableViewer.getTable().setRedraw(false);
            this.fAvailableViewer.refresh();
            this.fAvailableViewer.getTable().setRedraw(true);
            this.updateButtonEnablement(false, false);
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 20;
        container.setLayout((Layout)layout);
        this.createScrollArea(container);
        this.createAvailableList(container).setLayoutData((Object)new GridData(1808));
        this.createButtonArea(container);
        this.createInternationalizeList(container).setLayoutData((Object)new GridData(1808));
        this.updateCount();
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        Composite comp = new Composite(container, 0);
        comp.setLayoutData((Object)data);
        GridLayout fl = new GridLayout(2, false);
        comp.setLayout((Layout)fl);
        IDialogSettings settings = this.getDialogSettings();
        String template = settings.get(TEMPLATE);
        Label label = new Label(comp, 0);
        label.setText(PDEUIMessages.InternationalizeWizard_PluginPage_templateLabel);
        this.fTemplateText = new Text(comp, 2048);
        this.fTemplateText.setLayoutData((Object)new GridData(768));
        this.fTemplateText.setText(template != null ? template : "${plugin_name}.nl1");
        this.fTemplateText.addModifyListener(e -> this.pageChanged());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.overwriteOption = new Button(comp, 32);
        this.overwriteOption.setText(PDEUIMessages.InternationalizeWizard_PluginPage_overwriteWithoutAsking);
        this.overwriteOption.setSelection(settings.getBoolean(OVERWRITE));
        this.overwriteOption.setLayoutData((Object)gd);
        this.individualFragments = new Button(comp, 32);
        this.individualFragments.setText(PDEUIMessages.InternationalizeWizard_PluginPage_individualFragments);
        this.individualFragments.setSelection(settings.getBoolean(CREATE_INDIVIDUAL_FRAGMENTS));
        this.individualFragments.setLayoutData((Object)gd);
        this.addViewerListeners();
        this.addFilter();
        this.initialize();
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    private Composite createAvailableList(Composite parent) {
        Composite container = this.createViewerContainer(parent, PDEUIMessages.InternationalizeWizard_PluginPage_availableList);
        this.fAvailableViewer = InternationalizeWizardPluginPage.createTableViewer(container, (IContentProvider)new ContentProvider(), PDECore.getDefault().getModelManager());
        return container;
    }

    protected Composite createInternationalizeList(Composite parent) {
        Composite container = this.createViewerContainer(parent, PDEUIMessages.InternationalizeWizard_PluginPage_internationalizeList);
        this.fSelectedViewer = InternationalizeWizardPluginPage.createTableViewer(container, (IContentProvider)new SelectedContentProvider(), PDECore.getDefault().getModelManager().getExternalModelManager());
        return container;
    }

    private Composite createViewerContainer(Composite parent, String message) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText(message);
        return container;
    }

    private static TableViewer createTableViewer(Composite container, IContentProvider provider, Object manager) {
        Table table = new Table(container, 2562);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 225;
        table.setLayoutData((Object)gd);
        TableViewer viewer = new TableViewer(table);
        viewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        viewer.setContentProvider(provider);
        viewer.setInput(manager);
        viewer.setComparator(ListUtil.PLUGIN_COMPARATOR);
        return viewer;
    }

    protected boolean isRefreshNeeded() {
        if (this.fRefreshNeeded) {
            this.fRefreshNeeded = false;
            return true;
        }
        return false;
    }

    private IPluginModelBase findModel(String id) {
        IPluginModelBase[] iPluginModelBaseArray = this.fModels;
        int n = this.fModels.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            String modelId = model.getPluginBase().getId();
            if (modelId != null && modelId.equals(id)) {
                return model;
            }
            ++n2;
        }
        return null;
    }

    private IFragmentModel[] findFragments(IPlugin plugin) {
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        IPluginModelBase[] iPluginModelBaseArray = this.fModels;
        int n = this.fModels.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            if (model instanceof IFragmentModel) {
                IFragment fragment = ((IFragmentModel)model).getFragment();
                if (plugin.getId().equalsIgnoreCase(fragment.getPluginId())) {
                    result.add(model);
                }
            }
            ++n2;
        }
        return result.toArray(new IFragmentModel[result.size()]);
    }

    protected void addPluginAndDependencies(IPluginModelBase model, ArrayList<IPluginModelBase> selected, boolean addFragments) {
        boolean containsVariable = false;
        if (!selected.contains(model)) {
            selected.add(model);
            boolean hasextensibleAPI = ClasspathUtilCore.hasExtensibleAPI((IPluginModelBase)model);
            if (!addFragments && !hasextensibleAPI && model instanceof IPluginModel) {
                IPluginLibrary[] libraries;
                IPluginLibrary[] iPluginLibraryArray = libraries = model.getPluginBase().getLibraries();
                int n = libraries.length;
                int n2 = 0;
                while (n2 < n) {
                    IPluginLibrary library = iPluginLibraryArray[n2];
                    if (ClasspathUtilCore.containsVariables((String)library.getName())) {
                        containsVariable = true;
                        break;
                    }
                    ++n2;
                }
            }
            this.addDependencies(model, selected, addFragments || containsVariable || hasextensibleAPI);
        }
    }

    protected void addDependencies(IPluginModelBase model, ArrayList<IPluginModelBase> selected, boolean addFragments) {
        int n;
        IPluginImport[] required = model.getPluginBase().getImports();
        if (required.length > 0) {
            IPluginImport[] iPluginImportArray = required;
            n = required.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginImport pluginImport = iPluginImportArray[n2];
                IPluginModelBase found = this.findModel(pluginImport.getId());
                if (found != null) {
                    this.addPluginAndDependencies(found, selected, addFragments);
                }
                ++n2;
            }
        }
        if (addFragments) {
            if (model instanceof IPluginModel) {
                IFragmentModel[] fragments;
                IFragmentModel[] iFragmentModelArray = fragments = this.findFragments(((IPluginModel)model).getPlugin());
                int n3 = fragments.length;
                n = 0;
                while (n < n3) {
                    IFragmentModel fragment = iFragmentModelArray[n];
                    this.addPluginAndDependencies((IPluginModelBase)fragment, selected, addFragments);
                    ++n;
                }
            } else {
                IFragment fragment = ((IFragmentModel)model).getFragment();
                IPluginModelBase found = this.findModel(fragment.getPluginId());
                if (found != null) {
                    this.addPluginAndDependencies(found, selected, addFragments);
                }
            }
        }
    }

    public List<IPluginModelBase> getModelsToInternationalize() {
        return InternationalizeWizardPluginPage.getModels(this.fSelectedViewer, IPluginModelBase.class);
    }

    public void storeSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(OVERWRITE, this.overwriteWithoutAsking());
        settings.put(TEMPLATE, this.getTemplate());
        settings.put(CREATE_INDIVIDUAL_FRAGMENTS, this.createIndividualFragments());
    }

    public boolean createIndividualFragments() {
        return this.individualFragments.getSelection();
    }

    public void modelsChanged(IModelProviderEvent event) {
        this.fRefreshNeeded = true;
    }

    private void initialize() {
        this.updateButtonEnablement(true, true);
        this.setPageComplete(false);
    }

    private void addViewerListeners() {
        this.fAvailableViewer.addDoubleClickListener(event -> this.handleAdd());
        this.fSelectedViewer.addDoubleClickListener(event -> this.handleRemove());
        this.fAvailableViewer.addSelectionChangedListener(event -> {
            if (!this.fBlockSelectionListeners) {
                this.updateSelectionBasedEnablement(event.getSelection(), true);
            }
        });
        this.fSelectedViewer.addSelectionChangedListener(event -> {
            if (!this.fBlockSelectionListeners) {
                this.updateSelectionBasedEnablement(event.getSelection(), false);
            }
        });
        this.fFilterText.addModifyListener(e -> {
            this.fFilterJob.cancel();
            this.fFilterJob.schedule(200L);
        });
    }

    private Composite createButtonArea(Composite parent) {
        ScrolledComposite comp = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayoutData((Object)new GridData(1040));
        Composite container = new Composite((Composite)comp, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginTop = 50;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1040);
        gd.verticalIndent = 15;
        container.setLayoutData((Object)gd);
        this.fAddButton = new Button(container, 8);
        this.fAddButton.setText(PDEUIMessages.ImportWizard_DetailedPage_add);
        this.fAddButton.setLayoutData((Object)new GridData(768));
        this.fAddButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleAdd()));
        SWTUtil.setButtonDimensionHint(this.fAddButton);
        this.fAddAllButton = new Button(container, 8);
        this.fAddAllButton.setText(PDEUIMessages.ImportWizard_DetailedPage_addAll);
        this.fAddAllButton.setLayoutData((Object)new GridData(768));
        this.fAddAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleAddAll()));
        SWTUtil.setButtonDimensionHint(this.fAddAllButton);
        this.fRemoveButton = new Button(container, 8);
        this.fRemoveButton.setText(PDEUIMessages.ImportWizard_DetailedPage_remove);
        this.fRemoveButton.setLayoutData((Object)new GridData(768));
        this.fRemoveButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleRemove()));
        SWTUtil.setButtonDimensionHint(this.fRemoveButton);
        this.fRemoveAllButton = new Button(container, 8);
        this.fRemoveAllButton.setText(PDEUIMessages.ImportWizard_DetailedPage_removeAll);
        this.fRemoveAllButton.setLayoutData((Object)new GridData(768));
        this.fRemoveAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleRemoveAll()));
        SWTUtil.setButtonDimensionHint(this.fRemoveAllButton);
        this.fCountLabel = new Label(container, 0);
        this.fCountLabel.setLayoutData((Object)new GridData(64));
        comp.setContent((Control)container);
        comp.setMinHeight(250);
        comp.setExpandHorizontal(true);
        comp.setExpandVertical(true);
        return container;
    }

    private Composite createScrollArea(Composite parent) {
        Group container = this.createFilterContainer(parent, PDEUIMessages.InternationalizeWizard_PluginPage_filter, PDEUIMessages.ImportWizard_DetailedPage_search);
        this.fFilterText = this.createFilterText((Composite)container, "");
        return container;
    }

    protected void refreshPage() {
        this.fSelectedViewer.getTable().removeAll();
        this.fSelected.clear();
        this.fAvailableViewer.refresh();
        this.pageChanged();
    }

    protected void pageChanged() {
        this.pageChanged(false, false);
    }

    protected void pageChanged(boolean doAddEnablement, boolean doRemoveEnablement) {
        if (this.fTemplateText.getText().length() == 0) {
            this.setErrorMessage(PDEUIMessages.InternationalizeWizard_PluginPage_templateError);
        } else if (this.fSelectedViewer.getTable().getItemCount() == 0) {
            this.setErrorMessage(PDEUIMessages.InternationalizeWizard_PluginPage_selectionError);
        } else {
            this.setErrorMessage(null);
        }
        this.updateCount();
        this.updateButtonEnablement(doAddEnablement, doRemoveEnablement);
        this.setPageComplete(this.fSelectedViewer.getTable().getItemCount() > 0);
    }

    private void updateCount() {
        this.fCountLabel.setText(NLS.bind((String)PDEUIMessages.ImportWizard_DetailedPage_count, (Object)Integer.toString(this.fSelectedViewer.getTable().getItemCount()), (Object)Integer.toString(this.fAvailableViewer.getTable().getItemCount() + this.fSelectedViewer.getTable().getItemCount())));
        this.fCountLabel.getParent().layout();
    }

    private void updateButtonEnablement(boolean doAddEnablement, boolean doRemoveEnablement) {
        int availableCount = this.fAvailableViewer.getTable().getItemCount();
        int importCount = this.fSelectedViewer.getTable().getItemCount();
        if (doAddEnablement) {
            this.updateSelectionBasedEnablement((ISelection)this.fAvailableViewer.getStructuredSelection(), true);
        }
        if (doRemoveEnablement) {
            this.updateSelectionBasedEnablement((ISelection)this.fSelectedViewer.getStructuredSelection(), false);
        }
        this.fAddAllButton.setEnabled(availableCount > 0);
        this.fRemoveAllButton.setEnabled(importCount > 0);
    }

    private void updateSelectionBasedEnablement(ISelection theSelection, boolean available) {
        if (available) {
            this.fAddButton.setEnabled(!theSelection.isEmpty());
        } else {
            this.fRemoveButton.setEnabled(!theSelection.isEmpty());
        }
    }

    private void handleAdd() {
        Iterator<IPluginModelBase> selectedPlugins = InternationalizeWizardPluginPage.getSelectedModels(this.fAvailableViewer, IPluginModelBase.class);
        if (selectedPlugins.hasNext()) {
            Table table = this.fAvailableViewer.getTable();
            int index = table.getSelectionIndices()[0];
            this.setBlockSelectionListeners(true);
            this.setRedraw(false);
            selectedPlugins.forEachRemaining(this::doAdd);
            this.setRedraw(true);
            this.setBlockSelectionListeners(false);
            table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
            this.pageChanged(true, false);
        }
    }

    private void handleAddAll() {
        List<IPluginModelBase> data = InternationalizeWizardPluginPage.getModels(this.fAvailableViewer, IPluginModelBase.class);
        if (!data.isEmpty()) {
            this.setBlockSelectionListeners(true);
            this.setRedraw(false);
            for (IPluginModelBase dataObject : data) {
                this.doAdd(dataObject);
            }
            this.setRedraw(true);
            this.setBlockSelectionListeners(false);
            this.pageChanged(true, false);
        }
    }

    private void handleRemove() {
        Iterator<IPluginModelBase> selectedPlugins = InternationalizeWizardPluginPage.getSelectedModels(this.fSelectedViewer, IPluginModelBase.class);
        if (selectedPlugins.hasNext()) {
            Table table = this.fSelectedViewer.getTable();
            int index = table.getSelectionIndices()[0];
            this.setBlockSelectionListeners(true);
            this.setRedraw(false);
            selectedPlugins.forEachRemaining(this::doRemove);
            this.setRedraw(true);
            this.setBlockSelectionListeners(false);
            table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
            this.pageChanged(false, true);
        }
    }

    private void doAdd(IPluginModelBase o) {
        this.fInternationalizeModelTable.removeModel(o);
        this.fSelectedViewer.add((Object)o);
        this.fAvailableViewer.remove((Object)o);
        this.fSelected.add(o);
    }

    private void doRemove(IPluginModelBase o) {
        this.fInternationalizeModelTable.addModel(o);
        this.fSelected.remove(o);
        this.fSelectedViewer.remove((Object)o);
        this.fAvailableViewer.add((Object)o);
    }

    private void setRedraw(boolean redraw) {
        this.fAvailableViewer.getTable().setRedraw(redraw);
        this.fSelectedViewer.getTable().setRedraw(redraw);
    }

    private void handleRemoveAll() {
        List<IPluginModelBase> data = InternationalizeWizardPluginPage.getModels(this.fSelectedViewer, IPluginModelBase.class);
        if (!data.isEmpty()) {
            this.setBlockSelectionListeners(true);
            this.setRedraw(false);
            for (IPluginModelBase dataObject : data) {
                this.doRemove(dataObject);
            }
            this.setRedraw(true);
            this.setBlockSelectionListeners(false);
            this.pageChanged(false, true);
        }
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        PDECore.getDefault().getModelManager().getExternalModelManager().removeModelProviderListener((IModelProviderListener)this);
    }

    private void setBlockSelectionListeners(boolean blockSelectionListeners) {
        this.fBlockSelectionListeners = blockSelectionListeners;
    }

    public boolean isCurrentPage() {
        return super.isCurrentPage();
    }

    public boolean canFlipToNextPage() {
        return this.fSelectedViewer.getTable().getItems().length > 0 && this.getTemplate().length() > 0;
    }

    public String getTemplate() {
        return this.fTemplateText.getText();
    }

    public boolean overwriteWithoutAsking() {
        return this.overwriteOption.getSelection();
    }

    private class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return InternationalizeWizardPluginPage.this.fInternationalizeModelTable.getModels();
        }
    }

    private class SelectedContentProvider
    implements IStructuredContentProvider {
        private SelectedContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return InternationalizeWizardPluginPage.this.fInternationalizeModelTable.getPreSelected();
        }
    }
}

