/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.refactoring.DeleteBreakpointChange;
import org.eclipse.jdt.internal.debug.core.refactoring.MethodBreakpointChange;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.osgi.util.NLS;

public class MethodBreakpointTypeChange
extends MethodBreakpointChange {
    private final IType fDestType;

    public MethodBreakpointTypeChange(IJavaMethodBreakpoint breakpoint, IType destType) throws CoreException {
        super(breakpoint);
        this.fDestType = destType;
    }

    public String getName() {
        String msg = NLS.bind((String)RefactoringMessages.MethodBreakpointTypeChange_1, (Object)this.getBreakpointLabel((IBreakpoint)this.getOriginalBreakpoint()));
        if (!"".equals(this.fDestType.getElementName())) {
            msg = NLS.bind((String)RefactoringMessages.MethodBreakpointTypeChange_0, (Object)this.getBreakpointLabel((IBreakpoint)this.getOriginalBreakpoint()), (Object)this.fDestType.getElementName());
        }
        return msg;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        String[] parameterTypes = Signature.getParameterTypes((String)this.getSignature());
        int i = 0;
        while (i < parameterTypes.length) {
            parameterTypes[i] = parameterTypes[i].replace('/', '.');
            ++i;
        }
        IMethod destMethod = this.fDestType.getMethod(this.getMethodName(), parameterTypes);
        if (!destMethod.exists()) {
            IMethod[] methods = this.fDestType.getMethods();
            int i2 = 0;
            while (i2 < methods.length) {
                if (methods[i2].isSimilar(destMethod)) {
                    destMethod = methods[i2];
                    break;
                }
                ++i2;
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        BreakpointUtils.addJavaBreakpointAttributes(map, (IJavaElement)destMethod);
        map.put("workingset_name", this.getOriginalWorkingSets());
        IResource resource = BreakpointUtils.getBreakpointResource((IMember)destMethod);
        int[] range = this.getNewLineNumberAndRange((IMember)destMethod);
        IJavaMethodBreakpoint breakpoint = JDIDebugModel.createMethodBreakpoint((IResource)resource, (String)this.fDestType.getFullyQualifiedName(), (String)this.getMethodName(), (String)this.getSignature(), (boolean)this.isEntry(), (boolean)this.isExit(), (boolean)this.isNativeOnly(), (int)-1, (int)range[1], (int)range[2], (int)this.getHitCount(), (boolean)true, map);
        this.apply(breakpoint);
        this.getOriginalBreakpoint().delete();
        return new DeleteBreakpointChange((IJavaBreakpoint)breakpoint);
    }
}

