/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.CommonDirectivesSection;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDDirectivesSchemaLocationUpdater;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.impl.XSDIncludeImpl;
import org.eclipse.xsd.impl.XSDRedefineImpl;
import org.w3c.dom.Element;

public class SchemaLocationSection
extends CommonDirectivesSection {
    IWorkbenchPart part;

    public void createContents(Composite parent) {
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.numColumns = 3;
        this.composite.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        CLabel schemaLocationLabel = this.getWidgetFactory().createCLabel(this.composite, XSDEditorPlugin.getXSDString("_UI_LABEL_SCHEMA_LOCATION"));
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        schemaLocationLabel.setLayoutData((Object)data);
        this.schemaLocationText = this.getWidgetFactory().createText(this.composite, "", 0);
        this.schemaLocationText.setEditable(true);
        this.applyAllListeners((Control)this.schemaLocationText);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.schemaLocationText.setLayoutData((Object)data);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.schemaLocationText, "org.eclipse.wst.xsd.ui.xsdup0360");
        this.wizardButton = this.getWidgetFactory().createButton(this.composite, "", 0);
        this.wizardButton.setImage(XSDEditorPlugin.getXSDImage("icons/browsebutton.gif"));
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        this.wizardButton.setLayoutData((Object)data);
        this.wizardButton.addSelectionListener((SelectionListener)this);
        this.errorText = new StyledText(this.composite, 0x800000);
        this.errorText.setEditable(false);
        this.errorText.setEnabled(false);
        this.errorText.setText("");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 3;
        data.grabExcessHorizontalSpace = true;
        this.errorText.setLayoutData((Object)data);
    }

    public void doWidgetSelected(SelectionEvent event) {
        if (event.widget == this.wizardButton) {
            XSDDirectivesSchemaLocationUpdater.updateSchemaLocation(this.xsdSchema, this.input, true);
            this.refresh();
        }
    }

    public void refresh() {
        this.setListenerEnabled(false);
        Element element = null;
        if (this.input instanceof XSDInclude) {
            element = ((XSDIncludeImpl)this.input).getElement();
        } else if (this.input instanceof XSDRedefine) {
            element = ((XSDRedefineImpl)this.input).getElement();
        }
        if (element != null) {
            String location = "";
            location = element.getAttribute("schemaLocation");
            if (location == null) {
                location = "";
            }
            this.schemaLocationText.setText(location);
        }
        this.setListenerEnabled(true);
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }
}

