/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.parser.antlr;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.CharacterRange;
import org.eclipse.xtext.EOF;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.NegatedToken;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.UntilToken;
import org.eclipse.xtext.Wildcard;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.XtextSwitch;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrGrammarGenUtil;

public class TerminalRuleToLexerBody
extends XtextSwitch<String> {
    private final StringBuilder result = new StringBuilder();

    private TerminalRuleToLexerBody() {
    }

    public static String toLexerBody(TerminalRule rule) {
        return new TerminalRuleToLexerBody().print(rule);
    }

    public String print(TerminalRule rule) {
        this.doSwitch((EObject)rule.getAlternatives());
        return this.result.toString();
    }

    public String caseAlternatives(Alternatives object) {
        this.result.append('(');
        boolean first = true;
        for (AbstractElement elem : object.getElements()) {
            if (!first) {
                this.result.append('|');
            }
            first = false;
            this.doSwitch((EObject)elem);
        }
        this.result.append(')').append(Strings.emptyIfNull((String)object.getCardinality()));
        return "";
    }

    public String caseCharacterRange(CharacterRange object) {
        if (!Strings.isEmpty((String)object.getCardinality())) {
            this.result.append('(');
        }
        this.doSwitch((EObject)object.getLeft());
        this.result.append("..");
        this.doSwitch((EObject)object.getRight());
        if (!Strings.isEmpty((String)object.getCardinality())) {
            this.result.append(')');
            this.result.append(Strings.emptyIfNull((String)object.getCardinality()));
        }
        return "";
    }

    public String defaultCase(EObject object) {
        throw new IllegalArgumentException(object.eClass().getName() + " is not a valid argument.");
    }

    public String caseGroup(Group object) {
        if (!Strings.isEmpty((String)object.getCardinality())) {
            this.result.append('(');
        }
        boolean first = true;
        for (AbstractElement elem : object.getElements()) {
            if (!first) {
                this.result.append(' ');
            }
            first = false;
            this.doSwitch((EObject)elem);
        }
        if (!Strings.isEmpty((String)object.getCardinality())) {
            this.result.append(')');
        }
        this.result.append(Strings.emptyIfNull((String)object.getCardinality()));
        return "";
    }

    public String caseKeyword(Keyword object) {
        this.result.append("'");
        String value = this.toLexerString(object.getValue());
        this.result.append(value).append("'");
        this.result.append(Strings.emptyIfNull((String)object.getCardinality()));
        return "";
    }

    private String toLexerString(String theString) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                } else {
                    outBuffer.append(aChar);
                }
            } else {
                switch (aChar) {
                    case ' ': {
                        outBuffer.append(' ');
                        break;
                    }
                    case '\t': {
                        outBuffer.append('\\');
                        outBuffer.append('t');
                        break;
                    }
                    case '\n': {
                        outBuffer.append('\\');
                        outBuffer.append('n');
                        break;
                    }
                    case '\r': {
                        outBuffer.append('\\');
                        outBuffer.append('r');
                        break;
                    }
                    case '\f': {
                        outBuffer.append('\\');
                        outBuffer.append('f');
                        break;
                    }
                    case '\b': {
                        outBuffer.append('\\');
                        outBuffer.append('b');
                        break;
                    }
                    case '\'': {
                        outBuffer.append('\\');
                        outBuffer.append('\'');
                        break;
                    }
                    default: {
                        if (aChar < ' ' || aChar > '~') {
                            outBuffer.append('\\');
                            outBuffer.append('u');
                            outBuffer.append(Strings.toHex((int)(aChar >> 12 & 0xF)));
                            outBuffer.append(Strings.toHex((int)(aChar >> 8 & 0xF)));
                            outBuffer.append(Strings.toHex((int)(aChar >> 4 & 0xF)));
                            outBuffer.append(Strings.toHex((int)(aChar & 0xF)));
                            break;
                        }
                        outBuffer.append(aChar);
                    }
                }
            }
            ++x;
        }
        return outBuffer.toString();
    }

    public String caseWildcard(Wildcard object) {
        this.result.append('.');
        this.result.append(Strings.emptyIfNull((String)object.getCardinality()));
        return "";
    }

    public String caseEOF(EOF object) {
        this.result.append("EOF");
        this.result.append(Strings.emptyIfNull((String)object.getCardinality()));
        return "";
    }

    public String caseTerminalRule(TerminalRule object) {
        this.result.append(AntlrGrammarGenUtil.getRuleName((AbstractRule)object));
        return "";
    }

    public String caseParserRule(ParserRule object) {
        throw new IllegalStateException("Cannot call parser rules that are not terminal rules.");
    }

    public String caseRuleCall(RuleCall object) {
        this.doSwitch((EObject)object.getRule());
        this.result.append(Strings.emptyIfNull((String)object.getCardinality()));
        return "";
    }

    public String caseNegatedToken(NegatedToken object) {
        this.result.append("~(");
        this.doSwitch((EObject)object.getTerminal());
        this.result.append(")").append(Strings.emptyIfNull((String)object.getCardinality()));
        return "";
    }

    public String caseUntilToken(UntilToken object) {
        this.result.append("( options {greedy=false;} : . )*");
        this.doSwitch((EObject)object.getTerminal());
        return "";
    }
}

