/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

abstract class AbstractToggleVariableHandler
extends AbstractHandler
implements IElementUpdater {
    AbstractToggleVariableHandler() {
    }

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        this.toggleVariableDisplay();
        this.updateDebugTargets();
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ICommandService service = (ICommandService)window.getService(ICommandService.class);
        service.refreshElements(event.getCommand().getId(), null);
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        element.setChecked(this.isVariableDisplayEnabled());
    }

    protected abstract String getModelId();

    protected abstract IPreferenceStore getPreferenceStore();

    protected abstract String getVariableDisplayPreferenceKey();

    protected abstract void toggleVariableDisplay(IScriptDebugTarget var1, boolean var2);

    private boolean isVariableDisplayEnabled() {
        return this.getPreferenceStore().getBoolean(this.getVariableDisplayPreferenceKey());
    }

    private boolean matchesModelId(IScriptDebugTarget target) {
        return this.getModelId().equals(target.getModelIdentifier());
    }

    private void toggleVariableDisplay() {
        String key;
        IPreferenceStore store;
        boolean value = (store = this.getPreferenceStore()).getBoolean(key = this.getVariableDisplayPreferenceKey());
        store.setValue(key, !value);
    }

    private void updateDebugTargets() {
        IDebugTarget[] targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        int i = 0;
        while (i < targets.length) {
            IScriptDebugTarget target;
            if (targets[i] instanceof IScriptDebugTarget && !(target = (IScriptDebugTarget)targets[i]).isTerminated() && this.matchesModelId(target)) {
                this.toggleVariableDisplay(target, this.isVariableDisplayEnabled());
            }
            ++i;
        }
    }
}

