/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.ModelOperation;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.SourceModule;

public abstract class MultiOperation
extends ModelOperation {
    protected Map insertBeforeElements = new HashMap(1);
    protected Map newParents;
    protected Map renamings;
    protected String[] renamingsList = null;

    protected MultiOperation(IModelElement[] elementsToProcess, boolean force) {
        super(elementsToProcess, force);
    }

    protected MultiOperation(IModelElement[] elementsToProcess, IModelElement[] parentElements, boolean force) {
        super(elementsToProcess, parentElements, force);
        this.newParents = new HashMap(elementsToProcess.length);
        if (elementsToProcess.length == parentElements.length) {
            int i = 0;
            while (i < elementsToProcess.length) {
                this.newParents.put(elementsToProcess[i], parentElements[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < elementsToProcess.length) {
                this.newParents.put(elementsToProcess[i], parentElements[0]);
                ++i;
            }
        }
    }

    protected void error(int code, IModelElement element) throws ModelException {
        throw new ModelException(new ModelStatus(code, element));
    }

    protected void executeOperation() throws ModelException {
        this.processElements();
    }

    protected IModelElement getDestinationParent(IModelElement child) {
        return (IModelElement)this.newParents.get(child);
    }

    protected abstract String getMainTaskName();

    protected String getNewNameFor(IModelElement element) throws ModelException {
        String newName = null;
        if (this.renamings != null) {
            newName = (String)this.renamings.get(element);
        }
        if (newName == null && element instanceof IMethod && ((IMethod)element).isConstructor()) {
            newName = this.getDestinationParent(element).getElementName();
        }
        return newName;
    }

    private void initializeRenamings() {
        if (this.renamingsList != null && this.renamingsList.length == this.elementsToProcess.length) {
            this.renamings = new HashMap(this.renamingsList.length);
            int i = 0;
            while (i < this.renamingsList.length) {
                if (this.renamingsList[i] != null) {
                    this.renamings.put(this.elementsToProcess[i], this.renamingsList[i]);
                }
                ++i;
            }
        }
    }

    protected boolean isMove() {
        return false;
    }

    protected boolean isRename() {
        return false;
    }

    protected abstract void processElement(IModelElement var1) throws ModelException;

    protected void processElements() throws ModelException {
        this.beginTask(this.getMainTaskName(), this.elementsToProcess.length);
        IModelStatus[] errors = new IModelStatus[3];
        int errorsCounter = 0;
        int i = 0;
        while (i < this.elementsToProcess.length) {
            block10: {
                try {
                    try {
                        this.verify(this.elementsToProcess[i]);
                        this.processElement(this.elementsToProcess[i]);
                    }
                    catch (ModelException jme) {
                        if (errorsCounter == errors.length) {
                            IModelStatus[] iModelStatusArray = errors;
                            errors = new IModelStatus[errorsCounter * 2];
                            System.arraycopy(iModelStatusArray, 0, errors, 0, errorsCounter);
                        }
                        errors[errorsCounter++] = jme.getModelStatus();
                        this.worked(1);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    this.worked(1);
                    throw throwable;
                }
                this.worked(1);
            }
            ++i;
        }
        this.done();
        if (errorsCounter == 1) {
            throw new ModelException(errors[0]);
        }
        if (errorsCounter > 1) {
            if (errorsCounter != errors.length) {
                IModelStatus[] iModelStatusArray = errors;
                errors = new IModelStatus[errorsCounter];
                System.arraycopy(iModelStatusArray, 0, errors, 0, errorsCounter);
            }
            throw new ModelException(ModelStatus.newMultiStatus(errors));
        }
    }

    public void setInsertBefore(IModelElement modifiedElement, IModelElement newSibling) {
        this.insertBeforeElements.put(modifiedElement, newSibling);
    }

    public void setRenamings(String[] renamingsList) {
        this.renamingsList = renamingsList;
        this.initializeRenamings();
    }

    protected abstract void verify(IModelElement var1) throws ModelException;

    protected void verifyDestination(IModelElement element, IModelElement destination) throws ModelException {
        if (destination == null || !destination.exists()) {
            this.error(969, destination);
        }
        int destType = destination.getElementType();
        switch (element.getElementType()) {
            case 7: {
                if (destType == 5 || destType == 7) break;
                this.error(978, element);
                break;
            }
            case 8: 
            case 9: {
                if (destType == 7) break;
                this.error(978, element);
                break;
            }
            case 5: {
                if (destType != 4) {
                    this.error(978, element);
                    break;
                }
                if (element instanceof SourceModule) {
                    SourceModule cu = (SourceModule)element;
                    if (!this.isMove() || !cu.isWorkingCopy() || cu.isPrimary()) break;
                    this.error(967, element);
                    break;
                }
                if (!(element instanceof ExternalSourceModule)) break;
                ExternalSourceModule cu = (ExternalSourceModule)element;
                if (!this.isMove() || !cu.isWorkingCopy() || cu.isPrimary()) break;
                this.error(967, element);
                break;
            }
            case 4: {
                IScriptFolder fragment = (IScriptFolder)element;
                IModelElement parent = fragment.getParent();
                if (parent.isReadOnly()) {
                    this.error(976, element);
                    break;
                }
                if (destType == 3) break;
                this.error(978, element);
                break;
            }
            default: {
                this.error(967, element);
            }
        }
    }

    protected void verifyRenaming(IModelElement element) throws ModelException {
        String newName = this.getNewNameFor(element);
        boolean isValid = true;
        switch (element.getElementType()) {
            case 4: {
                if (DLTKCore.DEBUG) {
                    System.err.println("Need validation of script folder name");
                }
                isValid = true;
                break;
            }
            case 5: {
                if (DLTKCore.DEBUG) {
                    System.err.println("Need validation of source module name");
                }
                isValid = true;
                break;
            }
            default: {
                if (DLTKCore.DEBUG) {
                    System.err.println("Need validation of name");
                }
                isValid = true;
            }
        }
        if (!isValid) {
            throw new ModelException(new ModelStatus(983, element, newName));
        }
    }

    protected void verifySibling(IModelElement element, IModelElement destination) throws ModelException {
        IModelElement insertBeforeElement = (IModelElement)this.insertBeforeElements.get(element);
        if (!(insertBeforeElement == null || insertBeforeElement.exists() && insertBeforeElement.getParent().equals(destination))) {
            this.error(993, insertBeforeElement);
        }
    }
}

