/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelElementDelta;
import org.eclipse.dltk.internal.core.ModelOperation;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.util.Messages;
import org.eclipse.dltk.internal.core.util.Util;

public class CreateScriptFolderOperation
extends ModelOperation {
    protected IPath pkgName;

    public CreateScriptFolderOperation(IProjectFragment parentElement, String packageName, boolean force) {
        super(null, new IModelElement[]{parentElement}, force);
        this.pkgName = packageName == null ? null : new Path(packageName);
    }

    protected void executeOperation() throws ModelException {
        ModelElementDelta delta = null;
        IProjectFragment root = (IProjectFragment)this.getParentElement();
        this.beginTask(Messages.operation_createScriptFolderProgress, this.pkgName.segmentCount());
        IContainer parentFolder = (IContainer)root.getResource();
        Path sideEffectPackageName = Path.EMPTY;
        ArrayList<IScriptFolder> results = new ArrayList<IScriptFolder>(this.pkgName.segmentCount());
        int i = 0;
        while (i < this.pkgName.segmentCount()) {
            String subFolderName = this.pkgName.segment(i);
            sideEffectPackageName = sideEffectPackageName.append(subFolderName);
            IResource subFolder = parentFolder.findMember(subFolderName);
            if (subFolder == null) {
                this.createFolder(parentFolder, subFolderName, this.force);
                parentFolder = parentFolder.getFolder((IPath)new Path(subFolderName));
                IScriptFolder addedFrag = root.getScriptFolder((IPath)sideEffectPackageName);
                if (!Util.isExcluded((IResource)parentFolder, root)) {
                    if (delta == null) {
                        delta = this.newModelElementDelta();
                    }
                    delta.added(addedFrag);
                }
                results.add(addedFrag);
            } else {
                parentFolder = (IContainer)subFolder;
            }
            this.worked(1);
            ++i;
        }
        if (results.size() > 0) {
            this.resultElements = new IModelElement[results.size()];
            results.toArray(this.resultElements);
            if (delta != null) {
                this.addDelta(delta);
            }
        }
        this.done();
    }

    public IModelStatus verify() {
        if (this.getParentElement() == null) {
            return new ModelStatus(968);
        }
        IPath packageName = this.pkgName == null ? null : this.pkgName.append(".");
        String packageNameValue = null;
        if (packageName != null) {
            packageNameValue = packageName.toOSString();
        }
        if (this.pkgName == null || this.pkgName.segmentCount() > 0 && !Util.isValidFolderNameForPackage(packageName.toString())) {
            return new ModelStatus(983, packageNameValue);
        }
        IProjectFragment root = (IProjectFragment)this.getParentElement();
        if (root.isReadOnly()) {
            return new ModelStatus(976, root);
        }
        IContainer parentFolder = (IContainer)root.getResource();
        int i = 0;
        while (i < this.pkgName.segmentCount()) {
            IResource subFolder = parentFolder.findMember(this.pkgName.segment(i));
            if (subFolder != null) {
                if (subFolder.getType() != 2) {
                    return new ModelStatus(977, Messages.bind(Messages.status_nameCollision, subFolder.getFullPath().toString()));
                }
                parentFolder = (IContainer)subFolder;
            }
            ++i;
        }
        return ModelStatus.VERIFIED_OK;
    }
}

