/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.templates;

import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.ui.templates.CodeTemplateSourceViewerConfigurationAdapter;
import org.eclipse.dltk.ui.templates.ScriptTemplateAccess;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.texteditor.templates.TemplatePreferencePage;

public abstract class ScriptTemplatePreferencePage
extends TemplatePreferencePage
implements IWorkbenchPreferencePage {
    public ScriptTemplatePreferencePage() {
        this.setPreferenceStore();
        ScriptTemplateAccess tplAccess = this.getTemplateAccess();
        this.setTemplateStore(tplAccess.getTemplateStore());
        this.setContextTypeRegistry(tplAccess.getContextTypeRegistry());
    }

    protected Template editTemplate(Template template, boolean edit, boolean isNameModifiable) {
        ScriptEditTemplateDialog dialog = new ScriptEditTemplateDialog(this.getShell(), template, edit, isNameModifiable, this.getContextTypeRegistry());
        if (dialog.open() == 0) {
            return dialog.getTemplate();
        }
        return null;
    }

    protected SourceViewer createViewer(Composite parent) {
        IPreferenceStore store = this.getPreferenceStore();
        ScriptSourceViewerConfiguration configuration = this.createSourceViewerConfiguration();
        Document document = new Document();
        this.setDocumentPartitioner((IDocument)document);
        ScriptSourceViewer viewer = new ScriptSourceViewer(parent, null, null, false, 2816, store);
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.setEditable(false);
        viewer.setDocument((IDocument)document);
        Control control = viewer.getControl();
        control.setLayoutData((Object)new GridData(1296));
        return viewer;
    }

    protected void updateViewerInput() {
        IStructuredSelection selection = (IStructuredSelection)this.getTableViewer().getSelection();
        SourceViewer viewer = this.getViewer();
        if (selection.size() == 1 && selection.getFirstElement() instanceof TemplatePersistenceData) {
            TemplatePersistenceData data = (TemplatePersistenceData)selection.getFirstElement();
            Template template = data.getTemplate();
            String contextId = template.getContextTypeId();
            IDocument doc = viewer.getDocument();
            String start = null;
            start = "rdoc".equals(contextId) ? "/**" + doc.getLegalLineDelimiters()[0] : "";
            doc.set(String.valueOf(start) + template.getPattern());
            int startLen = start.length();
            viewer.setDocument(doc, startLen, doc.getLength() - startLen);
        } else {
            viewer.getDocument().set("");
        }
    }

    protected boolean isShowFormatterSetting() {
        return false;
    }

    protected abstract ScriptSourceViewerConfiguration createSourceViewerConfiguration();

    protected abstract ScriptTemplateAccess getTemplateAccess();

    protected void setDocumentPartitioner(IDocument document) {
        this.setDocumentParticioner(document);
    }

    protected void setDocumentParticioner(IDocument document) {
    }

    protected abstract void setPreferenceStore();

    protected class ScriptEditTemplateDialog
    extends TemplatePreferencePage.EditTemplateDialog {
        public ScriptEditTemplateDialog(Shell parent, Template template, boolean edit, boolean isNameModifiable, ContextTypeRegistry registry) {
            super(parent, template, edit, isNameModifiable, registry);
        }

        protected SourceViewer createViewer(Composite parent) {
            IPreferenceStore store = ScriptTemplatePreferencePage.this.getPreferenceStore();
            ScriptSourceViewer viewer = new ScriptSourceViewer(parent, null, null, false, 2816, store);
            ScriptSourceViewerConfiguration origConfig = ScriptTemplatePreferencePage.this.createSourceViewerConfiguration();
            CodeTemplateSourceViewerConfigurationAdapter configuration = new CodeTemplateSourceViewerConfigurationAdapter((SourceViewerConfiguration)origConfig, this.getTemplateProcessor());
            Document document = new Document();
            ScriptTemplatePreferencePage.this.setDocumentPartitioner((IDocument)document);
            viewer.configure(configuration);
            if (origConfig instanceof ScriptSourceViewerConfiguration) {
                String fontKey = origConfig.getFontPropertyPreferenceKey();
                viewer.getTextWidget().setFont(JFaceResources.getFont((String)fontKey));
            }
            viewer.setDocument((IDocument)document);
            return viewer;
        }
    }
}

