/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.model;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.tea.library.build.model.FeatureBuild;
import org.eclipse.tea.library.build.model.FeatureData;
import org.eclipse.tea.library.build.model.PluginBuild;
import org.eclipse.tea.library.build.model.PluginData;
import org.eclipse.tea.library.build.model.WorkspaceData;

@Creatable
public class WorkspaceBuild {
    protected final Map<String, PluginBuild> sourcePlugins = new TreeMap<String, PluginBuild>();
    protected final Map<String, FeatureBuild> features = new TreeMap<String, FeatureBuild>();
    protected final Set<String> closedOrIncomplete = new TreeSet<String>();
    private final Set<PluginBuild> hostLessFragments = new TreeSet<PluginBuild>();

    @Inject
    public WorkspaceBuild(WorkspaceData wsData) {
        for (PluginData pd : wsData.getPlugins()) {
            if (pd.hasSource() && pd.isMetadataOK()) {
                PluginBuild pb = new PluginBuild(pd);
                this.sourcePlugins.put(pb.getPluginName(), pb);
                continue;
            }
            this.closedOrIncomplete.add(pd.getBundleName());
        }
        for (FeatureData fd : wsData.getFeatures()) {
            FeatureBuild fb = new FeatureBuild(fd, this);
            this.features.put(fb.getFeatureName(), fb);
        }
        for (PluginBuild pb : this.sourcePlugins.values()) {
            pb.updateDependencies(this);
        }
    }

    public List<PluginBuild> getSourcePlugIns() {
        ArrayList<PluginBuild> result = new ArrayList<PluginBuild>(this.sourcePlugins.values());
        return result;
    }

    public List<FeatureBuild> getSourceFeatures() {
        ArrayList<FeatureBuild> result = new ArrayList<FeatureBuild>(this.features.values());
        return result;
    }

    public boolean isClosedOrIncomplete(String name) {
        return this.closedOrIncomplete.contains(name);
    }

    public FeatureBuild getFeature(String name) {
        return this.features.get(name);
    }

    public PluginBuild getSourcePlugin(String name) {
        return this.sourcePlugins.get(name);
    }

    public void addHostLessFragment(PluginBuild plugin) {
        this.hostLessFragments.add(plugin);
    }

    public Set<PluginBuild> getHostLessFragments() {
        return this.hostLessFragments;
    }
}

