/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.p2;

import java.io.File;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.jar.JarManager;
import org.eclipse.tea.library.build.jar.ZipExec;
import org.eclipse.tea.library.build.jar.ZipExecFactory;
import org.eclipse.tea.library.build.jar.ZipExecPart;
import org.eclipse.tea.library.build.util.FileUtils;

public final class UpdateSite {
    public final String guid;
    public final File directory;
    public final File zip;

    UpdateSite(File out, String guid, JarManager jarManager) {
        this.guid = guid;
        this.directory = new File(out, guid);
        FileUtils.deleteDirectory(this.directory);
        FileUtils.mkdirs(this.directory);
        String zipName = guid + "-" + jarManager.getQualifier() + ".zip";
        this.zip = new File(out, zipName);
    }

    public static void createUpdateSiteZip(File dir, File zip, ZipExecFactory zef, TaskingLog console) {
        FileUtils.delete(zip);
        console.info("Archiving update site to " + String.valueOf(zip));
        ZipExec zipExec = zef.createZipExec();
        zipExec.setZipFile(zip);
        ZipExecPart part = new ZipExecPart();
        part.sourceDirectory = dir;
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            part.relativePaths.add(file.getName());
            ++n2;
        }
        zipExec.addPart(part);
        zipExec.createZip();
    }

    public void createUpdateSiteZip(ZipExecFactory zef, TaskingLog console) {
        console.info("Archiving update site " + this.guid);
        UpdateSite.createUpdateSiteZip(this.directory, this.zip, zef, console);
    }
}

