/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.internal.config;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Properties;
import org.eclipse.tea.core.internal.TaskingConfigurationStore;
import org.eclipse.tea.core.internal.config.PropertyConversionHelper;

public class PropertyConfigurationStore
implements TaskingConfigurationStore {
    private final Properties properties = new Properties();

    public PropertyConfigurationStore(File file) throws IOException {
        if (file != null && file.exists()) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileInputStream is = new FileInputStream(file);){
                this.properties.load(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.properties.put("configurationSource", file.getAbsolutePath());
        }
    }

    @Override
    public boolean loadValue(Field property, Object target) throws IllegalAccessException {
        String value = this.properties.getProperty(TaskingConfigurationStore.getPropertyName(property));
        if (!Strings.isNullOrEmpty((String)value)) {
            property.set(target, PropertyConversionHelper.convertValue(value, property.getType()));
            return true;
        }
        return false;
    }

    public String toString() {
        return "Property file backed PreferenceStore";
    }
}

