/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.p2;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.p2.publisher.FileSetDescriptor;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.AbstractAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.actions.IFeatureRootAdvice;
import org.eclipse.tea.library.build.model.FeatureBuild;
import org.eclipse.tea.library.build.model.FeatureData;
import org.eclipse.tea.library.build.p2.TeaRootFilePathComputer;

public class TeaFeatureRootAdvice
extends AbstractAdvice
implements IFeatureRootAdvice {
    private final FeatureBuild feature;
    private final IPublisherInfo publisherInfo;
    private final Map<String, TeaRootFilePathComputer> mapping = new HashMap<String, TeaRootFilePathComputer>();

    public TeaFeatureRootAdvice(FeatureBuild feature, IPublisherInfo publisherInfo) {
        this.feature = feature;
        this.publisherInfo = publisherInfo;
    }

    public TeaRootFilePathComputer getRootFileComputer(String configSpec) {
        TeaRootFilePathComputer computer = this.mapping.get(configSpec);
        if (computer == null) {
            computer = new TeaRootFilePathComputer(configSpec);
            this.mapping.put(configSpec, computer);
        }
        return computer;
    }

    public FileSetDescriptor getDescriptor(String configSpec) {
        TeaRootFilePathComputer computer = this.getRootFileComputer(configSpec);
        return computer.getDescriptor();
    }

    public String[] getConfigurations() {
        return this.mapping.keySet().toArray(new String[this.mapping.size()]);
    }

    public boolean isApplicable(String config, boolean includeDefault, String id, Version version) {
        return !(config != null && !this.mapping.containsKey(config) || id != null && !this.feature.getFeatureName().equals(id));
    }

    public void addFiles(Map<String, Map<String, String>> configMap) throws Exception {
        for (Map.Entry<String, Map<String, String>> entry : configMap.entrySet()) {
            String config = entry.getKey();
            if (config.equals("!!COMMON!!")) {
                String[] stringArray = this.publisherInfo.getConfigurations();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String publisherConfig = stringArray[n2];
                    Map<String, String> entries = entry.getValue();
                    this.addFilesForConfig(publisherConfig, entries);
                    ++n2;
                }
                continue;
            }
            String[] splitted = config.split("\\.");
            if (splitted.length != 3) {
                throw new RuntimeException(String.valueOf(this.feature.getFeatureName()) + " - Invalid root file configuration. Expecting os.ws.arch");
            }
            config = String.valueOf(splitted[1]) + "." + splitted[0] + "." + splitted[2];
            Map<String, String> entries = entry.getValue();
            this.addFilesForConfig(config, entries);
        }
    }

    private void addFilesForConfig(String config, Map<String, String> rootMap) throws Exception {
        TeaRootFilePathComputer pathComputer = this.getRootFileComputer(config);
        Path featurePath = new Path(((FeatureData)this.feature.getData()).getBundleDir().getAbsolutePath());
        for (Map.Entry<String, String> entry : rootMap.entrySet()) {
            this.addFiles(pathComputer, featurePath.append(entry.getValue()), (IPath)new Path(entry.getKey()));
        }
    }

    private void addFiles(TeaRootFilePathComputer pathComputer, IPath sourcePath, IPath destPath) {
        File sourceFile = sourcePath.toFile();
        if (!sourceFile.exists()) {
            throw new RuntimeException(String.valueOf(this.feature.getFeatureName()) + " - Cannot find root file '" + sourceFile + "'");
        }
        if (sourceFile.isDirectory()) {
            File[] fileArray = sourceFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                Path childDestPath = new Path(destPath.toOSString());
                IPath childSourcePath = sourcePath.append(child.getName());
                if (child.isDirectory()) {
                    childDestPath = childDestPath.append(child.getName());
                }
                this.addFiles(pathComputer, childSourcePath, (IPath)childDestPath);
                ++n2;
            }
        } else {
            pathComputer.addRootfile(sourceFile, destPath);
        }
    }
}

