/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.ui.editor.tabs;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.tcf.internal.debug.ui.launch.TCFPathMapTab;
import org.eclipse.tcf.services.IPathMap;
import org.eclipse.tcf.te.launch.core.persistence.launchcontext.LaunchContextsPersistenceDelegate;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.tcf.core.interfaces.IPathMapGeneratorService;
import org.eclipse.tcf.te.tcf.launch.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.launch.ui.editor.AbstractTcfLaunchTabContainerEditorPage;
import org.eclipse.tcf.te.tcf.launch.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.ui.jface.tooltips.ClippedCellToolTip;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;

public class PathMapTab
extends TCFPathMapTab {
    private final AbstractTcfLaunchTabContainerEditorPage parentEditorPage;
    Button showAutoGeneratedRules;
    private CheckboxTableViewer fViewer;
    Point fLastClickLocation;

    public PathMapTab(AbstractTcfLaunchTabContainerEditorPage parentEditorPage) {
        this.parentEditorPage = parentEditorPage;
    }

    public final AbstractTcfLaunchTabContainerEditorPage getParentEditorPage() {
        return this.parentEditorPage;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        IDialogSettings settings = this.getDialogSettings(config);
        if (settings != null) {
            SWTControlUtil.setSelection((Button)this.showAutoGeneratedRules, (boolean)settings.getBoolean("showAutoGeneratedRules"));
            this.getViewer().refresh();
        }
    }

    protected IDialogSettings getDialogSettings(ILaunchConfiguration config) {
        String name;
        Assert.isNotNull((Object)config);
        IDialogSettings settings = null;
        IModelNode context = LaunchContextsPersistenceDelegate.getFirstLaunchContext((ILaunchConfiguration)config);
        if (context instanceof IPeerNode && (name = ((IPeerNode)context).getPeer().getName()) != null && (settings = UIPlugin.getDefault().getDialogSettings()) != null && (settings = DialogSettings.getOrCreateSection((IDialogSettings)settings, (String)PathMapTab.class.getSimpleName())) != null) {
            settings = DialogSettings.getOrCreateSection((IDialogSettings)settings, (String)name);
        }
        return settings;
    }

    public String getName() {
        return Messages.PathMapEditorPage_name;
    }

    protected String getColumnText(int column) {
        String text = super.getColumnText(column);
        if (text != null && text.trim().length() > 0) {
            String key = "PathMapEditorPage_column_" + text;
            if (Messages.hasString(key)) {
                text = Messages.getString(key);
            } else {
                key = "PathMapEditorPage_column_" + column;
                if (Messages.hasString(key)) {
                    text = Messages.getString(key);
                }
            }
        }
        return text != null ? text : "";
    }

    protected boolean showContextQuery() {
        return false;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        final CheckboxTableViewer viewer = this.fViewer;
        Menu menu = viewer.getTable().getMenu();
        if (menu != null) {
            MenuItem separator = new MenuItem(menu, 2);
            final MenuItem copyItem = new MenuItem(menu, 8);
            copyItem.setText(Messages.PathMapTab_copy_menu_label);
            copyItem.setEnabled(false);
            copyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String text;
                    Table table = viewer.getTable();
                    Point clickLoc = table.toControl(PathMapTab.this.fLastClickLocation);
                    ViewerCell cell = viewer.getCell(clickLoc);
                    if (cell != null && (text = cell.getText()) != null) {
                        Clipboard cb = new Clipboard(table.getDisplay());
                        cb.setContents((Object[])new String[]{text}, new Transfer[]{TextTransfer.getInstance()});
                        cb.dispose();
                    }
                }
            });
            viewer.getTable().addListener(3, new Listener(){

                public void handleEvent(Event event) {
                    PathMapTab.this.fLastClickLocation = event.display.getCursorLocation();
                    Table table = viewer.getTable();
                    Point clickLoc = table.toControl(PathMapTab.this.fLastClickLocation);
                    ViewerCell cell = viewer.getCell(clickLoc);
                    copyItem.setEnabled(cell != null);
                }
            });
        }
    }

    protected void createCustomControls(Composite parent) {
        Assert.isNotNull((Object)parent);
        super.createCustomControls(parent);
        this.showAutoGeneratedRules = new Button(parent, 32);
        this.showAutoGeneratedRules.setText(Messages.PathMapEditorPage_showAll_label);
        this.showAutoGeneratedRules.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.showAutoGeneratedRules.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PathMapTab.this.getViewer() != null) {
                    IDialogSettings settings;
                    if (PathMapTab.this.getViewer().getInput() instanceof ILaunchConfiguration && (settings = PathMapTab.this.getDialogSettings((ILaunchConfiguration)PathMapTab.this.getViewer().getInput())) != null) {
                        settings.put("showAutoGeneratedRules", SWTControlUtil.getSelection((Button)PathMapTab.this.showAutoGeneratedRules));
                    }
                    PathMapTab.this.getViewer().refresh();
                }
            }
        });
    }

    protected void configureTableViewer(CheckboxTableViewer viewer) {
        Assert.isNotNull((Object)viewer);
        super.configureTableViewer(viewer);
        this.fViewer = viewer;
        ClippedCellToolTip.enableFor((ColumnViewer)viewer);
        viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (PathMapTab.this.showAutoGeneratedRules != null && !PathMapTab.this.showAutoGeneratedRules.isDisposed() && !PathMapTab.this.showAutoGeneratedRules.getSelection() && element instanceof IPathMap.PathMapRule) {
                    IPathMap.PathMapRule rule = (IPathMap.PathMapRule)element;
                    return rule.getProperties().get("Generated") == null || (Boolean)rule.getProperties().get("Generated") == false;
                }
                return true;
            }
        });
        viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IPathMap.PathMapRule) {
                    IPathMap.PathMapRule rule = (IPathMap.PathMapRule)element;
                    return !"target".equals(rule.getProtocol());
                }
                return true;
            }
        });
    }

    protected void initializePathMap(List<IPathMap.PathMapRule> map, ILaunchConfiguration config) {
        super.initializePathMap(map, config);
        IModelNode context = LaunchContextsPersistenceDelegate.getFirstLaunchContext((ILaunchConfiguration)config);
        if (context instanceof IPeerNode) {
            IPathMap.PathMapRule[] rules;
            IPeerNode peerNode = (IPeerNode)context;
            IPathMapGeneratorService service = (IPathMapGeneratorService)ServiceManager.getInstance().getService((Object)peerNode, IPathMapGeneratorService.class);
            if (service != null && (rules = service.getPathMap((Object)peerNode)) != null && rules.length > 0) {
                IPathMap.PathMapRule[] pathMapRuleArray = rules;
                int n = rules.length;
                int n2 = 0;
                while (n2 < n) {
                    IPathMap.PathMapRule rule = pathMapRuleArray[n2];
                    rule.getProperties().put("Generated", Boolean.TRUE);
                    map.add(rule);
                    ++n2;
                }
            }
        }
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
        if (this.parentEditorPage != null) {
            this.performApply(AbstractTcfLaunchTabContainerEditorPage.getLaunchConfig(this.parentEditorPage.getPeerModel(this.parentEditorPage.getEditorInput())));
            this.parentEditorPage.checkLaunchConfigDirty();
        }
    }
}

