/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.views.scriptpad.console;

import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.tcf.ui.views.scriptpad.console.Console;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.console.IConsoleManager;

public class Factory
implements IConsoleFactory {
    private static volatile Console console;

    public void openConsole() {
        Factory.showConsole();
    }

    private static boolean isConsoleAlreadyAdded(IConsole console) {
        Assert.isNotNull((Object)console);
        boolean alreadyAdded = false;
        IConsole[] iConsoleArray = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole candidate = iConsoleArray[n2];
            if (candidate == console) {
                alreadyAdded = true;
                break;
            }
            ++n2;
        }
        return alreadyAdded;
    }

    public static void showConsole() {
        if (console == null) {
            console = new Console();
        }
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        if (!Factory.isConsoleAlreadyAdded((IConsole)console)) {
            manager.addConsoles(new IConsole[]{console});
        }
        manager.showConsoleView((IConsole)console);
    }

    public static Console getConsole() {
        return console;
    }

    public static void shutdownConsole() {
        if (console != null) {
            console.shutdown();
            console = null;
        }
    }
}

