/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.steps;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.tcf.locator.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.locator.steps.AbstractPeerNodeStep;

public class CheckServiceStep
extends AbstractPeerNodeStep {
    public static final String PARAMETER_REMOTE_SERVICE = "remoteService";
    public static final String PARAMETER_LOCAL_SERVICE = "localService";
    public static final String PARAMETER_OFFLINE_SERVICE = "offlineService";

    public void validateExecute(final IStepContext context, final IPropertiesContainer data, final IFullQualifiedId fullQualifiedId, final IProgressMonitor monitor) throws CoreException {
        if (Protocol.isDispatchThread()) {
            this.internalValidateExecute(context, data, fullQualifiedId, monitor);
        } else {
            final AtomicReference result = new AtomicReference();
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        CheckServiceStep.this.internalValidateExecute(context, data, fullQualifiedId, monitor);
                    }
                    catch (CoreException e) {
                        result.set(e);
                    }
                }
            });
            if (result.get() != null) {
                throw (CoreException)((Object)result.get());
            }
        }
    }

    protected void internalValidateExecute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
        List<String> list;
        IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        if (channel == null || channel.getState() != 1) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "missing or closed channel"));
        }
        String remoteService = (String)this.getParameters().get(PARAMETER_REMOTE_SERVICE);
        if (remoteService != null && channel.getRemoteService(remoteService) == null) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "missing remote service '" + remoteService + "'"));
        }
        String localService = (String)this.getParameters().get(PARAMETER_LOCAL_SERVICE);
        if (localService != null && channel.getLocalService(localService) == null) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "missing local service '" + localService + "'"));
        }
        String offlineService = (String)this.getParameters().get(PARAMETER_OFFLINE_SERVICE);
        String services = (String)this.getActivePeerContext(context, data, fullQualifiedId).getAttributes().get("OfflineServices");
        List<String> list2 = list = services != null ? Arrays.asList(services.split(",\\s*")) : Collections.EMPTY_LIST;
        if (offlineService != null && !list.contains(offlineService)) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "missing offline service '" + offlineService + "'"));
        }
    }

    public void execute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor, ICallback callback) {
        callback.done((Object)this, Status.OK_STATUS);
    }
}

