/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.trees;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.tcf.te.ui.interfaces.IViewerCellEditorFactory;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class TreeViewerEditorActivationStrategy
extends ColumnViewerEditorActivationStrategy {
    private static final String EXTENSION_POINT_ID = "org.eclipse.tcf.te.ui.cellEditors";
    String viewerId;
    TreeViewer viewer;
    Map<Expression, IViewerCellEditorFactory> factories;

    public TreeViewerEditorActivationStrategy(String viewerId, TreeViewer viewer) {
        super((ColumnViewer)viewer);
        Assert.isNotNull((Object)viewerId);
        this.viewerId = viewerId;
        this.viewer = viewer;
        this.loadFactories();
    }

    protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
        IViewerCellEditorFactory factory = this.getFactory(event);
        if (factory != null) {
            this.viewer.setColumnProperties(factory.getColumnProperties());
            this.viewer.setCellEditors(factory.getCellEditors());
            this.viewer.setCellModifier(factory.getCellModifier());
        }
        return factory != null;
    }

    private IViewerCellEditorFactory getFactory(ColumnViewerEditorActivationEvent event) {
        ISelection selection = this.viewer.getSelection();
        IEvaluationContext currentState = ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).getCurrentState();
        final EvaluationContext context = new EvaluationContext(currentState, (Object)selection);
        context.addVariable("selection", (Object)selection);
        context.addVariable("event", (Object)event);
        context.setAllowPluginActivation(true);
        final IViewerCellEditorFactory[] result = new IViewerCellEditorFactory[1];
        Iterator<Expression> iterator = this.factories.keySet().iterator();
        while (iterator.hasNext()) {
            Expression expression;
            final Expression exp = expression = iterator.next();
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void handleException(Throwable e) {
                }

                public void run() throws Exception {
                    EvaluationResult evaluate = exp.evaluate((IEvaluationContext)context);
                    if (evaluate == EvaluationResult.TRUE) {
                        result[0] = TreeViewerEditorActivationStrategy.this.factories.get(exp);
                    }
                }
            });
            if (result[0] == null) continue;
            return result[0];
        }
        return null;
    }

    private void loadFactories() {
        IConfigurationElement[] configurations;
        this.factories = Collections.synchronizedMap(new HashMap());
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT_ID);
        IConfigurationElement[] iConfigurationElementArray = configurations = extensionPoint.getConfigurationElements();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configuration = iConfigurationElementArray[n2];
            String name = configuration.getName();
            if ("cellEditor".equals(name) && this.isApplicable(configuration)) {
                this.addFactory(configuration);
            }
            ++n2;
        }
    }

    private boolean isApplicable(IConfigurationElement configuration) {
        IConfigurationElement[] children;
        IConfigurationElement[] iConfigurationElementArray = children = configuration.getChildren("contributeTo");
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String viewerId = child.getAttribute("viewerId");
            if (this.viewerId.equals(viewerId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void addFactory(final IConfigurationElement configuration) {
        IConfigurationElement[] children = configuration.getChildren("activation");
        Assert.isTrue((children != null && children.length == 1 ? 1 : 0) != 0);
        children = children[0].getChildren();
        Assert.isTrue((children != null && children.length == 1 ? 1 : 0) != 0);
        final IConfigurationElement config = children[0];
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void handleException(Throwable e) {
            }

            public void run() throws Exception {
                Expression expression = ExpressionConverter.getDefault().perform(config);
                IViewerCellEditorFactory factory = (IViewerCellEditorFactory)configuration.createExecutableExtension("editorFactory");
                if (expression != null && factory != null) {
                    factory.init(TreeViewerEditorActivationStrategy.this.viewer);
                    TreeViewerEditorActivationStrategy.this.factories.put(expression, factory);
                }
            }
        });
    }
}

