/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.ui.dialogs.FilteredCheckedListDialog;
import org.eclipse.tcf.te.ui.views.handler.ContentDescriptorLabelProvider;
import org.eclipse.tcf.te.ui.views.handler.UpdateActiveExtensionsOperation;
import org.eclipse.tcf.te.ui.views.nls.Messages;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ConfigContentHandler
extends AbstractHandler
implements IRegistryEventListener {
    private static final String EXTENSION_POINT_ID = "org.eclipse.ui.navigator.navigatorContent";
    private Map<String, Boolean> visibleContentMap;
    private Map<String, IPreferenceStore> prefMap;

    public ConfigContentHandler() {
        this.initVisibleMap();
        Platform.getExtensionRegistry().addListener((IRegistryEventListener)this, EXTENSION_POINT_ID);
    }

    private void initVisibleMap() {
        this.visibleContentMap = Collections.synchronizedMap(new HashMap());
        this.prefMap = Collections.synchronizedMap(new HashMap());
        IExtensionPoint exPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        IExtension[] extensions = exPoint.getExtensions();
        if (extensions != null) {
            this.addExtensions(extensions);
        }
    }

    private void addExtensions(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if ("navigatorContent".equals(element.getName())) {
                    String extensionId = element.getAttribute("id");
                    String pluginId = element.getContributor().getName();
                    IPreferenceStore prefStore = this.prefMap.get(pluginId);
                    if (prefStore == null) {
                        prefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, pluginId);
                        this.prefMap.put(pluginId, prefStore);
                    }
                    String prefHide = String.valueOf(extensionId) + ".hide";
                    this.visibleContentMap.put(extensionId, prefStore.getBoolean(prefHide));
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void removeExtensions(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if ("navigatorContent".equals(element.getName())) {
                    String extensionId = element.getAttribute("id");
                    this.visibleContentMap.remove(extensionId);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void added(IExtension[] extensions) {
        this.addExtensions(extensions);
    }

    public void removed(IExtension[] extensions) {
        this.removeExtensions(extensions);
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object[] visibleExtensions;
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        CommonNavigator navigator = (CommonNavigator)HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        FilteredCheckedListDialog contentDialog = new FilteredCheckedListDialog(shell);
        contentDialog.setTitle(Messages.ConfigContentHandler_DialogTitle);
        contentDialog.setFilterText(Messages.ConfigContentHandler_InitialFilter);
        contentDialog.setMessage(Messages.ConfigContentHandler_PromptMessage);
        contentDialog.setStatusLineAboveButtons(true);
        contentDialog.setLabelProvider((ILabelProvider)ContentDescriptorLabelProvider.instance);
        INavigatorContentService contentService = navigator.getNavigatorContentService();
        if (contentService != null && (visibleExtensions = this.getExtensionsVisibleInUI(contentService)) != null && visibleExtensions.length > 0) {
            Object[] result;
            contentDialog.setElements(visibleExtensions);
            ArrayList<Object> activeExtensions = new ArrayList<Object>();
            Object[] objectArray = visibleExtensions;
            int n = visibleExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                Object extension = objectArray[n2];
                if (contentService.isActive(extension.getId())) {
                    activeExtensions.add(extension);
                }
                ++n2;
            }
            contentDialog.setInitialElementSelections(activeExtensions);
            if (contentDialog.open() == 0 && (result = contentDialog.getResult()) != null) {
                INavigatorContentDescriptor[] hiddenActives = this.getHiddenActiveExtensions(contentService);
                INavigatorContentDescriptor[] total = new INavigatorContentDescriptor[result.length + hiddenActives.length];
                System.arraycopy(result, 0, total, 0, result.length);
                System.arraycopy(hiddenActives, 0, total, result.length, hiddenActives.length);
                this.activateExtensions(navigator.getCommonViewer(), total);
            }
        }
        return null;
    }

    private INavigatorContentDescriptor[] getHiddenActiveExtensions(INavigatorContentService contentService) {
        INavigatorContentDescriptor[] visibleExtensions = contentService.getVisibleExtensions();
        ArrayList<INavigatorContentDescriptor> hiddenActives = new ArrayList<INavigatorContentDescriptor>();
        if (visibleExtensions != null) {
            INavigatorContentDescriptor[] iNavigatorContentDescriptorArray = visibleExtensions;
            int n = visibleExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                boolean hide;
                INavigatorContentDescriptor visibleExtension = iNavigatorContentDescriptorArray[n2];
                String extensionId = visibleExtension.getId();
                Boolean value = this.visibleContentMap.get(extensionId);
                boolean bl = hide = value != null && value != false;
                if (hide && contentService.isActive(extensionId)) {
                    hiddenActives.add(visibleExtension);
                }
                ++n2;
            }
        }
        return hiddenActives.toArray(new INavigatorContentDescriptor[hiddenActives.size()]);
    }

    private INavigatorContentDescriptor[] getExtensionsVisibleInUI(INavigatorContentService contentService) {
        INavigatorContentDescriptor[] visibleExtensions = contentService.getVisibleExtensions();
        ArrayList<INavigatorContentDescriptor> visibleInUIs = new ArrayList<INavigatorContentDescriptor>();
        if (visibleExtensions != null) {
            INavigatorContentDescriptor[] iNavigatorContentDescriptorArray = visibleExtensions;
            int n = visibleExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                boolean hide;
                INavigatorContentDescriptor visibleExtension = iNavigatorContentDescriptorArray[n2];
                String extensionId = visibleExtension.getId();
                Boolean value = this.visibleContentMap.get(extensionId);
                boolean bl = hide = value != null && value != false;
                if (!hide) {
                    visibleInUIs.add(visibleExtension);
                }
                ++n2;
            }
        }
        return visibleInUIs.toArray(new INavigatorContentDescriptor[visibleInUIs.size()]);
    }

    private void activateExtensions(CommonViewer commonViewer, INavigatorContentDescriptor[] contentDescriptors) {
        HashSet<String> toActivate = new HashSet<String>();
        int i = 0;
        while (i < contentDescriptors.length) {
            INavigatorContentDescriptor contentDescriptor = contentDescriptors[i];
            toActivate.add(contentDescriptor.getId());
            ++i;
        }
        UpdateActiveExtensionsOperation updateExtensions = new UpdateActiveExtensionsOperation(commonViewer, toActivate.toArray(new String[toActivate.size()]));
        updateExtensions.execute(null, null);
    }
}

