/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.remote.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.remote.core.Messages;
import org.eclipse.tcf.te.tcf.remote.core.TCFConnection;
import org.eclipse.tcf.te.tcf.remote.core.TCFEclipseFileSystem;
import org.eclipse.tcf.te.tcf.remote.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFOperationChildStores;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFOperationDelete;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFOperationFetchInfo;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFOperationMkDir;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFOperationOpenInputStream;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFOperationOpenOutputStream;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFOperationPutInfo;
import org.osgi.framework.Bundle;

public final class TCFFileStore
extends FileStore {
    private final URI fURI;
    private final TCFConnection fConnection;
    private IFileSystem.FileAttrs fAttributes;
    private IFileStore fParent;

    public static IFileStore getInstance(URI uri) {
        IRemoteConnection connection = TCFEclipseFileSystem.getConnection(uri);
        if (connection instanceof TCFConnection) {
            return new TCFFileStore((TCFConnection)connection, uri, null);
        }
        return EFS.getNullFileSystem().getStore((IPath)new Path(uri.getPath()));
    }

    public static IFileStore getInstance(TCFConnection connection, String path, TCFFileStore parent) {
        try {
            URI uri = TCFEclipseFileSystem.getURIFor(connection, path);
            return new TCFFileStore(connection, uri, parent);
        }
        catch (URISyntaxException e) {
            Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), Messages.TCFFileManager_errorFileStoreForPath, (Throwable)e));
            return EFS.getNullFileSystem().getStore((IPath)new Path(path));
        }
    }

    private TCFFileStore(TCFConnection connection, URI uri, TCFFileStore parent) {
        this.fURI = uri;
        this.fConnection = connection;
        this.fParent = parent;
    }

    public URI toURI() {
        return this.fURI;
    }

    public TCFConnection getConnection() {
        return this.fConnection;
    }

    public String getPath() {
        return this.fURI.getPath();
    }

    public void setAttributes(IFileSystem.FileAttrs attrs) {
        this.fAttributes = attrs;
    }

    public IFileSystem.FileAttrs getAttributes() {
        return this.fAttributes;
    }

    public IFileStore getChild(String name) {
        String path = String.valueOf(this.getPath()) + '/' + name;
        if ((path = path.replaceAll("/+", "/")).length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return TCFFileStore.getInstance(this.fConnection, path, this);
    }

    public String getName() {
        String path = this.getPath();
        int idx = path.lastIndexOf(47);
        if (idx > 0) {
            return path.substring(idx + 1);
        }
        return path;
    }

    public IFileStore getParent() {
        if (this.fParent != null) {
            return this.fParent;
        }
        String path = this.getPath();
        int idx = path.lastIndexOf(47);
        if (idx < 1) {
            return null;
        }
        this.fParent = TCFFileStore.getInstance(this.fConnection, path.substring(0, idx - 1), null);
        return this.fParent;
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        try {
            return (IFileInfo)new TCFOperationFetchInfo(this).execute(SubMonitor.convert((IProgressMonitor)monitor));
        }
        catch (OperationCanceledException operationCanceledException) {
            return new FileInfo(this.getName());
        }
    }

    public IFileStore[] childStores(int options, IProgressMonitor monitor) throws CoreException {
        try {
            return (IFileStore[])new TCFOperationChildStores(this).execute(SubMonitor.convert((IProgressMonitor)monitor));
        }
        catch (OperationCanceledException operationCanceledException) {
            return new IFileStore[0];
        }
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        IFileStore[] children = this.childStores(options, monitor);
        String[] result = new String[children.length];
        int i = 0;
        IFileStore[] iFileStoreArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore s = iFileStoreArray[n2];
            result[i++] = s.getName();
            ++n2;
        }
        return result;
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        try {
            new TCFOperationDelete(this).execute(SubMonitor.convert((IProgressMonitor)monitor));
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        boolean shallow = (options & 4) == 4;
        try {
            new TCFOperationMkDir(this, shallow).execute(SubMonitor.convert((IProgressMonitor)monitor));
        }
        catch (OperationCanceledException operationCanceledException) {}
        return this;
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        boolean setAttribs = (options & 0x400) != 0;
        boolean setLastModified = (options & 0x800) != 0;
        try {
            if (setAttribs || setLastModified) {
                new TCFOperationPutInfo(this, info, setAttribs, setLastModified).execute(SubMonitor.convert((IProgressMonitor)monitor));
            }
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        try {
            return (InputStream)new TCFOperationOpenInputStream(this).execute(SubMonitor.convert((IProgressMonitor)monitor));
        }
        catch (OperationCanceledException operationCanceledException) {
            return null;
        }
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        boolean append = (options & 1) != 0;
        try {
            return (OutputStream)new TCFOperationOpenOutputStream(this, append).execute(SubMonitor.convert((IProgressMonitor)monitor));
        }
        catch (OperationCanceledException operationCanceledException) {
            return null;
        }
    }
}

