/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.io.File;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.core.concurrent.TCFOperationMonitor;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.AbstractOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpCacheFileDigest;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.FileState;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.PersistenceManager;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class OpRefresh
extends AbstractOperation {
    private static Map<FSTreeNode, TCFOperationMonitor<?>> fPendingResults = new HashMap();
    final LinkedList<FSTreeNode> fWork = new LinkedList();
    final boolean fRecursive;
    private long fStartTime;

    public OpRefresh(FSTreeNode node, boolean recursive) {
        this.fWork.add(node);
        this.fRecursive = recursive;
    }

    public OpRefresh(List<IFSTreeNode> nodes, boolean recursive) {
        this.fRecursive = recursive;
        for (IFSTreeNode node : nodes) {
            if (!(node instanceof FSTreeNode)) continue;
            this.fWork.add((FSTreeNode)node);
        }
    }

    @Override
    public IStatus doRun(IProgressMonitor monitor) {
        FSTreeNode needsNotification = null;
        FSTreeNode trigger = this.fWork.peek();
        this.fStartTime = System.currentTimeMillis();
        monitor.beginTask(this.getName(), -1);
        while (!this.fWork.isEmpty()) {
            IStatus s;
            boolean isTop;
            FSTreeNode node = this.fWork.remove();
            boolean bl = isTop = trigger == node;
            if (isTop) {
                if (needsNotification != null) {
                    needsNotification.notifyChange();
                }
                needsNotification = node;
                trigger = this.fWork.peek();
            }
            if ((s = this.refreshNode(node, isTop, monitor)).isOK()) continue;
            if (needsNotification != null) {
                needsNotification.notifyChange();
            }
            return s;
        }
        if (needsNotification != null) {
            needsNotification.notifyChange();
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus refreshNode(FSTreeNode node, boolean isTop, IProgressMonitor monitor) {
        IStatus status;
        if (node.getLastRefresh() >= this.fStartTime) {
            FSTreeNode[] children = node.getChildren();
            if (children != null) {
                FSTreeNode[] fSTreeNodeArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    FSTreeNode child = fSTreeNodeArray[n2];
                    this.fWork.addFirst(child);
                    ++n2;
                }
            }
            return Status.OK_STATUS;
        }
        boolean isDir = node.isDirectory();
        boolean isFile = node.isFile();
        if (!(node.isFileSystem() || isDir || isFile)) {
            return Status.OK_STATUS;
        }
        if (!isTop && !isFile && node.getChildren() == null) {
            return Status.OK_STATUS;
        }
        monitor.subTask(MessageFormat.format(Messages.OpRefresh_name, node.getLocation()));
        Map<FSTreeNode, TCFOperationMonitor<?>> map = fPendingResults;
        synchronized (map) {
            TCFOperationMonitor result = fPendingResults.get(node);
            if (result == null) {
                result = new TCFOperationMonitor(false);
                fPendingResults.put(node, result);
                this.scheduleTcfRefresh(node, isTop, result);
            }
            status = result.waitDone(monitor);
            if (!result.hasWaiters()) {
                result.setCancelled();
                fPendingResults.remove(node);
            }
        }
        return status;
    }

    private void scheduleTcfRefresh(final FSTreeNode node, final boolean isTop, final TCFOperationMonitor<?> result) {
        if (!result.checkCancelled()) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (node.isFileSystem()) {
                        OpRefresh.this.tcfRefreshRoots(node, result);
                    } else if (isTop && !node.isRootDirectory()) {
                        OpRefresh.this.tcfStatAndRefresh(node, result);
                    } else {
                        OpRefresh.this.tcfRefresh(node, result);
                    }
                }
            });
        }
    }

    protected void tcfRefreshRoots(final FSTreeNode node, final TCFOperationMonitor<?> result) {
        if (!result.checkCancelled()) {
            IFileSystem fs = node.getRuntimeModel().getFileSystem();
            if (fs == null) {
                result.setCancelled();
                return;
            }
            fs.roots(new IFileSystem.DoneRoots(){

                public void doneRoots(IToken token, IFileSystem.FileSystemException error, IFileSystem.DirEntry[] entries) {
                    if (error != null) {
                        result.setError(MessageFormat.format(Messages.OpRefresh_errorGetRoots, node.getRuntimeModel().getName()), (Throwable)error);
                    } else if (!result.checkCancelled()) {
                        IRuntimeModel.Delegate delegate = node.getRuntimeModel().getDelegate();
                        ArrayList<FSTreeNode> nodes = new ArrayList<FSTreeNode>(entries.length);
                        IFileSystem.DirEntry[] dirEntryArray = entries;
                        int n = entries.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFileSystem.DirEntry entry = dirEntryArray[n2];
                            if (delegate.filterRoot(entry)) {
                                nodes.add(new FSTreeNode(node, entry.filename, true, entry.attrs));
                            }
                            ++n2;
                        }
                        node.setContent(nodes.toArray(new FSTreeNode[nodes.size()]), false);
                        for (FSTreeNode node2 : nodes) {
                            if (!OpRefresh.this.fRecursive && !node2.isFile()) continue;
                            OpRefresh.this.fWork.addFirst(node2);
                        }
                        result.setDone(null);
                    }
                }
            });
        }
    }

    protected void tcfStatAndRefresh(final FSTreeNode node, final TCFOperationMonitor<?> result) {
        if (!result.checkCancelled()) {
            IFileSystem fs = node.getRuntimeModel().getFileSystem();
            if (fs == null) {
                result.setCancelled();
                return;
            }
            fs.stat(node.getLocation(true), new IFileSystem.DoneStat(){

                public void doneStat(IToken token, IFileSystem.FileSystemException error, IFileSystem.FileAttrs attrs) {
                    if (error != null) {
                        OpRefresh.this.handleFSError(node, Messages.OpRefresh_errorReadAttributes, error, result);
                    } else {
                        node.setAttributes(attrs, false);
                        OpRefresh.this.tcfRefresh(node, result);
                    }
                }
            });
        }
    }

    protected void tcfRefresh(final FSTreeNode node, final TCFOperationMonitor<?> result) {
        if (!result.checkCancelled()) {
            if (node.isFile()) {
                this.tcfUpdateCacheDigest(node, result);
            } else if (node.isDirectory()) {
                final String path = node.getLocation(true);
                IFileSystem fs = node.getRuntimeModel().getFileSystem();
                if (fs == null) {
                    result.setCancelled();
                    return;
                }
                this.tcfReadDir(fs, path, new AbstractOperation.IReadDirDone(){

                    @Override
                    public void error(IFileSystem.FileSystemException error) {
                        node.setContent(NO_CHILDREN, false);
                        result.setError(MessageFormat.format(Messages.OpRefresh_errorOpenDir, path), (Throwable)error);
                    }

                    @Override
                    public boolean checkCancelled() {
                        return result.checkCancelled();
                    }

                    @Override
                    public void done(List<IFileSystem.DirEntry> entries) {
                        int i = 0;
                        FSTreeNode[] nodes = new FSTreeNode[entries.size()];
                        for (IFileSystem.DirEntry entry : entries) {
                            nodes[i++] = new FSTreeNode(node, entry.filename, false, entry.attrs);
                        }
                        node.setContent(nodes, false);
                        FSTreeNode[] fSTreeNodeArray = nodes;
                        int n = nodes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            FSTreeNode node2 = fSTreeNodeArray[n2];
                            if (OpRefresh.this.fRecursive || node2.isFile()) {
                                OpRefresh.this.fWork.addFirst(node2);
                            }
                            ++n2;
                        }
                        result.setDone(null);
                    }
                });
            } else {
                result.setDone(null);
            }
        }
    }

    protected void tcfUpdateCacheDigest(final FSTreeNode node, final TCFOperationMonitor<?> result) {
        File cacheFile = node.getCacheFile();
        if (!cacheFile.exists()) {
            result.setDone(null);
            return;
        }
        final FileState digest = PersistenceManager.getInstance().getFileDigest(node);
        final long cacheMTime = cacheFile.lastModified();
        if (digest.getCacheDigest() == null || digest.getCacheMTime() != cacheMTime) {
            final OpCacheFileDigest op = new OpCacheFileDigest(node);
            op.runInJob((ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    if (status.isOK()) {
                        digest.updateCacheDigest(op.getDigest(), cacheMTime);
                        OpRefresh.this.tcfUpdateTargetDigest(digest, node, result);
                    } else {
                        result.setDone(status, null);
                    }
                }
            });
        } else {
            this.tcfUpdateTargetDigest(digest, node, result);
        }
    }

    protected void tcfUpdateTargetDigest(FileState digest, FSTreeNode node, final TCFOperationMonitor<?> result) {
        if (digest.getTargetDigest() == null || digest.getTargetMTime() != node.getModificationTime()) {
            IOperation op = node.operationDownload(new OutputStream(){

                @Override
                public void write(int b) {
                }
            });
            op.runInJob((ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    result.setDone(status, null);
                }
            });
        } else {
            result.setDone(null);
        }
    }

    @Override
    public String getName() {
        return NLS.bind((String)Messages.OpRefresh_name, (Object)"");
    }
}

