/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.breakpoints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.internal.cdt.ui.Activator;
import org.eclipse.tcf.internal.cdt.ui.ImageCache;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.Messages;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFBreakpointScopeExtension;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFBreakpointThreadFilterPage;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFContextQueryExpressionDialog;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelManager;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IContextQuery;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class TCFThreadFilterEditor {
    public static final String PLUGIN_ID = "org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFThreadFilterEditor";
    private TCFBreakpointThreadFilterPage fPage;
    private CheckboxTreeViewer fThreadViewer;
    private final ThreadFilterContentProvider fContentProvider;
    private final CheckHandler fCheckHandler;
    private final List<Context> fContexts = new ArrayList<Context>();
    private final Set<Object> fFilteredContexts = new HashSet<Object>();
    private final Map<TCFLaunch, Context[]> fContainersPerLaunch = new HashMap<TCFLaunch, Context[]>();
    private final Map<Context, Context[]> fContextsPerContainer = new HashMap<Context, Context[]>();
    private Combo scopeExprCombo;
    private ControlDecoration scopeExpressionDecoration;
    private final Set<String> fContextList = new TreeSet<String>();
    private Link preferencesLink;

    private IDialogSettings getDialogSettings(boolean create) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getClass().getName());
        if (section == null & create) {
            section = settings.addNewSection(this.getClass().getName());
        }
        return section;
    }

    public TCFThreadFilterEditor(Composite parent, TCFBreakpointThreadFilterPage page) {
        this.fPage = page;
        this.fContentProvider = new ThreadFilterContentProvider();
        this.fCheckHandler = new CheckHandler();
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setFont(parent.getFont());
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 500;
        mainComposite.setLayoutData((Object)gd);
        mainComposite.setLayout((Layout)new GridLayout(2, false));
        this.createThreadViewer(mainComposite);
    }

    protected TCFBreakpointThreadFilterPage getPage() {
        return this.fPage;
    }

    private String getBPFilterExpression() {
        return this.fPage.getFilterExtension().getPropertiesFilter();
    }

    private String[] getAvailableAttributes() {
        String[] result = null;
        TCFLaunch launch = (TCFLaunch)this.getAttributeLaunch();
        if (launch == null || launch.isTerminated()) {
            return result;
        }
        final IChannel channel = launch.getChannel();
        if (channel == null) {
            return result;
        }
        result = (String[])new TCFTask<String[]>(channel){

            public void run() {
                IContextQuery service = (IContextQuery)channel.getRemoteService(IContextQuery.class);
                service.getAttrNames(new IContextQuery.DoneGetAttrNames(){

                    public void doneGetAttrNames(IToken token, Exception error, String[] attributes) {
                        if (error != null) {
                            this.done(null);
                        }
                        this.done(attributes);
                    }
                });
            }
        }.getE();
        return result;
    }

    private String getQueryFilteredContexts(final String query, final Set<String> contextList) {
        TCFLaunch launch = (TCFLaunch)this.getAttributeLaunch();
        if (launch == null || launch.isTerminated()) {
            return Messages.TCFThreadFilterEditorNoOpenChannel;
        }
        final IChannel channel = launch.getChannel();
        if (channel == null) {
            return Messages.TCFThreadFilterEditorNoOpenChannel;
        }
        String result = (String)new TCFTask<String>(){

            public void run() {
                IContextQuery service = (IContextQuery)channel.getRemoteService(IContextQuery.class);
                service.query(query, new IContextQuery.DoneQuery(){

                    public void doneQuery(IToken token, Exception error, String[] contexts) {
                        if (error != null) {
                            this.done(TCFModel.getErrorMessage((Throwable)error, (boolean)false));
                        } else {
                            String[] stringArray = contexts;
                            int n = contexts.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String context = stringArray[n2];
                                contextList.add(context);
                                ++n2;
                            }
                            this.done(null);
                        }
                    }
                });
            }
        }.getE();
        return result;
    }

    String validateBasicSyntax(String expression) {
        String result = null;
        Pattern p = Pattern.compile("\"((?:\\\\\\\\|\\\\\"|[^\"])*)\"");
        Matcher m = p.matcher(expression);
        expression = m.replaceAll("temp");
        if (expression.matches("^(.*?)(\\s)(.*)$")) {
            return Messages.TCFThreadFilterEditorFormatError;
        }
        if (expression.matches("^(.*?)[^a-zA-Z0-9_]=[^a-zA-Z0-9_](.*)$")) {
            return Messages.TCFThreadFilterEditorUnbalancedParameters;
        }
        return result;
    }

    void setupScopeExpressionCombo() {
        if (this.scopeExprCombo == null) {
            return;
        }
        IDialogSettings settings = this.getDialogSettings(false);
        String bpContextQuery = this.getBPFilterExpression();
        String[] expresionList = null;
        if (settings != null) {
            expresionList = settings.getArray(Messages.TCFThreadFilterQueryExpressionStore);
            if (expresionList != null) {
                int index = 0;
                while (index < expresionList.length) {
                    String member = expresionList[index];
                    if (member == null || member.length() == 0) break;
                    ++index;
                }
                String[] copyList = new String[index];
                int found = -1;
                int loop = 0;
                while (loop < index) {
                    copyList[loop] = expresionList[loop];
                    if (bpContextQuery != null && copyList[loop].equals(bpContextQuery)) {
                        found = loop;
                    }
                    ++loop;
                }
                if (found != -1) {
                    this.scopeExprCombo.setItems(copyList);
                    this.scopeExprCombo.select(found);
                } else {
                    int pad = 0;
                    if (bpContextQuery != null) {
                        pad = 1;
                    }
                    String[] setList = new String[index + pad];
                    if (bpContextQuery != null) {
                        setList[0] = bpContextQuery;
                    }
                    System.arraycopy(copyList, 0, setList, pad, copyList.length);
                    this.scopeExprCombo.setItems(setList);
                    if (bpContextQuery != null) {
                        this.scopeExprCombo.select(0);
                    }
                }
            } else if (bpContextQuery != null) {
                this.scopeExprCombo.setItems(new String[]{bpContextQuery});
                this.scopeExprCombo.select(0);
            }
        } else if (bpContextQuery != null) {
            this.scopeExprCombo.setItems(new String[]{bpContextQuery});
            this.scopeExprCombo.select(0);
        }
    }

    private void createThreadViewer(Composite parent) {
        GridData twoColumnLayout = new GridData(4, 0, true, false);
        twoColumnLayout.horizontalSpan = 2;
        GridData comboGridData = new GridData(4, 0, true, false);
        comboGridData.horizontalIndent = 5;
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        Label epressionLabel = new Label(parent, 0);
        epressionLabel.setText(Messages.TCFThreadFilterQueryAdvancedLabel);
        epressionLabel.setFont(parent.getFont());
        epressionLabel.setLayoutData((Object)twoColumnLayout);
        this.scopeExprCombo = new Combo(parent, 4);
        this.scopeExprCombo.setLayoutData((Object)comboGridData);
        this.scopeExprCombo.addModifyListener((ModifyListener)new ExpressionModifier());
        this.scopeExprCombo.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TCFThreadFilterEditor.this.scopeExprCombo = null;
            }
        });
        this.scopeExpressionDecoration = new ControlDecoration((Control)this.scopeExprCombo, 16384, parent);
        this.scopeExpressionDecoration.hide();
        this.scopeExpressionDecoration.setDescriptionText(Messages.TCFThreadFilterEditorFormatError);
        this.scopeExpressionDecoration.setImage(fieldDecoration.getImage());
        this.setupScopeExpressionCombo();
        Button selectExpression = new Button(parent, 8);
        selectExpression.setText(Messages.TCFThreadFilterQueryButtonEdit);
        selectExpression.setLayoutData((Object)new GridData(131072, 0, false, false));
        selectExpression.addListener(13, (Listener)new ExpressionSelectButton(parent.getShell()));
        Label contextTreeLabel = new Label(parent, 0);
        contextTreeLabel.setText(Messages.TCFThreadFilterQueryTreeViewLabel);
        contextTreeLabel.setFont(parent.getFont());
        contextTreeLabel.setLayoutData((Object)twoColumnLayout);
        GridData data = new GridData(1808);
        data.heightHint = 100;
        this.fThreadViewer = new CheckboxTreeViewer(parent, 2048);
        this.fThreadViewer.addCheckStateListener((ICheckStateListener)this.fCheckHandler);
        this.fThreadViewer.getTree().setLayoutData((Object)data);
        this.fThreadViewer.getTree().setFont(parent.getFont());
        this.fThreadViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fThreadViewer.setLabelProvider((IBaseLabelProvider)new ThreadFilterLabelProvider());
        this.fThreadViewer.setInput((Object)DebugPlugin.getDefault().getLaunchManager());
        this.setInitialCheckedState();
        this.preferencesLink = new Link(parent, 64);
        this.preferencesLink.setLayoutData((Object)twoColumnLayout);
        this.preferencesLink.setText(Messages.TCFThreadFilterEditor_defaultScopePrefsLink);
        this.preferencesLink.addSelectionListener((SelectionListener)new linkSelectAdapter(parent.getShell()));
        parent.layout();
    }

    protected ILaunch getAttributeLaunch() {
        IAdaptable dbgContext = DebugUITools.getDebugContext();
        return (ILaunch)dbgContext.getAdapter(ILaunch.class);
    }

    protected ILaunch[] getLaunches() {
        Object input = this.fThreadViewer.getInput();
        if (!(input instanceof ILaunchManager)) {
            return new ILaunch[0];
        }
        ArrayList<ILaunch> tcfLaunches = new ArrayList<ILaunch>();
        ILaunch[] launches = ((ILaunchManager)input).getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            if (launch instanceof TCFLaunch && !launch.isTerminated()) {
                tcfLaunches.add(launch);
            }
            ++i;
        }
        return tcfLaunches.toArray(new ILaunch[tcfLaunches.size()]);
    }

    protected Context[] getRootContexts() {
        Object input = this.fThreadViewer.getInput();
        if (!(input instanceof ILaunchManager)) {
            return new Context[0];
        }
        ArrayList<Context> targets = new ArrayList<Context>();
        ILaunch[] launches = ((ILaunchManager)input).getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            if (launch instanceof TCFLaunch && !launch.isTerminated()) {
                Context[] targetArray = this.syncGetContainers((TCFLaunch)launch);
                targets.addAll(Arrays.asList(targetArray));
            }
            ++i;
        }
        return targets.toArray(new Context[targets.size()]);
    }

    protected final CheckboxTreeViewer getThreadViewer() {
        return this.fThreadViewer;
    }

    protected String getScopeExpression() {
        if (this.scopeExprCombo != null) {
            return this.scopeExprCombo.getText();
        }
        return null;
    }

    protected void setInitialCheckedState() {
        TCFBreakpointScopeExtension filterExtension = this.fPage.getFilterExtension();
        if (filterExtension == null) {
            return;
        }
        String[] ctxIds = filterExtension.getThreadFilters();
        this.getThreadViewer().expandAll();
        if (ctxIds == null) {
            ILaunch[] launches;
            ILaunch[] iLaunchArray = launches = this.getLaunches();
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                this.fCheckHandler.checkLaunch(launch, true);
                ++n2;
            }
        } else if (ctxIds.length != 0) {
            int i = 0;
            while (i < ctxIds.length) {
                String id = ctxIds[i];
                Context ctx = this.getContext(id);
                if (ctx != null) {
                    this.fCheckHandler.checkContext(ctx, true);
                    this.fCheckHandler.updateParentCheckState(ctx);
                } else if (id.indexOf(47) < 0) {
                    for (Context context : this.fContexts) {
                        if (!id.equals(context.fId)) continue;
                        this.fCheckHandler.checkContext(context, true);
                        this.fCheckHandler.updateParentCheckState(context);
                    }
                }
                ++i;
            }
        }
        this.getThreadViewer().setExpandedElements(this.getThreadViewer().getCheckedElements());
    }

    private Context getContainer(Context child) {
        String parentId = child.fSessionId != null ? String.valueOf(child.fSessionId) + '/' + child.fParentId : child.fParentId;
        return this.getContext(parentId);
    }

    private Context getContext(String id) {
        for (Context ctx : this.fContexts) {
            if (!ctx.fScopeId.equals(id)) continue;
            return ctx;
        }
        return null;
    }

    void updateExpressionsDialogSettings(IDialogSettings settings, String scopedExpression) {
        String[] list = settings.getArray(Messages.TCFThreadFilterQueryExpressionStore);
        if (list == null) {
            list = new String[20];
        }
        int i = 0;
        while (i < list.length) {
            String member = list[i];
            if (member != null && member.equals(scopedExpression)) {
                return;
            }
            if (member == null) {
                list[i] = scopedExpression;
                settings.put(Messages.TCFThreadFilterQueryExpressionStore, list);
                return;
            }
            ++i;
        }
        String[] copyList = new String[20];
        copyList[0] = scopedExpression;
        System.arraycopy(list, 0, copyList, 1, list.length - 1);
        settings.put(Messages.TCFThreadFilterQueryExpressionStore, copyList);
    }

    protected void doStore() {
        TCFBreakpointScopeExtension filterExtension;
        IDialogSettings settings = this.getDialogSettings(true);
        String scopedExpression = this.getScopeExpression();
        if (scopedExpression.length() != 0) {
            this.updateExpressionsDialogSettings(settings, scopedExpression);
        }
        if ((filterExtension = this.fPage.getFilterExtension()) == null) {
            return;
        }
        filterExtension.setPropertiesFilter(scopedExpression);
        CheckboxTreeViewer viewer = this.getThreadViewer();
        Object[] elements = viewer.getCheckedElements();
        String[] threadIds = null;
        ArrayList<String> checkedIds = new ArrayList<String>();
        int i = 0;
        while (i < elements.length) {
            Context ctx;
            if (elements[i] instanceof Context && !viewer.getGrayed((Object)(ctx = (Context)elements[i]))) {
                checkedIds.add(ctx.fScopeId);
            }
            ++i;
        }
        if (checkedIds.size() != this.fFilteredContexts.size()) {
            threadIds = checkedIds.toArray(new String[checkedIds.size()]);
        }
        filterExtension.setThreadFilter(threadIds);
    }

    private Context[] syncGetContainers(final TCFLaunch launch) {
        Context[] result = this.fContainersPerLaunch.get(launch);
        if (result != null) {
            return result;
        }
        final String launchCfgName = launch.getLaunchConfiguration().getName();
        result = (Context[])new TCFTask<Context[]>(launch.getChannel()){

            public void run() {
                ArrayList<Context> containers = new ArrayList<Context>();
                TCFChildren children = TCFModelManager.getModelManager().getRootNode(launch).getChildren();
                if (!children.validate((Runnable)((Object)this))) {
                    return;
                }
                TCFNode[] tCFNodeArray = children.toArray();
                int n = tCFNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TCFNode node = tCFNodeArray[n2];
                    TCFNodeExecContext exeCtx = (TCFNodeExecContext)node;
                    TCFDataCache runCtxCache = exeCtx.getRunContext();
                    if (!runCtxCache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    IRunControl.RunControlContext runCtx = (IRunControl.RunControlContext)runCtxCache.getData();
                    containers.add(new Context(runCtx, launchCfgName));
                    ++n2;
                }
                this.done(containers.toArray(new Context[containers.size()]));
            }
        }.getE();
        this.fContainersPerLaunch.put(launch, result);
        this.fContexts.addAll(Arrays.asList(result));
        return result;
    }

    private Context[] syncGetThreads(final Context container) {
        Context[] result = this.fContextsPerContainer.get(container);
        if (result != null) {
            return result;
        }
        final TCFLaunch launch = this.getLaunch(container);
        result = (Context[])new TCFTask<Context[]>(launch.getChannel()){

            public void run() {
                ArrayList<Context> contexts = new ArrayList<Context>();
                TCFModel model = TCFModelManager.getModelManager().getModel(launch);
                TCFChildren children = ((TCFNodeExecContext)model.getNode(container.fId)).getChildren();
                if (!children.validate((Runnable)((Object)this))) {
                    return;
                }
                TCFNode[] tCFNodeArray = children.toArray();
                int n = tCFNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TCFNode node = tCFNodeArray[n2];
                    TCFNodeExecContext exeCtx = (TCFNodeExecContext)node;
                    TCFDataCache runCtxCache = exeCtx.getRunContext();
                    if (!runCtxCache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    IRunControl.RunControlContext runCtx = (IRunControl.RunControlContext)runCtxCache.getData();
                    contexts.add(new Context(runCtx, container));
                    ++n2;
                }
                this.done(contexts.toArray(new Context[contexts.size()]));
            }
        }.getE();
        this.fContextsPerContainer.put(container, result);
        this.fContexts.addAll(Arrays.asList(result));
        return result;
    }

    private TCFLaunch getLaunch(Context container) {
        Context parent = this.getContainer(container);
        while (parent != null) {
            container = parent;
            parent = this.getContainer(container);
        }
        for (TCFLaunch launch : this.fContainersPerLaunch.keySet()) {
            Context[] containers;
            Context[] contextArray = containers = this.fContainersPerLaunch.get(launch);
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                Context context = contextArray[n2];
                if (context.fScopeId.equals(container.fScopeId)) {
                    return launch;
                }
                ++n2;
            }
        }
        return null;
    }

    public class CheckHandler
    implements ICheckStateListener {
        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            boolean checked = event.getChecked();
            if (checked) {
                TCFThreadFilterEditor.this.getThreadViewer().expandToLevel(element, 1);
            }
            if (element instanceof Context) {
                Context ctx = (Context)element;
                this.checkContext(ctx, checked);
                this.updateParentCheckState(ctx);
            } else if (element instanceof ILaunch) {
                this.checkLaunch((ILaunch)element, checked);
            }
        }

        private void checkLaunch(ILaunch launch, boolean checked) {
            TCFThreadFilterEditor.this.getThreadViewer().setChecked((Object)launch, checked);
            TCFThreadFilterEditor.this.getThreadViewer().setGrayed((Object)launch, false);
            Object[] threads = TCFThreadFilterEditor.this.fContentProvider.getChildren(launch);
            int i = 0;
            while (i < threads.length) {
                this.checkContext((Context)threads[i], checked);
                ++i;
            }
        }

        private void checkContext(Context ctx, boolean checked) {
            if (ctx.fIsContainer) {
                Object[] threads = TCFThreadFilterEditor.this.fContentProvider.getChildren(ctx);
                int i = 0;
                while (i < threads.length) {
                    this.checkContext((Context)threads[i], checked);
                    ++i;
                }
            }
            this.checkThread(ctx, checked);
        }

        private void checkThread(Context thread, boolean checked) {
            TCFThreadFilterEditor.this.getThreadViewer().setChecked((Object)thread, checked);
            TCFThreadFilterEditor.this.getThreadViewer().setGrayed((Object)thread, false);
        }

        private void updateParentCheckState(Context thread) {
            Context parent = TCFThreadFilterEditor.this.getContainer(thread);
            if (parent == null && (parent = TCFThreadFilterEditor.this.getLaunch(thread)) == null) {
                return;
            }
            Object[] threads = TCFThreadFilterEditor.this.fContentProvider.getChildren(parent);
            int checkedNumber = 0;
            int grayedNumber = 0;
            int i = 0;
            while (i < threads.length) {
                if (TCFThreadFilterEditor.this.getThreadViewer().getGrayed(threads[i])) {
                    ++grayedNumber;
                } else if (TCFThreadFilterEditor.this.getThreadViewer().getChecked(threads[i])) {
                    ++checkedNumber;
                }
                ++i;
            }
            if (checkedNumber + grayedNumber == 0) {
                TCFThreadFilterEditor.this.getThreadViewer().setChecked((Object)parent, false);
                TCFThreadFilterEditor.this.getThreadViewer().setGrayed((Object)parent, false);
            } else if (checkedNumber == threads.length) {
                TCFThreadFilterEditor.this.getThreadViewer().setChecked((Object)parent, true);
                TCFThreadFilterEditor.this.getThreadViewer().setGrayed((Object)parent, false);
            } else {
                TCFThreadFilterEditor.this.getThreadViewer().setGrayChecked((Object)parent, true);
            }
            if (parent instanceof Context) {
                this.updateParentCheckState(parent);
            }
        }
    }

    private static class Context {
        private final String fName;
        private final String fId;
        private final String fParentId;
        private final boolean fIsContainer;
        private final String fScopeId;
        private final String fSessionId;
        private final String fBpGroup;
        private final Object fAdditionalInfo;

        Context(IRunControl.RunControlContext ctx, Context parent) {
            this(ctx, parent.fSessionId);
        }

        Context(IRunControl.RunControlContext ctx, String sessionId) {
            this.fName = ctx.getName();
            this.fSessionId = sessionId;
            this.fScopeId = sessionId != null ? String.valueOf(sessionId) + '/' + ctx.getID() : ctx.getID();
            this.fId = ctx.getID();
            this.fParentId = ctx.getParentID();
            this.fIsContainer = !ctx.hasState();
            this.fBpGroup = ctx.getBPGroup();
            this.fAdditionalInfo = ctx.getProperties().get("AdditionalInfo");
        }

        public boolean equals(Object obj) {
            return obj instanceof Context && this.fScopeId.equals(((Context)obj).fScopeId);
        }

        public int hashCode() {
            return this.fScopeId.hashCode();
        }
    }

    private class ExpressionModifier
    implements ModifyListener {
        private ExpressionModifier() {
        }

        public void modifyText(ModifyEvent e) {
            String expression = TCFThreadFilterEditor.this.scopeExprCombo.getText();
            String error = TCFThreadFilterEditor.this.validateBasicSyntax(expression);
            if (error != null) {
                TCFThreadFilterEditor.this.scopeExpressionDecoration.show();
                TCFThreadFilterEditor.this.fPage.setErrorMessage(error);
                TCFThreadFilterEditor.this.fPage.setValid(false);
            } else {
                TCFThreadFilterEditor.this.fContextList.clear();
                if (expression != null && expression.length() != 0) {
                    error = TCFThreadFilterEditor.this.getQueryFilteredContexts(expression, TCFThreadFilterEditor.this.fContextList);
                }
                if (error == null) {
                    TCFThreadFilterEditor.this.scopeExpressionDecoration.hide();
                    TCFThreadFilterEditor.this.fPage.setErrorMessage(null);
                    TCFThreadFilterEditor.this.fPage.setValid(true);
                } else if (error == Messages.TCFThreadFilterEditorNoOpenChannel) {
                    TCFThreadFilterEditor.this.scopeExpressionDecoration.hide();
                    TCFThreadFilterEditor.this.fPage.setErrorMessage(NLS.bind((String)Messages.TCFThreadFilterEditor_cannotValidate, (Object)error));
                    TCFThreadFilterEditor.this.fPage.setValid(true);
                } else {
                    TCFThreadFilterEditor.this.scopeExpressionDecoration.show();
                    TCFThreadFilterEditor.this.fPage.setErrorMessage(error);
                    TCFThreadFilterEditor.this.fPage.setValid(false);
                }
                TCFThreadFilterEditor.this.scopeExprCombo.getParent().layout();
                if (TCFThreadFilterEditor.this.fThreadViewer != null) {
                    TCFThreadFilterEditor.this.fThreadViewer.refresh();
                    TCFThreadFilterEditor.this.fFilteredContexts.clear();
                    TCFThreadFilterEditor.this.setInitialCheckedState();
                }
            }
        }
    }

    private class ExpressionSelectButton
    implements Listener {
        private Shell parentShell;

        public ExpressionSelectButton(Shell shell) {
            this.parentShell = shell;
        }

        public void handleEvent(Event event) {
            String[] attrsList = TCFThreadFilterEditor.this.getAvailableAttributes();
            if (attrsList == null) {
                TCFThreadFilterEditor.this.fPage.setErrorMessage(NLS.bind((String)Messages.TCFThreadFilterEditor_cannotRetrieveAttrs, (Object)Messages.TCFThreadFilterEditorNoOpenChannel));
            } else if (attrsList.length == 0) {
                TCFThreadFilterEditor.this.fPage.setErrorMessage(Messages.TCFThreadFilterEditor_cannotEditExpr);
            } else {
                TCFContextQueryExpressionDialog dlg = new TCFContextQueryExpressionDialog(this.parentShell, attrsList, TCFThreadFilterEditor.this.scopeExprCombo.getText());
                if (dlg.open() == 0) {
                    TCFThreadFilterEditor.this.scopeExprCombo.setText(dlg.getExpression());
                }
            }
        }
    }

    public class ThreadFilterContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parent) {
            if (parent instanceof Context) {
                return this.filterList(TCFThreadFilterEditor.this.syncGetThreads((Context)parent));
            }
            if (parent instanceof ILaunch) {
                return this.filterList(TCFThreadFilterEditor.this.syncGetContainers((TCFLaunch)parent));
            }
            if (parent instanceof ILaunchManager) {
                return this.filterList(TCFThreadFilterEditor.this.getLaunches());
            }
            return new Object[0];
        }

        public Object[] filterList(Object[] resultArray) {
            ArrayList<Object> filteredList = new ArrayList<Object>();
            String filterExpr = null;
            if (TCFThreadFilterEditor.this.scopeExprCombo != null) {
                filterExpr = TCFThreadFilterEditor.this.scopeExprCombo.getText();
            }
            Object[] objectArray = resultArray;
            int n = resultArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof ILaunch || obj instanceof ILaunchManager) {
                    filteredList.add(obj);
                } else if (obj instanceof Context) {
                    Object[] childArray;
                    Context context = (Context)obj;
                    if ((filterExpr == null || filterExpr.length() == 0 || TCFThreadFilterEditor.this.fContextList.contains(context.fId)) && context.fBpGroup != null) {
                        filteredList.add(obj);
                        TCFThreadFilterEditor.this.fFilteredContexts.add(obj);
                    } else if (context.fIsContainer && (childArray = this.getChildren(obj)) != null && childArray.length != 0) {
                        filteredList.add(obj);
                        TCFThreadFilterEditor.this.fFilteredContexts.add(obj);
                    }
                }
                ++n2;
            }
            return filteredList.toArray(new Object[filteredList.size()]);
        }

        public Object getParent(Object element) {
            if (element instanceof Context) {
                Context ctx = (Context)element;
                if (ctx.fParentId == null) {
                    return DebugPlugin.getDefault().getLaunchManager();
                }
                return TCFThreadFilterEditor.this.getContainer(ctx);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class ThreadFilterLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            ImageDescriptor desc;
            if (element instanceof Context) {
                Context ctx = (Context)element;
                if (ctx.fIsContainer) {
                    return DebugUITools.getImage((String)"IMG_OBJS_DEBUG_TARGET");
                }
                return DebugUITools.getImage((String)"IMG_OBJS_THREAD_RUNNING");
            }
            if (element instanceof ILaunch && (desc = DebugUITools.getDefaultImageDescriptor((Object)element)) != null) {
                return ImageCache.getImage(desc);
            }
            return null;
        }

        public String getText(Object element) {
            ILaunchConfiguration config;
            if (element instanceof Context) {
                Context ctx = (Context)element;
                String s = ctx.fName;
                if (s == null) {
                    s = ctx.fId;
                }
                if (ctx.fAdditionalInfo != null) {
                    s = String.valueOf(s) + ctx.fAdditionalInfo.toString();
                }
                return s;
            }
            if (element instanceof ILaunch && (config = ((ILaunch)element).getLaunchConfiguration()) != null) {
                return config.getName();
            }
            return "?";
        }
    }

    public class linkSelectAdapter
    implements SelectionListener {
        private Shell parentShell;

        public linkSelectAdapter(Shell shell) {
            this.parentShell = shell;
        }

        public void widgetSelected(SelectionEvent e) {
            PreferencesUtil.createPreferenceDialogOn((Shell)this.parentShell, (String)"org.eclipse.tcf.cdt.ui.preferences.BreakpointPreferencePage", (String[])new String[]{"org.eclipse.tcf.cdt.ui.preferences.BreakpointPreferencePage"}, null).open();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

