/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.vectorgraphics2d.intermediate.filters;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.CommandSequence;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.Command;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.DisposeCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.DrawImageCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.FillShapeCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.SetPaintCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.filters.StreamingFilter;

public class FillPaintedShapeAsImageFilter
extends StreamingFilter {
    private SetPaintCommand lastSetPaintCommand;

    public FillPaintedShapeAsImageFilter(CommandSequence stream) {
        super(stream);
    }

    @Override
    public Command<?> next() {
        Object nextCommand = super.next();
        if (nextCommand instanceof SetPaintCommand) {
            this.lastSetPaintCommand = (SetPaintCommand)nextCommand;
        } else if (nextCommand instanceof DisposeCommand) {
            this.lastSetPaintCommand = null;
        }
        return nextCommand;
    }

    private DrawImageCommand getDrawImageCommand(FillShapeCommand shapeCommand, SetPaintCommand paintCommand) {
        Shape shape = (Shape)shapeCommand.getValue();
        Rectangle2D shapeBounds = shape.getBounds2D();
        double x = shapeBounds.getX();
        double y = shapeBounds.getY();
        double width = shapeBounds.getWidth();
        double height = shapeBounds.getHeight();
        int imageWidth = (int)Math.round(width);
        int imageHeight = (int)Math.round(height);
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics2D imageGraphics = (Graphics2D)image.getGraphics();
        imageGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        imageGraphics.scale((double)imageWidth / width, (double)imageHeight / height);
        imageGraphics.translate(-shapeBounds.getX(), -shapeBounds.getY());
        imageGraphics.setPaint((Paint)paintCommand.getValue());
        imageGraphics.fill(shape);
        imageGraphics.dispose();
        return new DrawImageCommand(image, imageWidth, imageHeight, x, y, width, height);
    }

    @Override
    protected List<Command<?>> filter(Command<?> command) {
        if (this.lastSetPaintCommand != null && command instanceof FillShapeCommand) {
            FillShapeCommand fillShapeCommand = (FillShapeCommand)command;
            DrawImageCommand drawImageCommand = this.getDrawImageCommand(fillShapeCommand, this.lastSetPaintCommand);
            return Collections.singletonList(drawImageCommand);
        }
        return Collections.singletonList(command);
    }
}

