/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.emf.ui.forms;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.statet.ecommons.emf.core.databinding.IEMFEditContext;
import org.eclipse.statet.ecommons.emf.ui.forms.EFProperty;
import org.eclipse.statet.ecommons.emf.ui.forms.IEFFormPage;
import org.eclipse.swt.widgets.Composite;

public class EFPropertySet {
    private final List<EFProperty> list = new ArrayList<EFProperty>(8);

    public void add(EFProperty property) {
        if (property != null) {
            this.list.add(property);
        }
    }

    public void createControls(Composite parent, IEFFormPage toolkit) {
        for (EFProperty property : this.list) {
            property.create(parent, toolkit);
        }
    }

    public void bind(IEMFEditContext context) {
        for (EFProperty property : this.list) {
            property.bind(context);
        }
    }

    public EFProperty get(EStructuralFeature eFeature) {
        for (EFProperty property : this.list) {
            if (property.getEFeature() != eFeature) continue;
            return property;
        }
        return null;
    }

    public List<EFProperty> getAll() {
        return this.list;
    }

    public List<IObservable> getModelObservables() {
        ArrayList<IObservable> observables = new ArrayList<IObservable>();
        for (EFProperty property : this.list) {
            IObservable observable = property.getPropertyObservable();
            if (observable == null) continue;
            observables.add(observable);
        }
        return observables;
    }
}

